
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit General;
interface
{$L general.obj}

procedure FastMove  (var Source, Dest;
                     Count             :Word);

procedure FastFill  (var Buffer;
                     Count             :Word;
                     Value             :Byte);

function  MemCompare(var m1, m2;
                     Count             :Word)    :Word;

procedure CopyDiff  (var OldSource, NewSource, Dest;
                     Count             :Word);


function  HeapContains(P               :Pointer) :Boolean;

function  Min(A, B                     :Integer) :Integer;
function  Max(A, B                     :Integer) :Integer;

procedure SwapInts   (var A, B         :Integer);

procedure ArrangeInts(var A, B         :Integer);
{ Make A<=B }

implementation

procedure FastMove; External;
procedure FastFill; External;
function  MemCompare; External;
procedure CopyDiff; External;

function  HeapContains;
assembler;
asm
   mov  si,P.Word[0]
   mov  cl,4
   shr  si,cl
   add  si,P.Word[2]
   xor  ax,ax
   cmp  si,HeapOrg.Word[2]
   jb   @@1
   cmp  si,HeapEnd.Word[2]
   ja   @@1
   inc  ax
@@1:
end;

function  Min;
assembler;
asm
   mov  ax,A
   cmp  ax,B
   jle  @@1
   mov  ax,B
@@1:
end;

function  Max;
assembler;
asm
   mov  ax,A
   cmp  ax,B
   jg   @@1
   mov  ax,B
@@1:
end;

procedure SwapInts;
assembler;
asm
   push ds
   lds  si,A
   les  di,B
   mov  ax,[si]
   mov  dx,es:[di]
   mov  es:[di],ax
   mov  [si],dx
   pop  ds
end;

procedure ArrangeInts;
assembler;
asm
   push ds
   lds  si,A
   les  di,B
   mov  ax,[si]
   mov  dx,es:[di]
   cmp  ax,dx
   jle  @@1
   mov  es:[di],ax
   mov  [si],dx
@@1:
   pop  ds
end;

end.
