
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit GDrivers;
{$X+,I-,S-,P-,V-}
{$C FIXED PRELOAD PERMANENT}

interface

   uses
      KeyMouse, Events, Utils, GRect, Language,
      Objects,
      GraphDrv, GBuffer,
      UniFont;

{ ******** SCREEN MANAGER ******** }

   const
      DriverExt  = '.DRV';
      ErrorColor = 0;

   var
      ScreenWidth,
      ScreenHeight :Word;
      MaxColor     :Byte;
      DriverName   :String[8];
      DriverMode   :Word;

   type
      PTextStyle = ^TTextStyle;
      TTextStyle =
      object
{ For vector fonts only }
         SizeX, DivX, SizeY, DivY      :Integer;

{ For both vector & raster fonts }
         Font                          :PFontHeader;

{ For vector fonts only }
         procedure Defaults;
         procedure SetSize(X, Y        :Integer);

{ For both vector & raster fonts }
         function  Width               :Integer;
         function  Height              :Integer;
      end;

{ Screen manager routines }

   procedure InitVideo(const Driver    :String;
                       Mode            :Word  );
   procedure DoneVideo;

{ ******** SYSTEM ERROR HANDLER ******** }

   type
{ System error handler function type }
      TSysErrorFunc =
      function(ErrorCode               :Integer;
               Drive                   :Byte)    :Integer;

      TSysErrorColors =
      record
         Back, Normal, High            :Byte;
      end;

{ Default system error handler routine }

   function SystemError(ErrorCode      :Integer;
                        Drive          :Byte)    :Integer;

   const
   { Initialized variables }

      SaveInt09    :Pointer =          nil;   { These three variables are }
      CtrlBreakHit :Boolean =          False; { used in SYSINT.OBJ }
      SaveCtrlBreak:Boolean =          False;

      SysErrorFunc :TSysErrorFunc =    SystemError;

      SysErrorAttr :TSysErrorColors =
      (Back:Red; Normal:White; High:Yellow);

      AutoAdjustMsg:Boolean =          True;

      SysErrActive :Boolean =          False;
      FailSysErrors:Boolean =          False;

   var
      ErrorFont    :TTextStyle;

{ System error handler routines }

   procedure InitSysError;
   procedure DoneSysError;

   procedure Abort(Const Message       :String);

   function  GetPath                   :PathStr;

implementation
uses
   GApp, GViews;

{ ******** SYSTEM ERROR HANDLER ******** }

{$IFDEF DPMI}
{$L SYSINT.OBP}
{$ELSE}
{$L SYSINT.OBJ}
{$ENDIF}

{ System error handler routines }

procedure InitSysError; external;
procedure DoneSysError; external;

function SelectKey: Integer; near; assembler;
asm
@@1:	MOV	AH,1
	INT	16H
	PUSHF
	MOV	AH,0
	INT	16H
	POPF
	JNE	@@1
	XOR	DX,DX
	CMP	AL,13
	JE	@@2
	INC	DX
	CMP	AL,27
	JNE	@@1
@@2:    MOV     AX,DX
end;

function SystemError(ErrorCode         :Integer;
                     Drive             :Byte)    :Integer;
const
   Space='    ';

var
   P               :Pointer;
   S, Res          :String[63];
   Rem             :String[47];
   Font            :TTextStyle;
   L               :Integer;
   R               :TGRect;

   TextC           :record
      Back         :Byte;
      Text         :Word;
   end absolute SysErrorAttr;

begin
   GetErrorMessage(ErrorCode, S);
   if FailSysErrors or (S='') then
   begin
      SystemError := 1; Exit;
   end;

   P := Pointer(Drive + Ord('A'));
   FormatStr(Res, S, P);

   GetErrorMessage(-1, Rem);

   HideMouse;

   Font:=ErrorFont;

   if AutoAdjustMsg then
   with Font do
   begin
      L:=(Byte(Res[0])+Length(Space)+CStrLen(Rem))*Width;
      if L>ScreenWidth then
      begin
         SizeX:=LongDiv(LongMul(ScreenWidth, SizeX), DivX); DivX:=L;
      end;
   end;

   Application^.GetExtent(R); R.A.Y:=R.B.Y-ErrorFont.Height;
   Application^.DrawBar(R, SysErrorAttr.Back); Inc(R.A.Y);
   Application^.DrawText(R.A, Res+Space+Rem, tfNormal+tfColored,
      @Font, TextC.Text);

   if ScreenLocked then BufferToScreen;

   SystemError := SelectKey;
   Application^.Redraw;

   ShowMouse;
end;

procedure TTextStyle.Defaults; assembler;
asm
   les  di,Self
   add  di,offset TTextStyle.SizeX
   mov  ax,1
   cld
   stosw
   stosw
   stosw
   stosw
   dec  ax
   stosw
   stosw
end;

procedure TTextStyle.SetSize;
begin
   SizeX:=X; DivX:=1; SizeY:=Y; DivY:=1;
end;

function  TTextStyle.Width;
begin
   if (Font=nil) or (Font^.Class=fcVector)
   then Width:=(SizeX shl 3) div DivX
   else Width:=Font^.Width;
end;

function  TTextStyle.Height;
begin
   if (Font=nil) or (Font^.Class=fcVector)
   then Height:=(SizeY shl 3) div DivY
   else Height:=Font^.Height;
end;

function  GetPath;
var
   Path            :PathStr;
begin
   Path:=ParamStr(0);
   while (Path<>'') and (Path[Length(Path)]<>'\') do Dec(Path[0]);
   GetPath:=Path;
end;

procedure InitVideo;
begin
   if DriverPtr<>nil then DoneVideo;

   if LoadDriver(GetPath+Driver+DriverExt)<>gdOk then
      Abort('Error loading graphics driver');
   if Mode<>0 then InitDriver(Mode);
   if SetGraphMode<>gdOk then
      Abort('Graphics hardware not detected');

   if not Supported(Text_Init) then
   begin
      Text_Init:=UText_Init; Text_Advance:=UText_Advance;
      Text_Show8xX:=UText_Show8xX;
      Pointer(@UText_PutPixel^):=@GraphDrv.PutPixel;
   end;

   ScreenWidth:=DriverPtr^.SizeX; ScreenHeight:=DriverPtr^.SizeY;
   MaxColor:=DriverPtr^.MaxColor;

   KeyMouse.UseMouse:=(DriverPtr^.MouseConvX<>$FF);
   if (not KeyMouse.UseMouse) and
      MouseEmulInst and GraphDrv.Supported(GraphDrv.PutBlock) then
   begin
      KeyMouse.MouseConvX:=0; KeyMouse.MouseConvY:=0;
      KeyMouse.UseMouse:=True;
   end
   else
   begin
      KeyMouse.MouseConvX:=DriverPtr^.MouseConvX;
      KeyMouse.MouseConvY:=DriverPtr^.MouseConvY;
   end;
   KeyMouse.MouseVisible:=0;

   DriverName:=Driver; DriverMode:=Mode;
end;

procedure DoneVideo;
begin
   CloseGraph;
end;

{ GDrivers unit initialization and shutdown }

var
   SaveExit        :Pointer;

procedure ExitDrivers; far;
begin
   DoneSysError;
   ExitProc := SaveExit;
end;

procedure Abort;
begin
   DoneVideo; ExitDrivers; WriteLn(Message); Halt($FF);
end;

begin
   DriverName:=''; DriverMode:=0;
   ErrorFont.Defaults;

   SaveExit := ExitProc; ExitProc := @ExitDrivers;
end.
