
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit GBuffer;
interface
   uses
      GraphDrv, KeyMouse;

   const
      ScreenLockCount        :Integer= 0;

   procedure LockScreen;
   procedure UnlockScreen;
   function  ScreenLocked    :Boolean;

implementation

   procedure LockScreen;
   begin
      if not Supported(ScreenToBuffer) then Exit;

      if ScreenLockCount=0 then
      begin
         HideMouse;
         ScreenToBuffer;
         ShowMouse;
         SetDriverOutput(ToBuffer);
      end;
      Inc(ScreenLockCount);
   end;

   procedure UnlockScreen;
   begin
      Dec(ScreenLockCount);
      if ScreenLockCount=0 then
      begin
         HideMouse;
         BufferToScreen;
         ShowMouse;
         SetDriverOutput(ToScreen);
      end;
   end;

   function ScreenLocked;
   begin
      ScreenLocked:=(ScreenLockCount>0);
   end;

end.
