
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit Events;
interface
uses
   GRect;

const

{ Event codes }

   evMouseDown =   $0001;
   evMouseUp   =   $0002;
   evMouseMove =   $0004;
   evMouseAuto =   $0008;
   evKeyDown   =   $0010;
   evCommand   =   $0100;
   evBroadcast =   $0200;

{ Event masks }

   evNothing   =   $0000;
   evMouse     =   $000F;
   evKeyboard  =   $0010;
   evMessage   =   $FF00;

type

{ Event record }

   PEvent =        ^TEvent;
   TEvent =
   record
      What         :Word;
      case Word of
       evNothing: ();
       evMouse: (
          Buttons  :Byte;
          Double   :Boolean;
          Where    :TGPoint);
       evKeyDown: (
          case Integer of
	     0: (KeyCode     :Word);
             1: (CharCode    :Char;
                 ScanCode    :Byte));
       evMessage: (
          Command  :Word;
          case Word of
             0: (InfoPtr     :Pointer);
             1: (InfoLong    :Longint);
             2: (InfoWord    :Word);
             3: (InfoInt     :Integer);
             4: (InfoByte    :Byte);
             5: (InfoChar    :Char));
   end;

implementation
end.
