
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Multi-Sprites Editor Unit                       }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit ReadFmt;
interface
{$I-}
uses
   Objects, GDrivers,
   HistList;

type
   TImageFormat =
   record
      Name,
      FormatId     :PString;
      HeaderSize,
      FSizeOfs,
      FSizeSize,
      SizesOfs,
      SizesSize,
      FSizeInc,
      SizesInc,
      PaletteOfs   :Integer;
      PaletteWin   :Boolean;
      Reverse      :Boolean;
   end;

const
   MaxFormats =    32;
   FormatsFile =   'MSEDIT.FMT';

   hiImage =       100;

var
   Formats         :Array [0..MaxFormats] of TImageFormat;
const
   FormatsCount    :Integer= 0;
   MaxHeaderSize   :Integer= 0;

procedure ReadFormats;

implementation

procedure ReadFormats;
var
   f               :Text;
   S               :String[80];
   Op              :String[23];
   Ln, p, i        :Integer;
   LnS             :String[7];
   PS              :PString;

function  Value(Min, Max               :Integer) :Integer;
var
   Res, Error      :Integer;
begin
   Val(Copy(S, p+1, 255), Res, Error);
   if Error<>0 then
      Abort('Invalid number in '+FormatsFile+', line #'+LnS);
   if (Res<Min) or (Res>Max) then
      Abort('Number not in valid range in '+FormatsFile+', line #'+LnS);
   Value:=Res;
end;

function  StrParam                               :PString;
begin
   Delete(S, 1, p);
   if (S='') or (S[1]<>'''') or (S[Length(S)]<>'''') then
      Abort('Invalid string parameter in '+FormatsFile+', line #'+LnS);
   Delete(S, 1, 1); Dec(S[0]);
   StrParam:=NewStr(S);
end;

begin
   FillChar(Formats, SizeOf(Formats), $FF);
   for i:=1 to MaxFormats do
   with Formats[i] do
   begin
      FSizeInc:=0; SizesInc:=0; PaletteOfs:=-1;
      FormatId:=nil; Reverse:=False;
   end;

   Assign(f, GetPath+FormatsFile); Reset(f);
   Ln:=0;
   while not EOF(f) do
   begin
      Inc(Ln); Str(Ln, LnS);
      ReadLn(f, S);

      while (S<>'') and ((S[1]=' ') or (S[1]=#9)) do Delete(S, 1, 1);
      while (S<>'') and ((S[Length(S)]=' ') or (S[Length(S)]=#9)) do Dec(S[0]);

      if (S='') or (S[1]=';') then Continue;

      p:=Pos('=', S);
      Op:=S; if p>0 then Op[0]:=Chr(p-1);
      for i:=1 to Length(Op) do Op[i]:=UpCase(Op[i]);

      if Op='FORMAT' then
      begin
         Inc(FormatsCount);
         if FormatsCount>MaxFormats then
            Abort('Too many format definitions in '+FormatsFile);
         Formats[FormatsCount].Name:=StrParam;
      end else
      with Formats[FormatsCount] do
      if Op='FORMATID' then FormatId:=StrParam else
      if Op='HEADERSIZE' then HeaderSize:=Value(4, 2048) else
      if Op='FILESIZEOFFSET' then FSizeOfs:=Value(0, 2046) else
      if Op='SIZESOFFSET' then SizesOfs:=Value(0, 2046) else
      if Op='FILESIZEINCREMENT' then FSizeInc:=Value(-2048, 2048) else
      if Op='SIZESINCREMENT' then SizesInc:=Value(-1024, 1024) else
      if Op='FILESIZEFIELDSIZE' then FSizeSize:=Value(2, 4) else
      if Op='SIZESFIELDSIZE' then SizesSize:=Value(2, 4) else
      if Op='PALETTEOFFSET' then PaletteOfs:=Value(0, 2046) else
      if Op='WINDOWSPALETTE' then PaletteWin:=True else
      if Op='REVERSE' then Reverse:=True else
      if Op='EXTENSION' then
      begin
         PS:=StrParam;
         if PS^[0]>#3 then
            Abort('Invalid extension in '+FormatsFile+', line #'+LnS);
         HistoryAdd(hiImage, '*.'+PS^); DisposeStr(PS);
      end
      else Abort('Invalid command in '+FormatsFile+', line #'+LnS);
   end;
   Close(f);
   if IOResult<>0 then Abort('Unable to read '+FormatsFile);
   if FormatsCount=0 then Abort('No formats defined in '+FormatsFile);

   for i:=1 to FormatsCount do
   with Formats[i] do
   begin
      if (HeaderSize<0) or (SizesOfs<0) or
         ((FSizeOfs>=0) and (FSizeSize<0)) or (SizesSize<0) then
         Abort('Not enough parameters for image format '''+Name^+''' in '+FormatsFile);
      if MaxHeaderSize<HeaderSize then MaxHeaderSize:=HeaderSize;
   end;
end;

end.
