
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Multi-Sprites Editor                            }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

program MSEdit;
{$M 8192,0,655360}
{$B-,V-}
uses
   Objects,
   English,
   F8x8A, F8x14A, F8x16A, F8x19A,
   GraphDrv, GDrivers, General, GRect, GPalette,
   GApp, GViews, GMenus, GDialogs, GValid,
   GMsgBox, GStdDlg,
   Events, KeyMouse, HistList,
   MousePtr, StdVideo, GModes,
   RGB,
   SEditor, LPalette, Hints, ReadFmt,
   DOS;

const
   VStr =                    '4.5';
   SpriteWildCard =          '*.SPR';
   PaletteWildCard =         '*.PAL';
   ConfigFile =              'MSEDIT.CFG';

   DefaultNull     :TRGBColor =
   (R:$1F; G:$1F; B:$1F);

   cmConvert =     $D0;

   cmSaveOpts =    6000;

   hiNew =         200;

   hiPalette =     110;

   CFormatsListBox=
   cpMain+cpLightGray + CListViewer;

type
   PFormatsListBox=^TFormatsListBox;
   TFormatsListBox=
   object(TListBox)

      function  GetPalette                       :TPalette; virtual;

   end;

   TEditApp=
   object(TApplication)

      Config       :record
         Driver    :String[8];
         Mode      :Word;
      end;

      WinCount     :Integer;

      constructor Init;

      procedure InitScreen; virtual;

      procedure InitDesktop; virtual;
      procedure InitMenuBar; virtual;
      procedure InitStatusLine; virtual;
      procedure GetTileRect(var R      :TGRect); virtual;

      procedure DosShell; virtual;

      procedure HandleEvent(var Event  :TEvent); virtual;

      procedure OutOfMemory; virtual;

      function  FindEditWindow                   :PGEditor;

      procedure FileNew;
      procedure FileOpen;
      procedure FileSave(W             :PGEditor;
                         SaveAs        :Boolean);
      procedure FileSaveAll;

      procedure FileInfo;
      procedure FileConvert(W          :PGEditor);

      procedure MakeList(D             :PDialog;
                         var R         :TGRect;
                         const Msg     :String;
                         var List      :PCollection;
                         var NumList   :Array of Integer;
                         var ListBox   :PFormatsListBox);

      procedure EditUndo;

      procedure EditFlip(Cmd           :Word);

      procedure PaletteLoad;
      procedure PaletteStd;

      procedure Scale(Change           :Integer);

      procedure SetVideoMode(ModeCmd   :Word);

      procedure SaveConfig;
      procedure LoadConfig;
   end;

{ TFormatsListBox }

function  TFormatsListBox.GetPalette;
begin
   GetPalette:=CFormatsListBox;
end;

{ TEditApp }

constructor TEditApp.Init;
var
   R               :TGRect;
   i               :Integer;
   SR              :SearchRec;
   Dir             :DirStr;
begin
   ForceMouseEmul:=True;
   HistorySize:=4096;

   LoadConfig;
   Inherited Init(Config.Driver, Config.Mode);

   GetRGBBlock(0, 256, @PaletteRGB);
   PaletteRGB[NullColor]:=DefaultNull;
   SetRGB(NullColor, DefaultNull);
   Move(PaletteRGB, StandardPalette, SizeOf(StandardPalette));
   InfoBar^.DrawView;

   ReadFormats;

   HistoryAdd(hiNew, '64');
   HistoryAdd(hiNew, '32');
   HistoryAdd(hiNew, '16');
   HistoryAdd(hiNew, '320');
   HistoryAdd(hiNew, '200');

   HistoryAdd(hiImage, '*.*');

   HistoryAdd(hiPalette, '*.*');

   DisableCommands([cmSave, cmSaveAs, cmSaveAll, cmConvert,
      cmUndo, cmPaletteStd, cmScaleDown, cmScaleUp,
      cmFlipX, cmFlipY]);

   if not MouseEvents then
   MessageBox(
      ^M^C'Mouse driver not detected.'^S#4+
      ^C'You will not be able'^S#4+
      ^C'to edit images.', nil, mfWarning+mfOKButton);

   for i:=1 to ParamCount do
   begin
      FSplit(FExpand(ParamStr(i)), Dir, SR.Name, SR.Name);
      FindFirst(ParamStr(i), Archive+ReadOnly, SR);
      while DosError=0 do
      begin
         Desktop^.Background^.GetExtent(R);
         if InsertWindow(New(PGEditor,
            Init(R, Dir+SR.Name, wnNoNumber)))<>nil then
         begin
            Inc(WinCount);
            EnableCommands([cmSave, cmSaveAs, cmSaveAll, cmConvert,
               cmUndo, cmFlipX, cmFlipY]);
         end;
         FindNext(SR);
      end;
   end;
end;

procedure TEditApp.InitScreen;
begin
   Inherited InitScreen;

   case ScreenHeight of
      0..300:   SystemFont.Font:=@Font8x8A;
      301..400: SystemFont.Font:=@Font8x14A;
      401..480: SystemFont.Font:=@Font8x16A;
      else      SystemFont.Font:=@Font8x19A;
   end;

   PaletteGrid.X:=ScreenWidth div 80; PaletteGrid.Y:=ScreenHeight div 40;
end;

procedure TEditApp.InitDesktop;
var
   R               :TGRect;
begin
   Inherited InitDesktop;
   Desktop^.LockDraw;
   Desktop^.GetExtent(R);
   New(PaletteBox, Init(R));
   with Desktop^.Background^ do GrowTo(R.A.X - 1, Size.Y - 1);
   Desktop^.Insert(PaletteBox);
   Desktop^.Background^.GetBounds(R);
   R.A.Y:=R.B.Y - 2 - CharHeight;
   New(InfoBar, Init(R));
   Desktop^.Insert(InfoBar);
   with Desktop^.Background^ do GrowTo(Size.X - 1, InfoBar^.Origin.Y - 1);
   Desktop^.UnlockDraw; Desktop^.Redraw;
end;

procedure TEditApp.GetTileRect;
begin
   Desktop^.Background^.GetExtent(R);
end;

procedure TEditApp.InitMenuBar;
begin
   MenuBar := New(PMenuBar, Standard(NewMenu(
     NewSubMenu('~F~ile', hcFileMenu, NewMenu(
       NewItem('A~b~out...', 'F1', kbF1, cmAbout, hcAbout,
       NewLine(
       NewItem('~N~ew...', '', kbNoKey, cmNew, hcNew,
       NewItem('~O~pen...', 'F3', kbF3, cmOpen, hcOpen,
       NewItem('~S~ave', 'F2', kbF2, cmSave, hcSave,
       NewItem('S~a~ve as...', '', kbNoKey, cmSaveAs, hcSaveAs,
       NewItem('Save a~l~l', '', kbNoKey, cmSaveAll, hcSaveAll,
       NewItem('Conve~r~t...', '', kbNoKey, cmConvert, hcConvert,
       NewSubMenu('~P~alette', hcPaletteMenu, NewMenu(
         NewItem('~L~oad...', 'Alt+L', kbAltL, cmPaletteLoad, hcPaletteLoad,
         NewItem('~S~tandard', '', kbNoKey, cmPaletteStd, hcPaletteStd,
       nil))),
       NewLine(
       NewItem('~I~nformation...', '', kbNoKey, cmInfo, hcInfo,
       NewItem('~C~hange dir...', '', kbNoKey, cmChangeDir, hcChangeDir,
       NewItem('~D~OS shell', '', kbNoKey, cmDosShell, hcDosShell,
       NewItem('E~x~it', 'Alt+X', kbAltX, cmQuit, hcExit,
     nil))))))))))))))),
     NewSubMenu('~E~dit', hcEditMenu, NewMenu(
       NewItem('~U~ndo', 'Alt+BkSp', kbAltBack, cmUndo, hcUndo,
       NewLine(
       NewItem('~S~et color', 'Ctrl+S', kbCtrlS, cmSetColor, hcSetColor,
       NewItem('~G~et color', 'Ctrl+G', kbCtrlG, cmGetColor, hcGetColor,
       NewItem('~F~ill area', 'Ctrl+F', kbCtrlF, cmFillArea, hcFillArea,
       NewLine(
       NewItem('~R~ectangle', 'Ctrl+R', kbCtrlR, cmRectangle, hcRectangle,
       NewItem('~B~ar', 'Ctrl+B', kbCtrlB, cmBar, hcBar,
       NewItem('~L~ine', 'Ctrl+L', kbCtrlL, cmLine, hcLine,
       NewLine(
       NewItem('Flip ~X~', '', kbNoKey, cmFlipX, hcFlipX,
       NewItem('Flip ~Y~', '', kbNoKey, cmFlipY, hcFlipY,
     nil))))))))))))),
     NewSubMenu('~W~indow', hcWindowMenu, NewMenu(StdWindowMenuItems(
       NewLine(
       NewItem('Scale ~d~own', 'Gray -', kbGrayMinus, cmScaleDown, hcScaleDown,
       NewItem('Scale ~u~p', 'Gray +', kbGrayPlus, cmScaleUp, hcScaleUp,
     nil))))),
     NewSubMenu('~V~ideo', hcVideoMenu, NewMenu(
       NewSubMenu('VGA ~L~ow', hcLow, NewMenu(
         NewItem('~1~ 320x200', '', kbNoKey, cm320x200x256, hcVideoVGA,
         NewItem('~2~ 320x133', '', kbNoKey, cm320x133x256, hcVideoLowVGA,
       nil))),
       NewSubMenu('VGA Mode~X~', hcModeX, NewMenu(
         NewItem('~1~ 320x240', '', kbNoKey, cm320x240x256, hcVideoExtVGA,
         NewItem('~2~ 376x282', '', kbNoKey, cm376x282x256, hcVideoExtVGA,
         NewItem('~3~ 320x400', '', kbNoKey, cm320x400x256, hcVideoExtVGA,
         NewItem('~4~ 320x480', '', kbNoKey, cm320x480x256, hcVideoExtVGA,
         NewItem('~5~ 360x480', '', kbNoKey, cm360x480x256, hcVideoExtVGA,
         NewItem('~6~ 360x360', '', kbNoKey, cm360x360x256, hcVideoExtVGA,
         NewItem('~7~ 376x308', '', kbNoKey, cm376x308x256, hcVideoExtVGA,
         NewItem('~8~ 376x564', '', kbNoKey, cm376x564x256, hcVideoExtVGA,
       nil))))))))),
       NewSubMenu('~S~VGA', hcSVGA, NewMenu(
         NewItem('~1~ 640x400', '', kbNoKey, cm640x400x256, hcVideoVESAHi,
         NewItem('~2~ 640x480', '', kbNoKey, cm640x480x256, hcVideoVESAHi,
         NewItem('~3~ 800x600', '', kbNoKey, cm800x600x256, hcVideoVESAHi,
         NewLine(
         NewItem('~4~ 512x512', '', kbNoKey, cm512x512x256, hcVideoRTVGA,
         NewItem('~5~ 1024x480', '', kbNoKey, cm1024x480x256, hcVideoTrident,
       nil))))))),
       NewLine(
       NewItem('S~a~ve', '', kbNoKey, cmSaveOpts, hcSaveOpts,
     nil)))))),
   nil)))))));
end;

procedure TEditApp.InitStatusLine;
begin
   StatusLine:=New(PHintStatusLine, Standard(
     NewStatusDef(0, $EFFF,
       NewStatusKey('~Alt+X~ Exit', kbAltX, cmQuit,
       NewStatusKey('~F2~ Save', kbF2, cmSave,
       NewStatusKey('~F3~ Open', kbF3, cmOpen,
       StdStatusKeys(nil)))),
     NewStatusDef($F000, $FFFF,
       StdStatusKeys(nil), nil))));
end;

procedure TEditApp.HandleEvent;
var
   W               :PGEditor;
begin
   Inherited HandleEvent(Event);
   case Event.What of
      evCommand:
      case Event.Command of
         cmAbout:
         MessageBox(
            ^C'Multi-Sprites Editor'^S#4+
            ^C'Version '+VStr+^S#4+
            ^C'Copyright '#252' 1994,95 by'^S#4+
            ^C'Solar Designer \ BPC', nil, mfInformation + mfOKButton);

         cmNew:
            FileNew;
         cmOpen:
            FileOpen;
         cmSave:
            FileSave(FindEditWindow, False);
         cmSaveAs:
            FileSave(FindEditWindow, True);
         cmSaveAll:
            FileSaveAll;

         cmRemoveWindow:
         begin
            Dec(WinCount);
            if WinCount=0 then
            begin
               DisableCommands([cmSave, cmSaveAs, cmSaveAll, cmConvert,
                  cmUndo, cmScaleDown, cmScaleUp, cmFlipX, cmFlipY]);
               InfoBar^.CorrectData:=False; InfoBar^.DrawPos;
            end;
         end;

         cmInfo:
            FileInfo;
         cmConvert:
            FileConvert(FindEditWindow);

         cmChangeDir:
            ExecuteDialog(New(PChDirDialog, Init(0, 12)), nil);

         cmUndo:
            EditUndo;

         cmSetColor..cmSetColor+99:
         if EditMode<>Event.Command then
         begin
            EditMode:=Event.Command;
            InfoBar^.DrawView;
         end;

         cmFlipX, cmFlipY:
            EditFlip(Event.Command);

         cmPaletteLoad:
            PaletteLoad;
         cmPaletteStd:
            PaletteStd;

         cmScaleDown:
            Scale(-1);
         cmScaleUp:
            Scale(1);

         cmSaveOpts:
            SaveConfig;

      else
         SetVideoMode(Event.Command);
      end;
      evMouseMove, evMouseUp:
      begin
         if Event.What=evMouseMove then PaletteBox^.Update(Event.Where);

         W:=FindEditWindow;
         if W<>nil then W^.Field^.HandleEvent(Event);
      end;
   end;
end;

procedure TEditApp.OutOfMemory;
begin
   MessageBox(^M^C'Not enough memory'^M^M^C'to complete operation.',
      nil, mfError + mfOKButton);
end;

function  TEditApp.FindEditWindow;

function  IsEditWindow(V               :PView)   :Boolean; far;
begin
   IsEditWindow:=(TypeOf(V^)=TypeOf(TGEditor)) and (V^.Owner^.Current=V);
end;

begin
   FindEditWindow:=PGEditor(Desktop^.FirstThat(@IsEditWindow));
end;

procedure TEditApp.MakeList;
var
   Fmt, PSize      :Integer;

   I, SBR          :TGRect;
   BS              :TGPoint;
   SB              :PScrollBar;
begin
   New(List, Init(FormatsCount, 1));
   for Fmt:=1 to FormatsCount do
   with Formats[Fmt] do
   begin
      if FormatId=nil then PSize:=0 else PSize:=Length(FormatId^);
      if FSizeSize>0 then Inc(PSize, FSizeSize);
      Inc(PSize, SizesSize shl 1);
      if (PSize=HeaderSize) and (Name<>nil) then
      begin
         NumList[List^.Count]:=Fmt; List^.Insert(Name);
      end;
   end;
   if List^.Count=0 then
   begin
      Dispose(List, Done); Dispose(D, Done); ListBox:=nil;
      MessageBox(
         ^M^C'Not enough definitions'+
         ^M^M^C'in '+FormatsFile+
         ^M^M^C'to '+Msg+'.',
         nil, mfError+mfOKButton);
   end;

   SBR:=R; SBR.A.X:=R.B.X+1;
   New(SB, Init(SBR, True)); D^.Insert(SB);
   New(ListBox, Init(R, 1, SB));
   ListBox^.GetBounds(R);
   R.A.X:=R.B.X+2; R.B.X:=R.A.X+SB^.Size.X-1; R.B.Y:=R.A.Y+ListBox^.Size.Y-1;
   SB^.Locate(R);
   ListBox^.NewList(List);
   D^.Insert(ListBox);
   D^.Insert(New(PLabel, Standard('Available image ~f~ormats', ListBox)));

   D^.GetInterior(I);
   BS.X:=CharWidth shl 3; BS.Y:=CharHeight+ButtonShift.Y;
   R:=I; R.A.Y:=R.B.Y-CharHeight*3; R.A.X:=CharWidth shl 1; R.SetSize(BS);
   D^.Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
   R.Move(I.B.X-R.A.X-BS.X-CharWidth shl 1, 0);
   D^.Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

   D^.SelectNext(False);
end;

procedure TEditApp.FileNew;
var
   R, I            :TGRect;
   IS              :TGPoint;
   D               :PDialog;
   IX, IY          :PInputLine;
   IXV, IYV        :PRangeValidator;
   ValX, ValY      :LongInt;
   ListBox         :PFormatsListBox;
   List            :PCollection;
   NumList         :Array [1..MaxFormats] of Integer;
begin
   R.Assign(0, 0, CharWidth shl 5 + 4, CharHeight*15);
   Desktop^.GetExtent(I); R.Intersect(I);
   New(D, Init(R, 'Create a new image'));
   D^.Palette:=dpCyanDialog;
   D^.Options:=D^.Options or ofCentered;

   D^.GetInterior(R);
   R.Grow(-CharWidth, -(CharHeight shl 1));
   R.B.X:=R.A.X+CharWidth*12; R.B.Y:=R.A.Y;
   New(IX, Init(R, 4));
   D^.Insert(IX);
   D^.Insert(New(PLabel, Standard('Size ~X~', IX)));
   D^.Insert(New(PHistory, Standard(IX, hiNew)));
   New(IXV, Init(1, MaxImageSizeX));
   IX^.SetValidator(IXV);

   D^.GetInterior(I);
   R.B.X:=I.B.X-FrameOffset-CharWidth-HistoryWidth;
   R.A.X:=R.B.X-CharWidth*12;
   New(IY, Init(R, 3));
   D^.Insert(IY);
   D^.Insert(New(PLabel, Standard('Size ~Y~', IY)));
   D^.Insert(New(PHistory, Standard(IY, hiNew)));
   New(IYV, Init(1, MaxImageSizeY));
   IY^.SetValidator(IYV);

   R.Assign(I.A.X+CharWidth, R.B.Y+CharHeight*3,
      I.B.X-1-CharWidth shl 1, I.B.Y-CharHeight shl 2);
   MakeList(D, R, 'create a new image', List, NumList, ListBox);
   if List=nil then Exit;

   ValX:=32; ValY:=32; IX^.SetData(ValX); IY^.SetData(ValY);
   if Desktop^.ExecView(D)<>cmCancel then
   begin
      IX^.GetData(ValX); IY^.GetData(ValY);

      if ValX*ValY+4>MaxImageSize
      then MessageBox(^M^C'Image is too large.', nil, mfError+mfOKButton) else
      begin
         IS.X:=ValX; IS.Y:=ValY;

         Desktop^.Background^.GetExtent(R);
         if InsertWindow(New(PGEditor, InitNew(R, wnNoNumber, IS, NumList[ListBox^.Focused+1])))=nil then Exit;
         Inc(WinCount);
         EnableCommands([cmSave, cmSaveAs, cmSaveAll, cmConvert,
            cmUndo, cmFlipX, cmFlipY]);
      end;
   end;

   List^.DeleteAll; Dispose(List, Done); Dispose(D, Done);
end;

procedure TEditApp.FileConvert;
var
   R, I            :TGRect;
   D               :PDialog;
   ListBox         :PFormatsListBox;
   List            :PCollection;
   NumList         :Array [1..MaxFormats] of Integer;
begin
   if W=nil then Exit;

   R.Assign(0, 0, CharWidth shl 5 + 4, CharHeight*15);
   Desktop^.GetExtent(I); R.Intersect(I);
   New(D, Init(R, 'Convert the image'));
   D^.Palette:=dpCyanDialog;
   D^.Options:=D^.Options or ofCentered;

   D^.GetInterior(R);
   R.Assign(R.A.X+CharWidth, R.A.Y+CharHeight*3,
      R.B.X-1-CharWidth shl 1, R.B.Y-CharHeight shl 2);
   MakeList(D, R, 'convert an image', List, NumList, ListBox);
   if List=nil then Exit;

   if Desktop^.ExecView(D)<>cmCancel then
      W^.ConvertImage(NumList[ListBox^.Focused+1]);

   List^.DeleteAll; Dispose(List, Done); Dispose(D, Done);
end;

procedure TEditApp.FileOpen;
var
   FileName        :FNameStr;
   R               :TGRect;
begin
   FileName:=SpriteWildCard;
   if ExecuteDialog(New(PFileDialog, Init(SpriteWildCard, 'Open a file',
      '~N~ame', fdOpenButton, hiImage)), @FileName) <> cmCancel then
   begin
      Desktop^.Background^.GetExtent(R);
      if InsertWindow(New(PGEditor, Init(R, FileName, wnNoNumber)))=nil then Exit;
      Inc(WinCount);
      EnableCommands([cmSave, cmSaveAs, cmSaveAll, cmConvert,
         cmUndo, cmFlipX, cmFlipY]);
   end;
end;

procedure TEditApp.FileSave;
var
   FileName        :FNameStr;
begin
   if W=nil then Exit;
   FileName:=W^.Title^;
   if FileName='' then
   begin
      SaveAs:=True; FileName:=SpriteWildCard;
   end;
   if (not SaveAs) or
      (ExecuteDialog(New(PFileDialog, Init(SpriteWildCard, 'Save file as',
      '~N~ame', fdSaveButton, hiImage)), @FileName) <> cmCancel) then
   begin
      if SaveAs and (FSearch(FileName, '')<>'') and
         (MessageBox(^M^C'The file already exists.'^M^M^C'Overwrite?',
         nil, mfConfirmation + mfOKButton + mfCancelButton)=cmCancel) then Exit;
      W^.SaveImage(@FileName);
      if SaveAs then
      begin
         DisposeStr(W^.Title); W^.Title:=NewStr(FileName); W^.Frame^.DrawView;
      end;
   end;
end;

procedure TEditApp.FileSaveAll;

procedure DoSave(V                     :PView); far;
begin
   if (TypeOf(V^)=TypeOf(TGEditor)) and
      PGEditor(V)^.Field^.Modified then FileSave(PGEditor(V), False);
end;

begin
   Desktop^.ForEach(@DoSave);
end;

procedure TEditApp.FileInfo;
var
   R               :TGRect;
   P               :Record
      FreeMem      :LongInt;
      Title        :Pointer;
      Format       :Pointer;
      SizeX, SizeY,
      SizeBytes    :LongInt;
   End;
   W               :PGEditor;
   TitleBuf        :String[12];
const
   Zero  :Byte =   0;
begin
   P.FreeMem:=MemAvail shr 10;
   P.Title:=@TitleBuf;
   W:=FindEditWindow;
   if W=nil then
   begin
      TitleBuf:='Not loaded'; P.Format:=@Zero;
      P.SizeX:=0; P.SizeY:=0; P.SizeBytes:=0;
   end
   else
   begin
      TitleBuf:=W^.GetTitle(12);
      P.Format:=Formats[W^.Image^.FormatId].Name;
      if P.Format=nil then P.Format:=@Zero;
      P.SizeX:=W^.Image^.Size.X; P.SizeY:=W^.Image^.Size.Y;
      P.SizeBytes:=W^.Image^.FileSize-4;
   end;

   R.Assign(0, 0, CharWidth shl 5, CharHeight*(12+4+4) - 4);
   R.Move((Desktop^.Size.X-R.B.X) shr 1, (Desktop^.Size.Y-R.B.Y) div 2);

   MessageBoxRect(R,
        ^M' Free memory:      %-d Kb'+
      ^S#4+
      ^S#4' Image file name:  %s'+
      ^S#4' Image format:'+
      ^S#4^C'%s'+
      ^S#4' Horizontal size:  %-d'+
      ^S#4' Vertical size:    %d'+
      ^S#4' Image size:       %d bytes',
      @P, mfInformation+mfOKButton);
end;

procedure TEditApp.DosShell;
begin
   Inherited DosShell;
   SetRGBBlock(0, 256, @PaletteRGB);
end;

procedure TEditApp.EditUndo;
var
   W               :PGEditor;
begin
   W:=FindEditWindow;
   if W<>nil then W^.Field^.Undo;
end;

procedure TEditApp.EditFlip;
var
   W               :PGEditor;
   Ok              :Boolean;
begin
   W:=FindEditWindow;
   if W=nil then Exit;
   if Cmd=cmFlipX then Ok:=W^.Image^.FlipX else Ok:=W^.Image^.FlipY;
   if Ok then
   begin
      W^.Field^.DrawView; W^.Field^.Modified:=True;
      InfoBar^.Modified:=True; InfoBar^.DrawPos;
   end;
end;

procedure TEditApp.PaletteLoad;
var
   FileName        :FNameStr;
   S               :TDosStream;
begin
   FileName:=PaletteWildCard;
   if ExecuteDialog(New(PFileDialog, Init(PaletteWildCard, 'Load palette',
      '~N~ame', fdOpenButton, hiPalette)), @FileName) <> cmCancel then
   begin
      S.Init(FileName, stOpenRead);
      if S.GetSize<>768 then S.Status:=stReadError else LoadPalette(S, False);

      if (S.Status<>stOk) or (S.GetPos<>S.GetSize) then
      begin
         MessageBox(^M^C'Unable to load palette.', nil, mfError + mfOKButton);
         S.Done; Exit;
      end;
      S.Done;
   end;
end;

procedure TEditApp.PaletteStd;
var
   C               :Integer;
begin
   DoneMousePtr; DoneEvents;
   InitVideo(DriverName, DriverMode);
   SetRGB(NullColor, DefaultNull);
   GetRGBBlock(0, 256, @PaletteRGB);
   for C:=0 to 15 do ColorTable[C]:=C;
   Redraw;
   InitMousePtr; InitEvents;
   DisableCommands([cmPaletteStd]);
end;

procedure TEditApp.Scale;
var
   LastGrid        :TGPoint;
begin
   if TypeOf(Desktop^.Current^)=TypeOf(TGEditor) then
   with PGEditor(Desktop^.Current)^.Field^ do
   begin
      LastGrid:=Grid;
      if Change>0 then Grid.X:=Grid.X shl Change else Grid.X:=Grid.X shr (-Change);
      Grid.X:=Max(Min(Grid.X, MaxScale), MinScale);
      if (ScreenWidth<=ScreenHeight) and (Grid.X<>1) then Grid.Y:=Grid.X shl 1 else
      if (ScreenWidth div ScreenHeight>=2) and (Grid.X<>1) then Grid.Y:=Max(Grid.X shr 1, 1)
      else Grid.Y:=Grid.X;
      if LongInt(Grid)<>LongInt(LastGrid) then
      begin
         LockDraw; PGEditor(Owner)^.UpdateScrollBars; UnlockDraw;
         DrawView;
      end;
   end;
end;

procedure TEditApp.SetVideoMode;
begin
   StdVideo.SetVideoMode(ModeCmd);
   SetRGBBlock(0, 256, @PaletteRGB);
end;

procedure TEditApp.SaveConfig;
var
   S               :TDosStream;
begin
   Config.Driver:=DriverName; Config.Mode:=DriverMode;
   S.Init(ConfigFile, stCreate);
   S.Write(Config, SizeOf(Config));
   S.Done;
end;

procedure TEditApp.LoadConfig;
var
   S               :TDosStream;

function  CheckSVGA                    :Boolean;
type
   TModeList =     Array [0..$FF] of Word;

   TVesaInfo =
   record
      Signature    :LongInt;
      Version      :Word;
      OEMName      :PChar;
      Capabilities :Longint;
      ModeList     :^TModeList;
      TotalMemory  :Word;
      Filler       :Array [1..238] of Byte;
   end; { 258 byte size due to bug in the Diamond SpeedStar 24X v1.01 BIOS }

var
   VesaInfo        :^TVesaInfo;

begin
   New(VesaInfo);
   asm
      mov  @Result,0FFh
      mov  ax,4F00h
      les  di,VesaInfo
      int  10h
      cmp  ax,004Fh
      jne  @@Error
      les  di,es:[di].TVesaInfo.ModeList
      mov  cx,100h
@@Loop:
      mov  ax,word ptr es:[di]
      inc  ax
      jz   @@Error
      cmp  ax,gm640x400x256+1
      je   @@Ok
      inc  di
      inc  di
      loop @@Loop
@@Error:
      mov  @Result,0
@@Ok:
   end;
   Dispose(VesaInfo);
end;

begin
   S.Init(ConfigFile, stOpenRead);
   S.Read(Config, SizeOf(Config));
   S.Done;
   if S.Status<>stOk then
   with Config do
   if CheckSVGA then
   begin
      Driver:='VESA256'; Mode:=gm640x400x256;
   end else
   begin
      Driver:='VGA256'; Mode:=gm320x200x256;
   end;
end;

var
   EditApp         :TEditApp;

begin
   EditApp.Init;
   EditApp.Run;
   EditApp.Done;
end.
