
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Multi-Sprites Editor Unit                       }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit LPalette;
interface
uses
   Objects,
   GApp, GPalette,
   SEditor,
   RGB;

const
   cmPaletteLoad = $E0;
   cmPaletteStd =  $E1;

var
   StandardPalette :Array [0..15] of TRGBColor;

procedure LoadPalette(var S            :TStream;
                      Windows          :Boolean);

implementation

procedure LoadPalette;
type
   TWindowsColor =
   record
      B, G, R, C   :Byte;
   end;
var
   WinP            :Array [0..255] of TWindowsColor;
   P               :TRGBPalette absolute WinP;
   WinC            :TWindowsColor;
   C, NC           :Integer;
   RN              :Boolean;
begin
   if Windows
   then S.Read(WinP, SizeOf(WinP))
   else S.Read(P, SizeOf(P));
   if S.Status<>stOk then Exit;

   if Windows then
   for C:=0 to 255 do
   begin
      LongInt(WinC):=LongInt(WinP[C]);
      P[C].R:=WinC.R shr 2; P[C].G:=WinC.G shr 2; P[C].B:=WinC.B shr 2;
   end;

   RN:=False;
   for C:=0 to 15 do
   begin
      NC:=GetNearestColor(StandardPalette[C], 0, 255, @P);
      if ColorTable[C]<>NC then RN:=True;
      ColorTable[C]:=NC;
   end;
   SetRGBBlock(0, 256, @P); PaletteRGB:=P;
   if RN then Application^.Redraw else InfoBar^.DrawView;

   Application^.EnableCommands([cmPaletteStd]);
end;

end.
