
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Multi-Sprites Editor Unit                       }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit Hints;
interface
uses
   GMenus, GApp,
   StdVideo;

const
   hcScaleDown =   $F100;
   hcScaleUp =     $F101;

   hcPaletteLoad = $F110;
   hcPaletteStd =  $F111;

   hcSetColor =    $F120;
   hcGetColor =    $F121;
   hcFillArea =    $F122;

   hcRectangle =   $F124;
   hcBar =         $F125;
   hcLine =        $F126;

   hcFlipX =       $F128;
   hcFlipY =       $F129;

   hcInfo =        $F130;
   hcConvert =     $F131;

   hcSaveOpts =    $F140;

   hcFileMenu =    $F200;
   hcEditMenu =    $F201;
   hcPaletteMenu = $F202;
   hcWindowMenu =  $F203;
   hcVideoMenu =   $F204;

   hcWait =        $F300;

   hcLow =         $F280;
   hcModeX =       $F281;
   hcSVGA =        $F282;

type
   PHintStatusLine = ^THintStatusLine;
   THintStatusLine =
   object(TStatusLine)

      function  Hint(AHelpCtx          :Word)              :THintStr; virtual;

   end;

implementation

function  THintStatusLine.Hint;
begin
   case AHelpCtx of

      hcFileMenu:       Hint:='File management commands';
      hcEditMenu:       Hint:='Editing commands';
      hcPaletteMenu:    Hint:='Palette operations';
      hcWindowMenu:     Hint:='Arrange windows';
      hcVideoMenu:      Hint:='Change video mode';

      hcAbout:          Hint:='Show version and copyright information';
      hcInfo:           Hint:='Show status information';
      hcConvert:        Hint:='Convert the active image';

      hcNew:            Hint:='Create a new image in a new window';
      hcOpen:           Hint:='Select and load an image';
      hcSave:           Hint:='Save the active image';
      hcSaveAs:         Hint:='Save under a different name';
      hcSaveAll:        Hint:='Save all modified images';

      hcChangeDir:      Hint:='Choose a new default directory';
      hcDOSShell:       Hint:='Temporarily exit to DOS';
      hcExit:           Hint:='Exit the editor';

      hcUndo:           Hint:='Undo the previous editor operation';

      hcSetColor:       Hint:='Normal editor mode';
      hcGetColor:       Hint:='Get color from the image';
      hcFillArea:       Hint:='Fill a bounded region';

      hcRectangle:      Hint:='Draw a rectangle';
      hcBar:            Hint:='Draw a bar';
      hcLine:           Hint:='Draw a line';

      hcFlipX:          Hint:='Flip horizontally';
      hcFlipY:          Hint:='Flip vertically';

      hcPaletteLoad:    Hint:='Load a RGB palette';
      hcPaletteStd:     Hint:='Restore the standard palette';

      hcTile:           Hint:='Arrange windows by tiling';
      hcCascade:        Hint:='Arrange windows by cascading';
      hcCloseAll:       Hint:='Close all windows';
      hcRefresh:        Hint:='Redraw the screen';

      hcResize:         Hint:='Resize or move the active window';
      hcZoom:           Hint:='Enlarge or restore the active window';
      hcNext:           Hint:='Make the next window active';
      hcPrev:           Hint:='Make the previous window active';
      hcClose:          Hint:='Close the active window';

      hcScaleDown:      Hint:='Decrease the magnification';
      hcScaleUp:        Hint:='Increase the magnification';

      hcLow:            Hint:='Low resolution VGA modes';
      hcModeX:          Hint:='Extended VGA modes';
      hcSVGA:           Hint:='VESA, Trident & Realtek SVGA modes';

      hcVideoVGA:       Hint:='Standard VGA mode';
      hcVideoLowVGA:    Hint:='Low resolution VGA mode (fast)';

      hcVideoExtVGA:    Hint:='Extended VGA mode';

      hcVideoVESAHi:    Hint:='VESA SVGA, 512 Kb video RAM';
      hcVideoRTVGA:     Hint:='Realtek SVGA, 512 Kb video RAM';
      hcVideoTrident:   Hint:='Trident SVGA, 512 Kb video RAM';

      hcSaveOpts:       Hint:='Save the current video mode in file';

      hcWait:           Hint:='Please, wait ...';

   else
      Hint := '';
   end;
end;

end.
