
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Main Demo Program               }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

program GVDemo;
uses
   {Russian,} English,                 { System messages }
   F8x8A, F8x14A, F8x16A, F8x19A,      { Raster fonts }
   DrawLat,                            { Vector font }
   Objects, GRect, GPalette,           { Utilities }
   GDrivers, GApp, GViews,             { Main units }
   GMenus, GDialogs,                   { Main units }
   GMsgBox, GStdDlg,                   { Standard dialogs }
   Events, KeyMouse, Utils,            { Parts of the TV's Drivers unit }
   GModes,                             { Video mode codes }
   MousePtr,                           { Mouse emulation for SVGA 256 colors }
   StdVideo;                           { Video modes menu }

const
   VStr =                    'V2.2';

   cmAddWindow =             3000;
   cmAddFilledWindow =       3001;
   cmAddDialog =             3002;
   cmListViewer =            3003;
   cmAddWindowM =            3004;

   cmInputBox =              3100;

   cmAboutDialogSpeed =      3200;
   cmFileDialogSpeed =       3201;
   cmChdirDialogSpeed =      3202;
   cmWindowSpeed =           3210;
   cmEmptyWindowSpeed =      3211;

   cmIconClicked =           3500;

   CLargeText =
   cpText+cpYellow + cpHighlight+cpLightRed;

type
   TDemoApp=
   object(TApplication)

      WinNum       :Integer;

      procedure InitScreen; virtual;

      procedure InitMenuBar; virtual;
      procedure InitStatusLine; virtual;
      procedure InitDesktop; virtual;

      procedure HandleEvent(var Event  :TEvent); virtual;

      procedure Benchmark(Cmd          :Word;
                          const Name   :String);
   end;

   PLargeText =    ^TLargeText;
   TLargeText =
   object(TView)

      constructor Init(var Bounds      :TGRect);

      function  GetPalette                       :TPalette; virtual;

      procedure Draw; Virtual;

   end;

   PListViewerTest=^TListViewerTest;
   TListViewerTest=
   object(TListViewer)
      function  GetText(Item, MaxLen   :Integer) :String; virtual;
   end;

   PWindowM =      ^TWindowM;
   TWindowM =
   object(TWindow)
      function  GetMenu(NextItem       :Pointer) :Pointer; virtual;
   end;

{ TWindowM }

function  TWindowM.GetMenu;
begin
   GetMenu:=
     NewItem('A~b~out', '', kbNoKey, cmAbout, hcNoContext,
     NewLine(
     Inherited GetMenu(
     NewLine(
     NewSubMenu('~V~ideo', hcNoContext, NewMenu(StdVideoMenuItems(nil)),
   nil)))));
end;

{ TListViewerTest }

function  TListViewerTest.GetText;
var
   s               :String[7];
begin
   Str(Item, s);
   GetText:='Item #'+s;
end;

{ TLargeText }

constructor TLargeText.Init;
begin
   Inherited Init(Bounds);
   GrowMode:=gfGrowHiX+gfGrowHiY;
end;

function  TLargeText.GetPalette;
begin
   if Owner=PGroup(Desktop)
   then GetPalette:=CLargeText + CBackground
   else GetPalette:=CLargeText;
end;

procedure TLargeText.Draw;
const
   Text =          '~G~raphics ~V~ision';
var
   R, RB           :TGRect;
   LFont           :TTextStyle;
   c               :Integer;
begin
   Inherited Draw;

   GetExtent(R);

   RB:=R;
   if TypeOf(Owner^)<>TypeOf(TWindow) then
   for c:=0 to MaxColor do
   begin
      RB.B.X:=LongDiv(LongMul(c, R.SizeX), MaxColor);
      if c>0 then DrawBar(RB, c);
      RB.A.X:=RB.B.X;
   end;

   LFont.Defaults;
   LFont.SizeX:=R.B.X div CStrLen(Text); LFont.DivX:=8;
   LFont.SizeY:=R.B.Y; LFont.DivY:=8;
   DrawText(R.A, Text, tfNormal+tfColored, @LFont, GetColors(cpText, cpHighlight));
end;

{ TDemoApp }

procedure TDemoApp.InitScreen;
begin
   Inherited InitScreen;

   case ScreenHeight of
      0..200:   SystemFont.Font:=@Font8x8A;
      201..400: SystemFont.Font:=@Font8x14A;
      401..480: SystemFont.Font:=@Font8x16A;
      else      SystemFont.Font:=@Font8x19A;
   end;
end;

procedure TDemoApp.InitMenuBar;
begin
   MenuBar := New(PMenuBar, Standard(NewMenu(
     NewSubMenu('~F~ile', hcNoContext, NewMenu(
       NewItem('A~b~out', 'F1', kbF1, cmAbout, hcNoContext,
       NewLine(
       StdFileMenuItems(nil)))),
     NewSubMenu('~W~indow', hcNoContext, NewMenu(StdWindowMenuItems(nil)),
     NewSubMenu('~T~ests', hcNoContext, NewMenu(
       NewItem('Add filled ~w~indow', 'Alt+A', kbAltA, cmAddFilledWindow, hcNoContext,
       NewItem('Add ~e~mpty window', '', kbNoKey, cmAddWindow, hcNoContext,
       NewItem('Add window with ~m~enu', '', kbNoKey, cmAddWindowM, hcNoContext,
       NewItem('Display ~d~ialog', 'Alt+D', kbAltD, cmAddDialog, hcNoContext,
       NewItem('List ~v~iewer', 'Alt+V', kbAltV, cmListViewer, hcNoContext,
       NewItem('~I~nput box', 'Alt+I', kbAltI, cmInputBox, hcNoContext,
       NewLine(
       NewSubMenu('~B~enchmarks', hcNoContext, NewMenu(
         NewItem('~A~bout dialog', '', 0, cmAboutDialogSpeed, hcNoContext,
         NewItem('~F~ile dialog', '', 0, cmFileDialogSpeed, hcNoContext,
         NewItem('~C~hdir dialog', '', 0, cmChdirDialogSpeed, hcNoContext,
         NewItem('~T~ext window', '', 0, cmWindowSpeed, hcNoContext,
         NewItem('~E~mpty window', '', 0, cmEmptyWindowSpeed, hcNoContext,
       nil)))))),
     nil))))))))),
     NewSubMenu('~V~ideo', hcNoContext, NewMenu(StdVideoMenuItems(nil)),
   nil)))))));
end;

procedure TDemoApp.InitStatusLine;
begin
   New(StatusLine, Standard(
     NewStatusDef(0, $FFFF,
       NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
       NewStatusKey('~F4~ Add window', kbF4, cmAddFilledWindow,
       StdStatusKeys(nil))), nil)));
end;

procedure TDemoApp.InitDesktop;
var
   R               :TGRect;
   IS              :TDosStream;
begin
   Inherited InitDesktop;

   Desktop^.GetExtent(R);
   R.Grow(-4, -4); R.A.Y:=R.B.Y-(SystemFont.Height shl 2);
   Desktop^.Insert(New(PLargeText, Init(R)));

   Desktop^.GetExtent(R); R.A.X:=R.B.X-48; Inc(R.A.Y, 16);
   IS.Init('GVDEMO.IMG', stOpenRead);
   Desktop^.Insert(New(PIcon, ReadAt(R.A, cmIconClicked, IS)));
   IS.Done;
end;

procedure TDemoApp.HandleEvent;
var
   R               :TGRect;
   D               :PDialog;
   V               :PListViewerTest;
   SB              :PScrollBar;
   IL              :PInputLine;
   S               :String;
begin
   Inherited HandleEvent(Event);
   if Event.What=evCommand then
   case Event.Command of

      cmAddWindow, cmAddWindowM:
      begin
         R.A.X:=Random(DeskTop^.Size.X-MinWinSize.X);
         R.B.X:=R.A.X+Random(DeskTop^.Size.X-R.A.X-MinWinSize.X)+MinWinSize.X;
         R.A.Y:=Random(DeskTop^.Size.Y-MinWinSize.Y);
         R.B.Y:=R.A.Y+Random(DeskTop^.Size.Y-R.A.Y-MinWinSize.Y)+MinWinSize.Y;
         Inc(WinNum);
         if Event.Command=cmAddWindowM
         then InsertWindow(New(PWindowM, Init(R, 'Window with menu', WinNum)))
         else InsertWindow(New(PWindow, Init(R, 'Text window', WinNum)));
      end;

      cmAddFilledWindow:
      begin
         Event.Command:=cmAddWindow; HandleEvent(Event);

         with PWindow(Desktop^.Current)^ do
         begin
            SB:=StandardScrollBar(sbHorizontal+sbHandleKeyboard);
            SB^.SetParams(5, 0, 10, 2, 1);
            SB^.Options:=SB^.Options and not ofUpdate;

            SB:=StandardScrollBar(sbVertical+sbHandleKeyboard);
            SB^.SetParams(250, 1, 1000, 50, 5);

            GetInterior(R); R.Grow(-8, -8);
            Insert(New(PLargeText, Init(R)));
         end;
      end;

      cmAddDialog:
      begin
         DeskTop^.GetExtent(R); R.Grow(-16, -8);
         New(D, Init(R, 'Dialog'));

         D^.GetInterior(R); R.A.X:=R.CenterX-32; R.A.Y:=R.B.Y-CharHeight*3;
         D^.Insert(New(PButton, InitAt(R.A, '~C~ancel', cmCancel, bfNormal)));
         Dec(R.A.X, 96);
         D^.Insert(New(PButton, InitAt(R.A, 'O~K~', cmOk, bfDefault)));

         D^.GetInterior(R);
         R.B.Y:=R.A.Y+CharHeight*4; R.Move(0, CharHeight*11);
         D^.Insert(New(PStaticText, Init(R, ^C'It''s static text.'^S#6^C+
            'Second line ...'^S#2^C'Third line ...')));

         D^.GetInterior(R);
         Inc(R.A.Y, CharHeight shl 1); R.B.Y:=R.A.Y; R.Grow(-24, 0);
         New(IL, Init(R, 79)); D^.Insert(IL);
         D^.Insert(New(PLabel, Standard('~I~nput line', IL)));
         D^.Insert(New(PHistory, Standard(IL, 10)));

         R.Move(0, (CharHeight shl 1)+4);

         R.B.X:=R.A.X+CharWidth*16; R.B.Y:=R.A.Y+CharHeight*5;
         D^.Insert(New(PCheckBoxes, Init(R,
            NewSItem('~F~irst item',
            NewSItem('~S~econd item',
            NewSItem('~T~hird item',
            nil))))));
         D^.Insert(New(PLabel, Standard('Check ~b~oxes', D^.Current)));

         R.A.X:=R.B.X; Inc(R.B.X, CharWidth*16);
         D^.Insert(New(PRadioButtons, Init(R,
            NewSItem('~F~irst item',
            NewSItem('~S~econd item',
            NewSItem('~T~hird item',
            nil))))));
         D^.Insert(New(PLabel, Standard('~R~adio buttons', D^.Current)));

         ExecuteDialog(D, nil);
      end;

      cmIconClicked:
      MessageBox(^M^C'You''ve clicked the icon.',
         nil, mfInformation + mfOKButton);

      cmListViewer:
      begin
         DeskTop^.GetExtent(R); R.Grow(-16, -8);
         New(D, Init(R, 'ListViewer Test'));

         D^.GetInterior(R); R.Grow(-16, -16);
         New(V, Init(R, 4, D^.StandardScrollBar(sbHorizontal),
            D^.StandardScrollBar(sbVertical)));
         V^.SetRange(1000);
         V^.HScrollBar^.SetRange(1, 8);

         D^.Insert(V);
         D^.Palette:=dpBlueDialog; ExecuteDialog(D, nil);
      end;

      cmAbout:
      MessageBox(
         ^C'Graphics Vision '+VStr+' Demo'^M^M+
         ^C'Copyright '#252' 1994,95 by'^M^M+
         ^C'Solar Designer \ BPC', nil, mfInformation + mfOKButton);

      cmInputBox:
      begin
         S:='Graphics Vision for TP/BP.';
         if InputBox('InputBox Test', '~T~ext:', S, 255)=cmCancel
         then MessageBox(^M^C'You have cancelled'^M^M^C'the input box.', nil, mfInformation + mfOKButton)
         else MessageBox(^M^C'You have entered :'^M^M^C + S, nil, mfInformation + mfOKButton);
      end;

      cmOpen:
         ExecuteDialog(New(PFileDialog, Init('*.*', 'Open a File',
            '~N~ame', fdOpenButton+fdReplaceButton+fdHelpButton, 11)), nil);

      cmSave, cmSaveAs:
         ExecuteDialog(New(PFileDialog, Init('*.*', 'Save File As',
            '~S~ave file as', fdSaveButton+fdHelpButton, 11)), nil);

      cmChangeDir:
         ExecuteDialog(New(PChDirDialog, Init(0, 12)), nil);

      cmAboutDialogSpeed:    Benchmark(cmAbout, '');
      cmFileDialogSpeed:     Benchmark(cmOpen, '');
      cmChdirDialogSpeed:    Benchmark(cmChangeDir, '');
      cmWindowSpeed:         Benchmark(cmAddFilledWindow, 'Window');
      cmEmptyWindowSpeed:    Benchmark(cmAddWindow, 'Window');

   else
      StdVideo.SetVideoMode(Event.Command);
   end;
end;

procedure TDemoApp.Benchmark;
const
   NSec =          5;
var
   Count           :Integer;
   Timer           :LongInt absolute $0040:$006C;
   LTimer          :LongInt;
   CountRes        :Record
      Time, Hi, Lo :LongInt;
   end;
   Event           :TEvent;
   RName           :String[7];
begin
   Message(@Self, evCommand, cmCloseAll, @Self);
   Message(@Self, evCommand, cmAddFilledWindow, @Self);
   Message(Desktop^.Current, evCommand, cmZoom, nil);

   LTimer:=Timer;
   Count:=0;
   while Timer-LTimer<(182*NSec div 10) do
   begin
      Inc(Count);
      if Name='' then
      begin
         Event.What:=evCommand; Event.Command:=cmCancel; Event.InfoPtr:=@Self;
         PutEvent(Event); ClearEvent(Event);
      end;
      Message(@Self, evCommand, Cmd, @Self);

      GetKeyEvent(Event);
      if Event.What<>evNothing then Break;
      GetMouseEvent(Event);
      if Event.What=evMouseDown then Break;
      ClearEvent(Event);
   end;

   Message(@Self, evCommand, cmCloseAll, @Self);

   if (Count=0) or (Event.What<>evNothing) then
   begin
      MessageBox(^M^C'The benchmark'^M^M^C'has been cancelled.',
         nil, mfInformation + mfOKButton);
      Exit;
   end;

   CountRes.Time:=NSec; CountRes.Hi:=Count div NSec; CountRes.Lo:=Count mod NSec;
   if Name<>'' then RName:=Name else RName:='Dialog';
   MessageBox(
          ^C'Benchmark results :'+
      ^M^M^C'Testing time %d seconds'+
      ^M^M^C'%d.%d '+RName+'s Per Second',
      @CountRes, mfInformation + mfOKButton);
end;

var
   DemoApp         :TDemoApp;

begin
{  AutoAdjustMsg:=False; }
{  MinButtonWidth:=64; }
{  ForceMouseEmul:=True; }

   SystemFont.Font:=@Font8x16A;

{ Examples of calling TApplication.Init }
{  DemoApp.Init('VGA256', 0); (* VGA 320x200x256 *) }
{  DemoApp.Init('VESA256', gm640x480x256); (* VESA SVGA 512 Kb *) }
{  DemoApp.Init('VESA16LO', gm800x600x16); (* VESA SVGA 256 Kb *) }
{  DemoApp.Init('VESA16HI', gm1024x768x16); (* VESA SVGA 512 Kb *) }
   DemoApp.Init('VESA16LO', gm640x480x16);

   DemoApp.Run;
{ Uncomment the following line to test the error handler }
{  SystemError(1, 1);}

   DemoApp.Done;
end.
