
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Demo Program                    }
{                                                       }
{       Copyright (c) 1993,94 by Solar Designer         }
{                                                       }
{*******************************************************}

{$X+}
uses
   CRT, DOS,
   GraphDrv,
   DrawLat, DrawNum, DrawSpc, DrawRus; { Fonts }

var
   n               :String[12];
   i, x, y, c      :Integer;

   p1, p2          :Pointer;
   s               :Word;
   SR              :SearchRec;

procedure Msg(Proc, Msg      :String);
begin
   if Proc<>'' then ClearDevice(c) else Bar(0, 0, GetMaxX, 7, c);
   SetUserCharSize(1, 1, 1, 1);
   SetTextJustify(CenterText, TopText);
   SetTextAngle(0);
   if Proc<>'' then Proc:=Proc+'. ';
   OutTextXY(GetMaxX div 2, 0, Proc+Msg, White);
end;

procedure WaitKey;
begin
   Delay(200);
   Msg('', 'Press any key to continue ...');
   ReadKey;
end;

begin
   FillBufSize:=8192;

   WriteLn(#13#10'Available graphics drivers :');
   FindFirst('*.DRV', Archive or ReadOnly, SR);
   while DosError=0 do
   begin
      Write(SR.Name:20);
      FindNext(SR);
   end;

   Write(#13#10'Enter driver name WITHOUT extension : '); ReadLn(n);
   WriteLn;

   if LoadDriver(n+'.DRV')<>gdOk then
   begin
      WriteLn('Error loading driver !'); Halt;
   end;

   if ModesList<>nil then
   begin
      WriteLn('Supported video modes :');
      for i:=1 to DriverPtr^.ModesCount do
      with ModesList^[i] do
         WriteLn(Mode:5, '  ', SizeX, 'x', SizeY, 'x', DriverPtr^.MaxColor+1);
      WriteLn;
      Write('Enter video mode number : '); ReadLn(i);
      InitDriver(i);
   end;

   WriteLn(DriverPTR^.Header);
   WriteLn(DriverPTR^.Copyright);
   WriteLn;
   WriteLn('PutPixel   : ', Supported(PutPixel));
   WriteLn('GetPixel   : ', Supported(GetPixel));
   WriteLn('Line       : ', Supported(Line));
   WriteLn('PutImage   : ', Supported(PutImage));
   WriteLn('ChangeColor: ', Supported(ChangeColor));
   WriteLn;
   WriteLn('Normal Put : ', PutModeSupported(NormalPut));
   WriteLn('Xor    Put : ', PutModeSupported(XorPut));
   WriteLn('And    Put : ', PutModeSupported(AndPut));
   WriteLn('Or     Put : ', PutModeSupported(OrPut));
   WriteLn;
   WriteLn('Press any key to continue ...');
   ReadKey;

   if SetGraphMode<>gdOk then
   begin
      WriteLn('Graphics hardware not detected'); Halt;
   end;

   if DriverPTR^.MaxColor>3 then c:=Blue else c:=Black;

   Msg('PutPixel', '(10000 times)');
   for i:=1 to 10000 do PutPixel(Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
      Random(DriverPTR^.MaxColor+1));

   Line(0, GetMaxY, GetMaxX, GetMaxY, 15);
   WaitKey;

   Msg('Line', '(200 times, NormalPut)');
   for i:=1 to 200 do Line(Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
      Random(GetMaxX+1), Random(GetMaxY+1-8)+8, Random(DriverPTR^.MaxColor+1));
   WaitKey;

   if PutModeSupported(XorPut) then
   begin
      Msg('Line', '(200 times, XorPut)');
      DriverPTR^.PutMode:=XorPut;
      for i:=1 to 200 do Line(Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
         Random(GetMaxX+1), Random(GetMaxY+1-8)+8, Random(DriverPTR^.MaxColor+1));
      DriverPTR^.PutMode:=NormalPut;
      WaitKey;
   end;

   Msg('Rectangle', '');
   for i:=0 to GetMaxY shr 1 do Rectangle(i, i+8, GetMaxX-i, GetMaxY-i+8,
      i mod DriverPTR^.MaxColor);
   WaitKey;

   Msg('Bar', '(NormalPut), test #1');
   for i:=0 to DriverPTR^.MaxColor do
   begin
      x:=LongInt(i)*GetMaxX div (DriverPTR^.MaxColor+1);
      y:=LongInt(i)*GetMaxY div (DriverPTR^.MaxColor+1);
      Bar(x, y, x+20, y+20, i);
   end;
   WaitKey;

   if PutModeSupported(XorPut) then
   begin
      Msg('Bar', '(XorPut)');
      DriverPTR^.PutMode:=XorPut;
      for i:=0 to DriverPTR^.MaxColor do
      begin
         x:=LongInt(i)*GetMaxX div (DriverPTR^.MaxColor+1);
         y:=LongInt(i)*GetMaxY div (DriverPTR^.MaxColor+1);
         Bar(x, y, x+20, y+20, i);
      end;
      DriverPTR^.PutMode:=NormalPut;
      WaitKey;
   end;

   Msg('Bar', '(NormalPut), test #2');
   for i:=0 to 15 do
   begin
      x:=(GetMaxX+1) div 48*i; y:=(GetMaxY-(8-1)) div 48*i+8;
      Bar(x, y, GetMaxX-x, GetMaxY-y, i mod (DriverPtr^.MaxColor+1));
   end;
   WaitKey;

   Msg('Circle', '');
   Circle(GetMaxX div 2, GetMaxY div 2, GetMaxY div 3, Red);
   WaitKey;

   Msg('Ellipse', '');
   Ellipse(GetMaxX div 2, GetMaxY div 2, 0, 270,
      GetMaxX div 4, GetMaxY div 6, Red);
   WaitKey;

   Msg('CircleRadius', '');
   for i:=0 to 360 do
   begin
      CircleRadius(GetMaxX div 2, GetMaxY div 2, i-1, GetMaxY div 3, c);
      CircleRadius(GetMaxX div 2, GetMaxY div 2, i, GetMaxY div 3, White);
      Delay(5);
   end;
   WaitKey;

   Msg('Setting text parameters', '');
   if GetMaxX>80 then SetUserCharSize(3, 1, 2, 1);
   SetTextAngle(30);
   SetTextJustify(CenterText, CenterText);

   for i:=0 to 360 div 15 do
   begin
      OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Text. .', c);
      SetTextAngle(i*15);
      OutTextXY(GetMaxX div 2, GetMaxY div 2, 'Text. .', White);
      Delay(50);
   end;
   WaitKey;

   if Supported(GetPixel) then
   begin
      Msg('FloodFill', '');
      Circle(GetMaxX div 2, GetMaxY div 2, GetMaxY div 3, Yellow);
      Line(GetMaxX div 2, 0, GetMaxX div 2, GetMaxY, White);
      FloodFill(GetMaxX div 2-1, GetMaxY div 2-1, Green, c);

      if Supported(GetImage) then
      begin
         x:=GetMaxX div 2-GetMaxY div 3; y:=GetMaxY div 2-GetMaxY div 3;
         s:=ImageSize(x, y, x+90, y+90);
         if s*2<=MaxAvail then
         begin
            GetMem(p1, s); GetMem(p2, s);
            GetImage(x, y, x+90, y+90, p1);
         end
         else p1:=nil;
      end
      else p1:=nil;

      WaitKey;

      if p1<>nil then
      begin
         Msg('GetImage/PutImage', '');
         for i:=0 to 20 do PutImage(x+i*3, y+i*3, p1);
         WaitKey;

         if not Supported(ConvertBlock) then
         begin
            Msg('TurnBlockX/Y', '');
            PutImage(10, 20, p1);
            TurnBlockX(p1, p2);
            PutImage(90, 20, p2);
            TurnBlockY(p1, p2);
            PutImage(170, 20, p2);
            WaitKey;
         end;
      end;
   end;

   if Supported(ChangeColor) then
   begin
      Msg('ChangeColor', 'Press any key to stop.');
      for i:=0 to DriverPTR^.MaxColor do
      Line(Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
         Random(GetMaxX+1), Random(GetMaxY+1-8)+8, i);
      while not KeyPressed do
      begin
         i:=Random(DriverPTR^.MaxColor+1);
         if DriverPtr^.MaxColor>=255 then
         if i<48 then i:=1 else else
         if DriverPtr^.MaxColor>=15 then
         if i<4 then i:=1;
         ChangeColor(Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
            Random(GetMaxX+1), Random(GetMaxY+1-8)+8,
            i, Random(DriverPTR^.MaxColor+1));
      end;
      WaitKey;
   end;

   CloseGraph;
end.
