
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Demo Program                    }
{                                                       }
{       Copyright (c) 1994,95 by Solar Designer         }
{                                                       }
{*******************************************************}

uses
   English, F8x16A,
   GModes, GRect,
   GViews,
   GDiagram,
   GApp;

var
   App             :TApplication;
   G               :PGraphic;
   R               :TGRect;
   i               :Integer;

begin
   SystemFont.Font:=@Font8x16A;
   App.Init('VESA16LO', gm640x480x16);

   Desktop^.GetExtent(R); R.Grow(-48, -32);
   New(G, Init(R));

   G^.Title:='Just a diagram demo';
   G^.Width:=3;
   G^.BottomLines:=1;
   G^.SetMaxIndex(100);

   G^.Graphics[0].X.SetRange(0, 10);
   G^.Graphics[0].X.SetFormat(3, 1, 5);
   G^.Graphics[0].Y.SetFormat(5, 1, 5);
   G^.Graphics[0].Title:='First';

   GetMem(G^.Graphics[0].Y.Data, SizeOf(TFloat)*(G^.Graphics[0].Y.MaxIndex+1));
   for i:=0 to G^.Graphics[0].Y.MaxIndex do
      G^.Graphics[0].Y.Data^[i]:=Sqr(G^.GetVal(G^.Graphics[0].X, i));
   G^.Graphics[0].Color:=12;

   G^.Graphics[1]:=G^.Graphics[0];
   G^.Graphics[1].Title:='Second';

   GetMem(G^.Graphics[1].Y.Data, SizeOf(TFloat)*(G^.Graphics[1].Y.MaxIndex+1));
   for i:=0 to G^.Graphics[1].Y.MaxIndex do
      G^.Graphics[1].Y.Data^[i]:=3.4+53.9*(1+Sin(G^.GetVal(G^.Graphics[1].X, i)));
   G^.Graphics[1].Color:=9;

   G^.MaxGraphic:=1;
   G^.CalcRange(1, True);

   Desktop^.Insert(G);

   App.Run;
   App.Done;
end.
