//VANYDEVD.H

#define BOGUSADDRESS 0xffffffff //Returned by MS routines

// These constants define the services of the VXD required by the application
// They are named from the perspective of the application (originator)
// NOTE: Any code numbers may be used except -1 & 0

#define VANYDEVD_GRAB_ADDRESSES      10 //Obtains an IN CONTEXT address of the global areas
#define VANYDEVD_INIT_ADEV_HARDWARE  11 //Requests the VXD to INIT the ANYDEV hardware using current parameters
#define VANYDEVD_ENABLE_ANYDEV_HDWR  14 //Requests the VXD to ENABLE ANYDEV 
#define VANYDEVD_DISABLE_ANYDEV_HWR  15 //Requests the VXD to DISABLE ANYDEV 

// This structure is SHARED by the application and the ANYDEV virtual device driver 
// It contains board configuration information, board status, and flags used by
// both software ends, This structure is built by the VXD and resides at ring-0

typedef struct ANYDEVprimary
	{
	DWORD flags;				//Status Flags, etc
	DWORD Global_addr_1MB;		//Address of board's memory below 1mb
	DWORD IRQhandle;			//IRQ handle
	DWORD IRQflags;				//User defined
	DWORD IRQcount;				//User defined
	DWORD IRQstatus;			//Set by Get IRQ Status routine
								//What ever the user desires goes here
	} ADEV, *ADEVPTR;

#define IRQ_VIRT_OK 1	

