;;VANYDEVD.asm
name VANYDEVD
.386p
;; ------------------------------------------------
;; ------------------------------------------------
;; VANYDEVD.asm -- Assembly module, MAIN module for
;; Dynamically loadable VxD for ANYDEV board
;; ------------------------------------------------
;; ------------------------------------------------

;; -----------------------------------
;; INCLUDE files needed by this module
;; -----------------------------------

include <\ddk\inc32\vmm.inc>
include <\ddk\inc32\vwin32.inc>
include <\ddk\inc32\vpicd.inc>

;; ------------------------------------
;; C routines/data used by this module
;; ------------------------------------
extrn _CVANYDEVD_Device_Init:near
extrn _CVANYDEVD_Device_UNInit:near
extrn _CVANYDEVD_Device_IOctrl:near
extrn _ISR_ANYDEV:near

;; -------------------------------------
;; Routines/data called from this module
;; -------------------------------------
public _GET_BD_MEM
public _Virt_IRQ
public _End_ISR
public _Physically_Mask_IRQ
public _Physically_UNMask_IRQ
public _UNVirt_IRQ
public _Get_IRQ_Status

 ; ==================================================================================
;; Misc VANYDEVD-specific Equates -- NOTE: This is where you change
;; the REV level or put any MS-assigned DEVICE ID (if DEVICE registered with MS).
;; Also change here the address & length of the below 1mb area used by ANYDEV
;; board and the IRQ used.
;; ----------------------------------------------------------------------------------
VANYDEVD_MajoREV equ 1		 ;ANYDEV's MAJOR revision level
VANYDEVD_MinoREV equ 0		 ;decimal number of revision
VANYDEVD_DeviceID equ Undefined_Device_ID ;no need for MS device number assignment
VANYDEVD_IRQ_Used equ 10		 ;IRQ used by ANYDEV board
VANYDEVD_1mb_adr  equ 0c0000h ;Below 1mb address used by ANYDEV board   
VANYDEVD_1mb_len  equ 01000h  ;Length of below 1mb area used by ANYDEV board
; ==================================================================================

;; ---------------------------------------------
;; Virtual Device Declaration (Required)
;; (Declares this code as virtual device driver)
;; Also creates the Device Data Block
;; ---------------------------------------------
 
Declare_Virtual_Device VANYDEVD,VANYDEVD_MajoREV,VANYDEVD_MinoREV,VANYDEVD_Control,VANYDEVD_DeviceID,Undefined_Init_Order



VxD_LOCKED_CODE_SEG
;; --------------------------------------------
;; Control Dispatch Table & Proc (Required)
;; Used to dispatch supported messages sent by
;; VMM -- clears carry for unsupported mssgs.
;; --------------------------------------------
;; Only 3 VMM messages are recognized and processed
;; by this routine -- all DIOC interface messages
;; translate to W32_DeviceIoControl mssgs from the VMM.
;; "Control_Dispatch" precedes MSSG NUMBER, PROCEDURE

BeginProc VANYDEVD_Control
    Control_Dispatch Sys_Dynamic_Device_Exit, VANYDEVD_Device_UNInit
    Control_Dispatch Sys_Dynamic_Device_Init, VANYDEVD_Device_Init
	Control_Dispatch W32_DeviceIoControl,     VANYDEVD_Device_IOctrl
    xor eax,eax  ;;return 0 (required in some instances)
    clc          ;;clear carry flg for GOOD indicator   
	ret
EndProc VANYDEVD_Control

;; -------------------------------------------------------------
;; NOTE: "BeginProc & EndProc" are needed in conjunction with
;; the above dispatch table -- below routines facilitate C fcns
;; -------------------------------------------------------------

;; =======================================================================
;; Routines below are VXD interface (load, unload, process) ROUTINES
;; =======================================================================

;; --------------------------------------------
;; Routine to jump to C routine for processing
;; SYS_DYNAMIC_DEVICE_INIT message
;; --------------------------------------------
BeginProc VANYDEVD_Device_Init
    call _CVANYDEVD_Device_Init
    ret
EndProc VANYDEVD_Device_Init

;; --------------------------------------------
;; Routine to jump to C routine for processing
;; SYS_DYNAMIC_DEVICE_EXIT message
;; --------------------------------------------

BeginProc VANYDEVD_Device_UNInit
        call _CVANYDEVD_Device_UNInit
        ret
EndProc VANYDEVD_Device_UNInit

;; --------------------------------------------
;; Routine to jump to C routine for processing
;; W32_DEVICEIOCONTROL messages -- These are
;; VxD requests from the application.
;; At entry, esi points to the DIOC interface
;; structure passed by the application
;; --------------------------------------------

BeginProc VANYDEVD_Device_IOctrl
        push esi
        call _CVANYDEVD_Device_IOctrl
        pop esi
        ret
EndProc VANYDEVD_Device_IOctrl

;; ======================================================
;; Routines below are miscellaneous assembly interfaces
;; ======================================================

;; -------------------
;; GET MEM BELOW 1MB
;; -------------------
BeginProc _GET_BD_MEM
         VMMcall _MapPhysToLinear <VANYDEVD_1mb_adr,VANYDEVD_1mb_len,0>
         ret
EndProc _GET_BD_MEM

;; -------------------
;; Handle EOI for ISR
;; -------------------
BeginProc _End_ISR
         VxDcall VPICD_Phys_EOI
         ret
EndProc _End_ISR

;; =======================================================================
;; Routines below are IRQ specific - for virtualization/unvirtualization
;; =======================================================================

;; -------------------
;; Virtualize IRQ
;; -------------------
BeginProc _Virt_IRQ
         push edi
         mov edi, OFFSET32 _VIRQdat
         VxDcall VPICD_Virtualize_IRQ
         jnc VIRQEXIT
         mov eax, 0ffffffffh  ;set ERR if appro
VIRQEXIT:
         pop edi
         ret
EndProc _Virt_IRQ

;; -------------------
;; UN Virtualize IRQ
;; -------------------
BeginProc _UNVirt_IRQ
         VxDcall VPICD_Force_Default_Behavior
         ret
EndProc _UNVirt_IRQ

;; ---------------
;; Get IRQ Status
;; ---------------
BeginProc _Get_IRQ_Status
         push ecx
         xor eax,eax
         mov ax,[_VIRQdat]
         VxDcall VPICD_Get_IRQ_Complete_Status
         jc statusbad
         xor eax,eax
         jmp statusex
statusbad:
         push ecx
         pop eax
statusex:
        pop ecx
         ret
EndProc _Get_IRQ_Status


;; -------------------
;; Physically Mask IRQ
;; -------------------
BeginProc _Physically_Mask_IRQ
         VxDcall VPICD_Physically_Mask
         ret
EndProc _Physically_Mask_IRQ

;; ----------------------
;; Physically UN-Mask IRQ
;; ----------------------
BeginProc _Physically_UNMask_IRQ
         VxDcall VPICD_Physically_Unmask
         ret
EndProc _Physically_UNMask_IRQ

VxD_LOCKED_CODE_ENDS

;; --------------------------------
;; VPICD IRQ Descriptor Block
;; --------------------------------
VxD_LOCKED_DATA_SEG
_VIRQdat dw VANYDEVD_IRQ_Used 		;; IRQ# 
         dw 0
         dd OFFSET32 _ISR_ANYDEV 	;; ISR ADDRESS
         dd 0
         dd 0
         dd 0
         dd 0
         dd 500
         dd 0
         dd 0
         dd 0
VxD_LOCKED_DATA_ENDS

        END

