// Text1.cpp -- Test routine for VANYDEVD.VXD interface
// A way to test dynamic load of VXD and VERIFY global addresses and data
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <\ddk\inc32\vmm.h>
#include <\ddk\inc32\vwin32.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <\msvc20\bin\VANYDEVD\VANYDEVD.H>

//NOTE: "\\\\.\\" indicates to CreateFile that a VXD is being loaded dynamically
char VxDpathName[] = "\\\\.\\c:\\xyz\\vanydevd.vxd";

//Init values show something other than 0 during debug sessions
DWORD vxd_outbuff[0x1024]={1,2,3,4,5,6,7,0,0,};

//Main interface test routine for VANYDEVD.VXD
int main(int argc, char *arg[])
{
HANDLE vxd_Handle;
int errx;
DWORD DIOC_count;
DWORD *AddrBelow1MB;
DWORD  DataToReview[10];
ADEVPTR SharedMemPtr;
	errx = 0;
	DIOC_count = 0;
	//Load the VXD dynamically
	vxd_Handle=CreateFile(&VxDpathName[0],0,0,NULL,0,FILE_FLAG_DELETE_ON_CLOSE,NULL);
	if (vxd_Handle == INVALID_HANDLE_VALUE)
			errx=GetLastError();
	 else
		 	{
			//If VxD LOAD was SUCCESSFUL, GRAB global Addresses and IRQ Status
			DeviceIoControl(vxd_Handle,VANYDEVD_GRAB_ADDRESSES,
					NULL,0,&vxd_outbuff[0],(DWORD) sizeof(vxd_outbuff),&DIOC_count,NULL);
			AddrBelow1MB = (DWORD *) vxd_outbuff[0];
			//Walk through here with debugger to verify addresses and data
			if (((DWORD) AddrBelow1MB) != BOGUSADDRESS)
				{
				DataToReview[0] = *AddrBelow1MB;
				SharedMemPtr = (ADEVPTR) vxd_outbuff[1];
				DataToReview[1] = SharedMemPtr->IRQcount;
				DataToReview[2] = SharedMemPtr->IRQhandle;
				DataToReview[3] = SharedMemPtr->IRQstatus;
				}
			else
				printf("\nBOGUS address received for 1MB area");
			}
	printf("\nERR %d \n",errx);
	if (vxd_Handle != INVALID_HANDLE_VALUE)
			CloseHandle(vxd_Handle);
	return(errx);
}
