#ifndef _MEM_H
#define _MEM_H
/*
 * mem.h:
 *      Includes for Nigel Horne's malloc wrap around for C. All output is
 * via stderr.
 *      To use just link the required object file into your application.
 * For the best results you should include this file (mem.h) in each source
 * file and recompile
 *
 * Version 1.5.
 *
 * DOS:
 *      Suitable for MSC8.00c (a.k.a. MSVC 1.5)
 * usage: cl /AS test.c dosmems.obj /link /noe
 *
 * SCO Unix:
 * Contains mem.o which you should link with your application,
 * and mem.h which you can optionally include in each .c file. This would be
 * the best action as then mem.o will be better at finding which file has
 * gone wrong. The included test.c shows some common problems. To test all
 * is well I suggest you try "cc test.c mem.o -link -z" and see look at the
 * output. Do not link with the shared library "-lc_s" option, as this will
 * cause conflicts with the library.
 *
 * HP\UX:
 * As SCO Unix.
 *
 * AIX:
 *	You do not want builtins. Use
 *	cc -O2 -roconst -U__STR__ -qlanglvl=ansi *.c
 *
 * Internet: njh@smsltd.demon.co.uk; Fidonet: Nigel Horne @ 2:2502/21.10;
 * Packet: G0LOV@GB7SYP.#19.GBR.EDU; Phone: +44-1226-283021.
 */
#include <stdio.h>
#include <assert.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#ifdef  MSDOS
#include <conio.h>
#endif
#include <limits.h>
#include <stdlib.h>
#ifndef sun
#include <stdarg.h>
#endif

#pragma function(memset, memcpy, memcmp, strcmp, strcpy, strcat)

typedef enum { false = 0, true = 1 } bool;

#define malloc(s)       db_mallocchk(s, __FILE__, __LINE__)
#define calloc(n, s)    db_callocchk(n, s, __FILE__, __LINE__)
#define realloc(o, s)   db_reallocchk(o, s, __FILE__, __LINE__)
#define strdup(s)       db_strdupchk(s, __FILE__, __LINE__)
#define free(s) db_freechk(s, __FILE__, __LINE__)
#define heapchk()       db_heapchk(__FILE__, __LINE__)

#ifdef  __GNUC__
#define pascal
#define cdecl
#define _pascal
#define _cdecl
#endif

#if     defined(_unix) && !defined(unix)
#define unix
#endif

#if     !defined(MSDOS) && !defined(M_XENIX)
#define _cdecl
#define cdecl
#define _pascal
#define pascal
#endif

void    *_pascal        db_mallocchk(size_t size, const char *file, int line);
void    *_pascal        db_callocchk(size_t nelem, size_t size, const char
*file, int line);
void    *_pascal        db_reallocchk(void *oarea, size_t size, const char
*file, int line);
char    *_pascal        db_strdupchk(const char *string, const char *file,
int line);
void    _pascal db_freechk(void *memblock, const char *file, int line);
void    _pascal db_heapchk(const char *file, int line);

#ifndef sun
extern  bool    check_for_leaks;        /*
                                         * check for memory leaks - default
true
                                         */
#endif
#endif /* _MEM_H */
