// DyncoSet.cpp : implementation file
//

#include "stdafx.h"
#include "dyncol32.h"
#include "dyncoSet.h"
#include "TblsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDyncol32Set

IMPLEMENT_DYNAMIC(CDyncol32Set, CRecordset)

CDyncol32Set::CDyncol32Set(CDatabase* pdb)
	: CRecordset(pdb)
{
	//{{AFX_FIELD_INIT(CDyncol32Set)
	//}}AFX_FIELD_INIT
	m_nDefaultType = snapshot;
	
	m_pDatabase = new CDatabase;
}

CDyncol32Set::~CDyncol32Set()
{
	if (m_pDatabase)
	{
		delete m_pDatabase;
		m_pDatabase = NULL;
	}

	// Delete all the dynamically allocated column data upon destruction
	if (!m_pList.IsEmpty())
	{ 
		POSITION rPos = m_pList.GetHeadPosition();
		CColumnData *pData = (CColumnData *)m_pList.GetNext(rPos); 
	
		while (pData)
		{
			delete pData;
			if (rPos)
				pData = (CColumnData *)m_pList.GetNext(rPos);
			else
				pData = NULL;		
		}	
	}
}

CString CDyncol32Set::GetDefaultConnect()
{
	return _T("ODBC;");
}

CString CDyncol32Set::GetDefaultSQL()
{
	// This should never get called
	return _T("!");
}

void CDyncol32Set::DoFieldExchange(CFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CDyncol32Set)
	//}}AFX_FIELD_MAP
		// Set the type of exhange; same as AppWizard generated
	pFX->SetFieldType(CFieldExchange::outputColumn);
	
	// Get a pointer to the first CColumnData object in the list
	POSITION rPos = m_pList.GetHeadPosition();
	CColumnData *pData = (CColumnData *)m_pList.GetNext(rPos); 

	// Loop until we've traversed all the columns	
	while (pData)
	{
		// Call the appropriate RFX routine for the column's type
		switch(pData->m_nDataType)
		{
			case SQL_BIT:
				RFX_Bool(pFX, pData->m_strColumnName, *((BOOL *)(pData->m_pData)));
				break;

			case SQL_TINYINT:
				RFX_Byte(pFX, pData->m_strColumnName, *((BYTE *)(pData->m_pData)));
				break;

			case SQL_SMALLINT:
				RFX_Int(pFX, pData->m_strColumnName, *((int *)(pData->m_pData)));
				break;

			case SQL_INTEGER:
				RFX_Long(pFX, pData->m_strColumnName, *((long *)(pData->m_pData)));
				break;

			case SQL_REAL:
				RFX_Single(pFX, pData->m_strColumnName, *((float *)(pData->m_pData)));
				break;

			case SQL_FLOAT:
			case SQL_DOUBLE:
				RFX_Double(pFX, pData->m_strColumnName, *((double *)(pData->m_pData)));
				break;

			case SQL_DATE:
			case SQL_TIME:
			case SQL_TIMESTAMP:
				RFX_Date(pFX, pData->m_strColumnName, *((CTime *)(pData->m_pData)));
				break;

			case SQL_BINARY:
			case SQL_VARBINARY:
				RFX_Binary(pFX, pData->m_strColumnName, *((CByteArray *)(pData->m_pData)));
				break;

			case SQL_DECIMAL:   // ODBC default xfer type
			case SQL_NUMERIC:   // ODBC default xfer type
			case SQL_CHAR:
			case SQL_VARCHAR:
				RFX_Text(pFX, pData->m_strColumnName, *((CString *)(pData->m_pData)));
				break;

			case SQL_LONGVARCHAR:
			case SQL_LONGVARBINARY:
				RFX_LongBinary(pFX, pData->m_strColumnName, *((CLongBinary *)(pData->m_pData)));
				break;

			default:
				ASSERT(FALSE);

			}

		// Set pData to NULL if that was the last column
		if (rPos)
			pData = (CColumnData *)m_pList.GetNext(rPos);
		else
			pData = NULL;		
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDyncol32Set diagnostics

#ifdef _DEBUG
void CDyncol32Set::AssertValid() const
{
	CRecordset::AssertValid();
}

void CDyncol32Set::Dump(CDumpContext& dc) const
{
	CRecordset::Dump(dc);
}
#endif //_DEBUG


BOOL CDyncol32Set::Open(UINT nOpenType, LPCSTR lpszSql, DWORD dwOptions)
{
	// open the database object so we can use it with all three
	// recordsets
	if (! m_pDatabase->Open(NULL, FALSE, FALSE, _T("ODBC;")))
		return  FALSE;

	// display a dialog with a list of tables in the DSN chosed during
	// the database Open() call.  The CTablesDialog class opens and maintains
	// a recordset (CTables).
	CTablesDialog tableName(NULL, m_pDatabase);
	if (IDCANCEL == tableName.DoModal())
	{
		TRACE("No tables selected\n");
		return FALSE;
	}

	// determine the columns of the table selected 
	m_pColumns = new CColumns(m_pDatabase);

	m_pColumns->m_strTableNameParam = tableName.m_strTableNameSelected;

	if (!m_pColumns->Open(CRecordset::forwardOnly, NULL, CRecordset::readOnly))
	{
		TRACE("m_pColumns->Open() failed\n");
		return FALSE;
	}

	// Initialize the number of fields dynamically allocated to CDynaSet
    m_nFields = 0;

    // Loop until we've seen all the columns
	while (!m_pColumns->IsEOF())
	{
		// Allocate a new CColumnData object for the current column
		CColumnData *pData = new CColumnData;

		// Store the colmun information				
		pData->m_nDataType = m_pColumns->m_nDataType;
		// wrap field names with brackets in case they have spaces
		// MFC takes care of converting these brackets to the driver specific qoute character
		pData->m_strColumnName = bracketWrap(m_pColumns->m_strColumnName);
		
		// Allocate an object of the appropriate type to store
		// the coulmn data
		switch(pData->m_nDataType)
		{
			case SQL_BIT:
				pData->m_pData = (void *)new BOOL;
				break;

			case SQL_TINYINT:
				pData->m_pData = (void *)new BYTE;
				break;

			case SQL_SMALLINT:
				pData->m_pData = (void *)new int;
				break;

			case SQL_INTEGER:
				pData->m_pData = (void *)new long;
				break;

			case SQL_REAL:
				pData->m_pData = (void *)new float;
				break;

			case SQL_FLOAT:
			case SQL_DOUBLE:
				pData->m_pData = (void *)new double;
				break;

			case SQL_DATE:
			case SQL_TIME:
			case SQL_TIMESTAMP:
				pData->m_pData = (void *)new CTime;
				break;

			case SQL_BINARY:
			case SQL_VARBINARY:
				pData->m_pData = (void *)new CByteArray;
				break;

			case SQL_DECIMAL:   // ODBC default xfer type
			case SQL_NUMERIC:   // ODBC default xfer type
			case SQL_CHAR:
			case SQL_VARCHAR:
				pData->m_pData = (void *)new CString;
				break;

			case SQL_LONGVARCHAR:
			case SQL_LONGVARBINARY:
				pData->m_pData = (void *)new CLongBinary;
				break;

			default:
				ASSERT(FALSE);

		}
		          
		// Add the column descriptor to the list and
		// increment the number of columns in the CDynaSet				          
		m_pList.AddTail(pData);
		m_nFields++;

		// Get the next column's information		
		m_pColumns->MoveNext();
	}

	// wrap table name with brackets 
	CString strSQL = bracketWrap(m_pColumns->m_strTableNameParam);
	lpszSql = strSQL.GetBuffer(strSQL.GetLength());
	strSQL.ReleaseBuffer();

	// we are done with the columns recordset
	delete m_pColumns;
	
	// Return the base class if we got this far
	return CRecordset::Open(nOpenType, lpszSql, dwOptions);

}
