// dyncolVw.cpp : implementation of the CDyncol32View class
//

#include "stdafx.h"
#include "dyncol32.h"

#include "dyncoSet.h"
#include "dyncoDoc.h"
#include "dyncolVw.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDyncol32View

IMPLEMENT_DYNCREATE(CDyncol32View, CRecordView)

BEGIN_MESSAGE_MAP(CDyncol32View, CRecordView)
	//{{AFX_MSG_MAP(CDyncol32View)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRecordView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDyncol32View construction/destruction

CDyncol32View::CDyncol32View()
	: CRecordView(CDyncol32View::IDD)
{
	//{{AFX_DATA_INIT(CDyncol32View)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CDyncol32View::~CDyncol32View()
{
}

void CDyncol32View::DoDataExchange(CDataExchange* pDX)
{
	CRecordView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDyncol32View)
	DDX_Control(pDX, IDC_GRID1, m_grid);
	//}}AFX_DATA_MAP
	RefreshData();
}

BOOL CDyncol32View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRecordView::PreCreateWindow(cs);
}

void CDyncol32View::OnInitialUpdate()
{
	m_pSet = &GetDocument()->m_dyncol32Set;
	CRecordView::OnInitialUpdate();

	// parse the DSN and table name to show on
	// the caption of each MDI window
	if (m_pSet->IsOpen())
	{
		CString strDSN = m_pSet->m_pDatabase->GetConnect();
		// GetConnect() returns the entire connect string in the form
		// "ODBC;DSN=MyDataSource;DBQ=..." plus more driver specific params
		strDSN = (strDSN.Right(strDSN.GetLength() - (strDSN.Find(_T("DSN="))+4)));
		strDSN = strDSN.Left(strDSN.Find(_T(";")));
		GetDocument()->SetTitle(strDSN + _T(" - ") + m_pSet->GetTableName());
	}
	ResizeParentToFit(FALSE);
	ResizeParentToFit();



}

/////////////////////////////////////////////////////////////////////////////
// CDyncol32View printing

BOOL CDyncol32View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CDyncol32View::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CDyncol32View::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CDyncol32View diagnostics

#ifdef _DEBUG
void CDyncol32View::AssertValid() const
{
	CRecordView::AssertValid();
}

void CDyncol32View::Dump(CDumpContext& dc) const
{
	CRecordView::Dump(dc);
}

CDyncol32Doc* CDyncol32View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDyncol32Doc)));
	return (CDyncol32Doc*)m_pDocument;
}
#endif //_DEBUG

CRecordset* CDyncol32View::OnGetRecordset()
{
	return m_pSet;
}

/////////////////////////////////////////////////////////////////////////////
// CDyncol32View message handlers

void CDyncol32View::RefreshData()
{
	if (!m_pSet->IsOpen())
		return;
	// Get pointer to CDynaSet's CColumnData list
	CPtrList *pList = &m_pSet->m_pList;
	
	// Get the first element
	POSITION rPos = pList->GetHeadPosition();
	CColumnData *pData = (CColumnData *)pList->GetNext(rPos);
	
	// Allocate a string buffer to be used in conversions
	CString strBuffer;
	
	// Set the intial row to fill in
	int row = 1;
	
	// Set the GRID to have the correct number of rows and columns
	m_grid.SetRows(m_pSet->m_nFields + 1);
	m_grid.SetCols(2);
	m_grid.SetColWidth(0, 2500);
	m_grid.SetColWidth(1, 2500);

	// Loop until we've traversed all the CColumnData objects
	while (pData)
	{
		// Insert the column name in the first column and move
		// to the second column to insert the data
		m_grid.SetRow(row);
		m_grid.SetCol(0);
		m_grid.SetText(pData->m_strColumnName);
		m_grid.SetCol(1);

		// Call the appropriate DDX
		switch(pData->m_nDataType)
		{
			case SQL_BIT:
				strBuffer = *((BOOL *) (pData->m_pData)) ? _T("TRUE") : _T("FALSE");
				m_grid.SetText(strBuffer);
				break;

			case SQL_TINYINT:
				{
					char *pBuffer = strBuffer.GetBuffer(32);
					_itoa(*((BYTE *)(pData->m_pData)), pBuffer, 10);
				}
				strBuffer.ReleaseBuffer();
				m_grid.SetText(strBuffer);

				break;

			case SQL_SMALLINT:
			case SQL_INTEGER:
				{
					char *pBuffer = strBuffer.GetBuffer(32);
					_itoa(*((int *)(pData->m_pData)), pBuffer, 10);
				}
				strBuffer.ReleaseBuffer();
				m_grid.SetText(strBuffer);
				break;

			case SQL_REAL:
				{
					char *pBuffer = strBuffer.GetBuffer(32);
					sprintf(pBuffer, "%#f", *((float *) (pData->m_pData)));
				}
				strBuffer.ReleaseBuffer();
				m_grid.SetText(strBuffer);
				break;

			case SQL_FLOAT:
			case SQL_DOUBLE:
				{
					char *pBuffer = strBuffer.GetBuffer(32);
					sprintf(pBuffer, "%#f", *((double *) (pData->m_pData)));
				}
				strBuffer.ReleaseBuffer();
				m_grid.SetText(strBuffer);
				break;

			case SQL_DATE:
			case SQL_TIME:
			case SQL_TIMESTAMP:
				strBuffer = ((CTime *)(pData->m_pData))->Format( "%c" );
				m_grid.SetText(strBuffer);
				break;

			case SQL_BINARY:
			case SQL_VARBINARY:
				m_grid.SetText(_T("Binary Field"));
				break;

			case SQL_DECIMAL:   // ODBC default xfer type
			case SQL_NUMERIC:   // ODBC default xfer type
			case SQL_CHAR:
			case SQL_VARCHAR:
				m_grid.SetText(*((CString *)(pData->m_pData)));
				break;

			case SQL_LONGVARCHAR:
			case SQL_LONGVARBINARY:
				m_grid.SetText(_T("Longvarchar or Longvarbinary"));
				break;

			default:
				ASSERT(FALSE);
		}
		// Increment the row and check to see if that was our
		// last CColumnData in the list
		row++;
		if (rPos)
			pData = (CColumnData *)pList->GetNext(rPos);
		else
			pData = NULL;		
	}
}
