// ColData.cpp : implementation of the CColumnData class
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "dyncol32.h"
#include "ColData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColumnData

CColumnData::CColumnData()
{
	m_nDataType = 0;		    // ODBC defined constant for data type (e.g. SQL_VARCHAR)
	m_strColumnName = _T("");	// CString to hold the database column name
	m_pData = NULL;				// void pointer to allocated data for column
}

CColumnData::~CColumnData()
{   
	// delete based on data type
	switch(m_nDataType)                                                 
	{
			case SQL_BIT:
				delete (BOOL*) m_pData;
				break;

			case SQL_TINYINT:
				delete (BYTE*) m_pData;
				break;

			case SQL_SMALLINT:
				delete (int*) m_pData;
				break;

			case SQL_INTEGER:
				delete (long*) m_pData;
				break;

			case SQL_REAL:
				delete (float*) m_pData;
				break;

			case SQL_FLOAT:
			case SQL_DOUBLE:
				delete (double*) m_pData;
				break;

			case SQL_DATE:
			case SQL_TIME:
			case SQL_TIMESTAMP:
				delete (CTime*) m_pData;
				break;

			case SQL_BINARY:
			case SQL_VARBINARY:
				delete (CByteArray*) m_pData;
				break;

			case SQL_DECIMAL:   // ODBC default xfer type
			case SQL_NUMERIC:   // ODBC default xfer type
			case SQL_CHAR:
			case SQL_VARCHAR:
				delete (CString*) m_pData;
				break;

			case SQL_LONGVARCHAR:
			case SQL_LONGVARBINARY:
				delete (CLongBinary*) m_pData;
				break;

			default:
				ASSERT(FALSE);

		}
}
