// Columns.cpp : implementation of the CColumns class
//
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Columns.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColumns implementation

IMPLEMENT_DYNAMIC(CColumns, CRecordset)

CColumns::CColumns(CDatabase* pDatabase)
	: CRecordset(pDatabase)
{
	//{{AFX_FIELD_INIT(CColumns)
	m_strQualifier = _T("");
	m_strOwner = _T("");
	m_strTableName = _T("");
	m_strColumnName = _T("");
	m_nDataType = 0;
	m_strTypeName = _T("");
	m_lPrecision = 0;
	m_lLength = 0;
	m_nScale = 0;
	m_nRadix = 0;
	m_nFields = 11;
	//}}AFX_FIELD_INIT
	m_nDefaultType = snapshot;
	m_strQualifierParam = _T("");
	m_strOwnerParam = _T("");
	m_strTableNameParam = _T("");
	m_strColumnNameParam = _T("");
}

BOOL CColumns::Open(UINT nOpenType /* AFX_DB_USE_DEFAULT_TYPE */,
	LPCSTR lpszSQL /* = NULL */, DWORD dwOptions /* = none */)
{
	RETCODE nRetCode;
	ASSERT(lpszSQL == NULL);

	if (m_hstmt == SQL_NULL_HSTMT)
	{
		CString strDefaultConnect;
		TRY
		{
			if (m_pDatabase == NULL)
			{
				m_pDatabase = new CDatabase();
				m_bRecordsetDb = TRUE;
			}

			strDefaultConnect = GetDefaultConnect();
			// If not already opened, attempt to open
			if (!m_pDatabase->IsOpen() &&
				!m_pDatabase->Open(NULL, FALSE, FALSE, strDefaultConnect))
				return FALSE;

			AFX_SQL_SYNC(::SQLAllocStmt(m_pDatabase->m_hdbc, &m_hstmt));
			if (!Check(nRetCode))
				ThrowDBException(SQL_INVALID_HANDLE);
		}
		CATCH_ALL(e)
		{
#ifdef _DEBUG
			if (afxTraceFlags & 0x20)
				TRACE0("Error: CDatabase create for CRecordset failed\n");
#endif // _DEBUG
			strDefaultConnect.Empty();
			if (m_bRecordsetDb)
			{
				delete m_pDatabase;
				m_pDatabase = NULL;
			}
			ASSERT(m_hstmt == SQL_NULL_HSTMT);
			THROW_LAST();
		}
		END_CATCH_ALL
	}

	TRY
	{
		// set any options, like timeouts, scrolling options
		OnSetOptions(m_hstmt);

		// call the ODBC catalog function with data member params
		RETCODE nRetCode;
		AFX_SQL_ASYNC(this, ::SQLColumns(m_hstmt,
			(m_strQualifierParam.IsEmpty()? (UCHAR FAR *)NULL: (UCHAR FAR *)(const char*)m_strQualifierParam), SQL_NTS,
			(m_strOwnerParam.IsEmpty()? (UCHAR FAR *)NULL: (UCHAR FAR *)(const char*)m_strOwnerParam), SQL_NTS,
			(m_strTableNameParam.IsEmpty()? (UCHAR FAR *)NULL: (UCHAR FAR *)(const char*)m_strTableNameParam), SQL_NTS,
			NULL, SQL_NTS));
		if (!Check(nRetCode))
		{
			AfxThrowDBException(nRetCode, m_pDatabase, m_hstmt);
		}
		// load first record
		MoveFirst();
	}
	CATCH_ALL(e)
	{
		Close();
		THROW_LAST();
	}
	END_CATCH_ALL
	return TRUE;
}

CString CColumns::GetDefaultConnect()
{
	// Use the same data source as CDynaSet
	return _T("ODBC;");
}

CString CColumns::GetDefaultSQL()
{
	// there is no default SQL - a direct ODBC call is made instead
	ASSERT(FALSE);
	return _T("!");
}

void CColumns::DoFieldExchange(CFieldExchange* pFX)
{
	//{{AFX_FIELD_MAP(CColumns)
	pFX->SetFieldType(CFieldExchange::outputColumn);
	RFX_Text(pFX, _T("[table_qualifier]"), m_strQualifier);
	RFX_Text(pFX, _T("[table_owner]"), m_strOwner);
	RFX_Text(pFX, _T("[table_name]"), m_strTableName);
	RFX_Text(pFX, _T("[column_name]"), m_strColumnName);
	RFX_Int(pFX, _T("[data_type]"), m_nDataType);
	RFX_Text(pFX, _T("[type_name]"), m_strTypeName);
	RFX_Long(pFX, _T("[precision]"), m_lPrecision);
	RFX_Long(pFX, _T("[length]"), m_lLength);
	RFX_Int(pFX, _T("[scale]"), m_nScale);
	RFX_Int(pFX, _T("[radix]"), m_nRadix);
	RFX_Int(pFX, _T("[nullable]"), m_nNullable);
	//}}AFX_FIELD_MAP
}
