unit Select;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TSelectForm = class(TForm)
    CountTimer: TTimer;
    OpenFileDialog: TOpenDialog;
    Label1: TLabel;
    Filename: TLabel;
    Label3: TLabel;
    Words: TLabel;
    Label5: TLabel;
    Lines: TLabel;
    Select: TButton;
    CountMessage: TLabel;
    procedure SelectClick(Sender: TObject);
    procedure CountTimerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SelectForm: TSelectForm;

implementation

{$R *.DFM}

uses General;

procedure TSelectForm.SelectClick(Sender: TObject);
begin
   If OpenFileDialog.Execute then
   begin
      FileName.Caption := OpenFileDialog.FileName;
      CountTimer.Enabled := true;
      Select.Enabled := false;
      end;
   end;

var CountFile: Text;

procedure TSelectForm.CountTimerTimer(Sender: TObject);
const
   TotalWords : Longint = 0;
   TotalLines : Longint = 0;
   NewFile    : Boolean = true;
var
   S          : String;
begin
   If NewFile then
   begin
      system.assign(CountFile, Filename.Caption);
      {$I-}
      reset(CountFile);
      {$I+}
      If IOResult<>0 then
      begin
         CountMessage.Caption := 'Error opening file.';
         CountTimer.Enabled := false;
         Select.Enabled := true;
         end
      else begin
         NewFile := false;
         CountMessage.Caption := '';
         end;
      end
   else begin
      readln(CountFile, S);
      Inc(TotalWords, WordCount(S));
      Words.Caption := StrFn(TotalWords);
      Inc(TotalLines);
      Lines.Caption := StrFn(TotalLines);
      If Eof(CountFile) then
      begin
         CountMessage.Caption := 'Count complete';
         TotalWords := 0;
         TotalLines := 0;
         NewFile := True;
         System.Close(CountFile);
         CountTimer.Enabled := False;
         Select.Enabled := True;
         end;
      end;
   end;

end.
