unit Remedit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, RemEng;

type
  TReminderEdit = class(TForm)
    Month: TComboBox;
    Message: TEdit;
    Label1: TLabel;
    Window: TSpinEdit;
    Nag: TCheckBox;
    OK: TButton;
    Cancel: TButton;
    Day: TSpinEdit;
    Cleared: TCheckBox;
    procedure OKClick(Sender: TObject);
    procedure MonthChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ReminderFile: TReminderReader;
    ReminderNumber: Longint;
  end;

var
  ReminderEdit: TReminderEdit;

implementation

{$R *.DFM}

procedure TReminderEdit.OKClick(Sender: TObject);
var RemDate          : TDateTime;
    Y, M, D          : Word;
    R                : TReminder;
begin
   {Get the Current Year}
   DecodeDate(Date, Y, M, D);
   RemDate := EncodeDate(Y, Month.ItemIndex+1, Day.Value);
   R := Treminder.Create(Message.Text, RemDate,
                         Window.Value, Nag.Checked, Cleared.Checked);
   If ReminderNumber = 0
      then ReminderFile.PutReminder(ReminderFile.NUmberOfREminders+1, R)
      else ReminderFile.PutReminder(ReminderNumber, R);
   end;


procedure TReminderEdit.MonthChange(Sender: TObject);
type
   Months = (Jan, Feb, Mar, Apr, May, Jun,
            Jul, Aug, Sep, Oct, Nov, Dec);
begin
   case Months(Month) of
      Jan, Mar, May, Jul,
      Aug, Oct, Dec      : Day.MaxValue := 31;
      Feb                : Day.MaxValue := 28;
      Apr, Jun, Sep, Nov : Day.MaxValue := 30;
      end;
   Ok.Enabled := True;
   end;


procedure TReminderEdit.FormActivate(Sender: TObject);
begin
   If Month.ItemIndex<>-1 then OK.Enabled := true;
   end;

end.
