unit Hiloform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin;

type
  THiLoMain = class(TForm)
    Card1: TLabel;
    Card2: TLabel;
    Label4: TLabel;
    Stack: TLabel;
    Discard: TLabel;
    Cash: TLabel;
    Message: TLabel;
    Bet: TSpinEdit;
    HiLo: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure StackClick(Sender: TObject);
    procedure DiscardClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
   Suits = (Clubs, Diamonds, Hearts, Spades);
   Ranks = (Back, Ace, Two, Three, Four, Five, Six,
            Seven, Eight, Nine, Ten, Jack, Queen, King);

   cards = record
      Suit: Suits;
      Rank: Ranks;
      end;

   CardDeck = array[1..52] of cards;

   GameState = (NoCards, OneCard, TwoCards, ThreeCards, Reset);
var
  HiLoMain: THiLoMain;
  Deck : CardDeck;
  State: GameState;
  Dealt: Byte;
  Funds: Integer;

{You need this line if you aren't using the deck of cards control.}
  CardNames: Array[Ace..King, Clubs..Spades] of string[20];

implementation

{$R *.DFM}

procedure InitializeDeck(var Deck: CardDeck);
var I    : Integer;
    Rank : Ranks;
    Suit : Suits;
    R,S  : String;
begin
   I := 1;
   For Suit := Clubs to Spades do
      For Rank := Ace to King do
   begin
      Deck[I].Suit    := Suit;
      Deck[I].Rank    := Rank;

   {special code for non-card-deck users}
      case Suit of
         Clubs   : S := 'Clubs';
         Diamonds: S := 'Diamonds';
         Hearts  : S := 'Hearts';
         Spades  : S := 'Spades';
         end;

      case Rank of
         Back    : R := 'Back';
         Ace     : R := 'Ace';
         Two     : R := 'Two';
         Three   : R := 'Three';
         Four    : R := 'Four';
         Five    : R := 'Five';
         Six     : R := 'Six';
         Seven   : R := 'Seven';
         Eight   : R := 'Eight';
         Nine    : R := 'Nine';
         Ten     : R := 'Ten';
         Jack    : R := 'Jack';
         Queen   : R := 'Queen';
         King    : R := 'King';
         end;
      CardNames[Rank, Suit] := R + ' of ' + S;
   {End Special Code for non-card-deck users}
      Inc(I);
      end;
   end;

procedure ShuffleDeck(var Deck: CardDeck);
var Hold: Cards;
    I,J : Integer;
begin
   for I := 1 to 52 do
   begin
      Hold := Deck[I];
      J := Random(52)+1;
      Deck[I] := Deck[J];
      Deck[J] := Hold;
      end;
   end;

function StrFn(L: longint): String;
var S: String;
begin
   Str(L, S);
   StrFn := S;
   end;


procedure THiLoMain.FormCreate(Sender: TObject);
begin
   State := NoCards;
   Dealt := 0;
   Funds := 100;
   Bet.MaxValue := Funds;
   InitializeDeck(Deck);
   ShuffleDeck(Deck);
   Cash.Caption := StrFn(Funds);
   end;

procedure THiLoMain.StackClick(Sender: TObject);
var HiRank, LoRank: Ranks;
begin
   case State of
     NoCards: begin
        Inc(Dealt);
(*
        {VSP Card Control code}
        Card1.Value := Ord(Deck[Dealt].Rank);
        Card1.Suit := Ord(Deck[Dealt].Suit);
*)
        {Label Control code}
        Card1.caption := CardNames[Deck[Dealt].Rank, Deck[Dealt].Suit];

        Card1.Visible := True;
        end;
      OneCard: begin
         Inc(Dealt);
(*
         {VSP Card control code}
         Card2.Value := Ord(Deck[Dealt].Rank);
         Card2.Suit := Ord(Deck[Dealt].Suit);
*)
         {Label control code}
         Card2.caption := CardNames[Deck[Dealt].Rank, Deck[Dealt].Suit];

         Card2.Visible := true;
         end;
   TwoCards: begin
         Inc(Dealt);
(*
         {VSP Card control code}
         HiLo.Value := Ord(Deck[Dealt].Rank);
         HiLo.Suit := Ord(Deck[Dealt].Suit);
*)
         {Label control code}
         HiLo.caption := CardNames[Deck[Dealt].Rank, Deck[Dealt].Suit];

         HiLo.Visible := true;

         If Deck[Dealt-1].Rank > Deck[Dealt-2].Rank then
         begin
            HiRank := Deck[Dealt-1].Rank;
            LoRank := Deck[Dealt-2].Rank;
            end
         else begin
            HiRank := Deck[Dealt-2].Rank;
            LoRank := Deck[Dealt-1].Rank;
            end;

         If Deck[Dealt].Rank in [LoRank..HiRank] then
         begin
           If Bet.Value = 0 then Message.Caption := 'Too bad!'
           else begin
              Inc(Funds, Bet.Value);
              Message.Caption := 'You won!';
              end;
           end
         else begin
            if Bet.Value = 0 then Message.Caption := 'Smart move.'
            else begin
               Dec(Funds, Bet.Value);
               Message.Caption := 'You lost';
               end;
            end;

         Bet.MaxValue := Funds;
         Cash.Caption := StrFn(Funds);
         end;

      ThreeCards: begin
         Card1.Visible := False;
         Card2.Visible := False;
         HiLo.Visible := False;
         end;
      end;

   Inc(State);
   If State<>ThreeCards then Message.Caption := '';
   If State = Reset then State := NoCards;
   If Dealt = 51 then
   begin
      Stack.Visible := False;
      Discard.Visible := True;
      end;
   end;

procedure THiLoMain.DiscardClick(Sender: TObject);
begin
   Discard.Visible := False;
   Stack.Visible := True;
   HiLo.Visible := False;
   Card1.Visible := False;
   Card2.Visible := False;

   State := NoCards;

   ShuffleDeck(Deck);
   Dealt := 0;
   end;

end.
