unit Calcrf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TCalcForm = class(TForm)
    Seven: TButton;
    Eight: TButton;
    Nine: TButton;
    Plus: TButton;
    Clear: TButton;
    Four: TButton;
    Five: TButton;
    Six: TButton;
    Minus: TButton;
    AllClear: TButton;
    One: TButton;
    Two: TButton;
    Multiply: TButton;
    Three: TButton;
    Zero: TButton;
    Equal: TButton;
    Divide: TButton;
    Entry: TEdit;
    Decimal: TButton;
    procedure ZeroClick(Sender: TObject);
    procedure OneClick(Sender: TObject);
    procedure TwoClick(Sender: TObject);
    procedure ThreeClick(Sender: TObject);
    procedure FourClick(Sender: TObject);
    procedure FiveClick(Sender: TObject);
    procedure SixClick(Sender: TObject);
    procedure SevenClick(Sender: TObject);
    procedure EightClick(Sender: TObject);
    procedure NineClick(Sender: TObject);
    procedure PlusClick(Sender: TObject);
    procedure MinusClick(Sender: TObject);
    procedure MultiplyClick(Sender: TObject);
    procedure DivideClick(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure AllClearClick(Sender: TObject);
    procedure EntryChange(Sender: TObject);
    procedure EqualClick(Sender: TObject);
    procedure DecimalClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CalcForm: TCalcForm;
  Total   : Real;
  Complete: Boolean;
  Operator: Char;

implementation

{$R *.DFM}

function ValFn(S: String): Real;
var Code: Integer;
    L   : Real;
begin
   Val(S, L, Code);
   ValFn := L;
   end;

function StrFn(L: Real): String;
var
   Sc, Scientific, Converted, Digit : String;
   I, Exponent                      : Integer;
   Negate                           : Boolean;
begin
   Str(L, Scientific);
   {There seems to be a bug in Delphi's Str function currently,
    or perhaps a hardware incompatibilty.  Calling Str with L
    as 0.3 is returning ' 3.00000000000182E-0001' on my machine.}
   Sc := Scientific;
   If Copy(Scientific, 1, 1) = '-' then Negate := true
   else Negate := false;
   Delete(Scientific, 1, 1);
   I := Pos('E', Scientific);
   dec(I);
   while(Copy(Scientific,I,1)='0') do
   begin
      Delete(Scientific, I, 1);
      Dec(I);
      end;
   Converted := '';
   I := 1;
   repeat
      Digit := Copy(Scientific, I, 1);
      If (Digit<>'.') and (Digit<>'E')
         then Converted := Converted + Digit;
      Inc(I);
      until(Digit = 'E');
   Val(Copy(Scientific, I, 5), Exponent, I);
   I := Exponent + 2;
   while I > Length(Converted)+1 do Converted := Converted + '0';
   while I < 1 do
   begin
      Inc(I);
      Converted := '0' + Converted;
      end;
   If I <= Length(Converted) then Insert('.', Converted, I);
   If Negate then Converted := '.' + Converted;
   If Length(Converted) > 17 then StrFn := Sc
   else StrFn := Converted;
   end;

procedure Calculate(Number: Real; NextOp: Char);
begin
   If not Complete or (Total=0) then
   case Operator of
      '+': Total := Total + Number;
      '-': Total := Total - Number;
      'x': Total := Total * Number;
      '': Total := Total / Number;
      end;
   Operator := NextOp;
   Complete := True;
   end;

procedure TCalcForm.ZeroClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '0';
   end;

procedure TCalcForm.OneClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '1';
end;

procedure TCalcForm.TwoClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '2';
end;

procedure TCalcForm.ThreeClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '3';
end;

procedure TCalcForm.FourClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '4';
end;

procedure TCalcForm.FiveClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '5';
end;

procedure TCalcForm.SixClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '6';
end;

procedure TCalcForm.SevenClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '7';
end;

procedure TCalcForm.EightClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '8';
end;

procedure TCalcForm.NineClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   Entry.Text := Entry.Text + '9';
end;

procedure TCalcForm.PlusClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '+');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.MinusClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '-');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.MultiplyClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), 'x');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.DivideClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '');
   Entry.Text := StrFn(Total);
   end;

procedure TCalcForm.ClearClick(Sender: TObject);
begin
  Entry.Text := '0';
  Complete := True;
end;

procedure TCalcForm.AllClearClick(Sender: TObject);
begin
   Entry.Text := '0';
   Complete := True;
   Total := 0;
   Operator := '+';
   end;

procedure TCalcForm.EntryChange(Sender: TObject);
begin
   If Entry.Text = '' then Complete := False;
   end;

procedure TCalcForm.EqualClick(Sender: TObject);
begin
   Calculate(ValFn(Entry.Text), '+');
   Entry.Text := StrFn(Total);
   Complete := True;
   Total := 0;
   end;

procedure TCalcForm.DecimalClick(Sender: TObject);
begin
   If Complete then Entry.Text := '';
   If Pos('.', Entry.Text) = 0 then
      Entry.Text := Entry.Text + '.';
   end;

end.