unit Libmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TLibraryBrowser = class(TForm)
    BookList: TListBox;
    AddButton: TButton;
    EditButton: TButton;
    DeleteButton: TButton;
    ExitButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure BookListClick(Sender: TObject);
    procedure EditButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  LibraryBrowser: TLibraryBrowser;

implementation

{$R *.DFM}

uses LibDE;

function DateToString(Date: Word): String;
begin
   Str(Date, Result);
   end;

function GenreToString(G: GenreSet): String;
var S: String;

   procedure Add(T: String);
   begin
      If S<>'(' then S := S + ', ';
      S := S + T;
      end;

begin
   S := '{';
   if gFiction    in G then Add('Fiction');
   if gTechnical  in G then Add('Technical');
   If gHumor      in G then Add('Humor');
   If gReference  in G then Add('Reference');
   if gHowTo      in G then Add('How-To');
   If gPhilosophy in G then Add('Philosophy');
   if gSuspense   in G then Add('Suspense');
   if gScience    in G then Add('Science');
   if gFantasy    in G then Add('Fantasy');
   if gHorror     in G then Add('Horror');
   if gWestern    in G then Add('Western');
   if gRomance    in G then Add('Romance');

   GenreToString := S + '}';
   end;

function ConditionToString(C: Conditions): String;
begin
   case C of
      cExcellent: Result := 'Excellent';
      cGood     : Result := 'Good';
      cFair     : Result := 'Fair';
      cPoor     : Result := 'Poor';
      end;
   end;

function FieldToString(LE: LibraryEntry; Field: BookFields): String;
begin
   Result := '';
   case Field of
      BookTitle       : Result := LE.BookTitle;
      BookAuthor      : Result := LE.BookAuthor;
      BookPublisher   : Result := LE.BookPublisher;
      BookDate        : If LE.BookDate<>0 then Result := DateToString(LE.BookDate);
      BookGenre       : If LE.BookLendee<>'' then Result := Le.BookLendee;
      BookCondition   : Result := ConditionToString(LE.BookCondition);
      end;
   end;

function BookToString(Book: LibraryEntry): String;
var I: BookFields;
    S: String;
begin
   Result := '';
   For I := BookTitle to BookCondition do
   begin
      S := FieldToString(Book, I);
      If (I <> BookCondition) and (S<>'') then S := S + '\';
      Result := Result + S;
      end;
   end;

procedure TLibraryBrowser.FormCreate(Sender: TObject);
var J: Longint;
begin
   AssignFile(Lib, 'LIBRARY.FIL');
   {$I-}
   Reset(LIB);
   {$I+}
   If IOResult<>0 then
   begin
      {$I-}
      Rewrite(Lib);
      If IOResult<>0 then {end program}
      {$I+}
      end;

   For J := 1 to FileSize(Lib) do
   begin
      Read(Lib, Book);
      BookList.Items.Add(BookToString(Book));
      end;
   end;

procedure TLibraryBrowser.AddButtonClick(Sender: TObject);
var Result: Integer;
begin
   Result := BookEntry.ShowModal;
   If Result = mrOk then
   begin
      Seek(Lib, FileSize(Lib));
      Write(Lib, Book);
      BookList.Items.Add(BookToString(Book));
      end;
   end;

procedure TLibraryBrowser.BookListClick(Sender: TObject);
begin
   If BookList.SelCount = 0 then
   begin
      DeleteButton.Enabled := false;
      EditButton.Enabled := false;
      end
   else begin
      DeleteButton.Enabled := true;
      EditButton.Enabled := true;
      end;
   end;

procedure TLibraryBrowser.EditButtonClick(Sender: TObject);
var Result: Integer;
    J     : Longint;
begin
   J := BookList.ItemIndex;
   Seek(Lib, J);
   Read(Lib, Book);
   {Put Book into BookEntry's controls}
   Result := BookEntry.ShowModal;
   If Result = mrOK then
   begin
      Seek(Lib, J);
      Write(Lib, Book);
      BookList.Items.Delete(J);
      BookList.Items.Insert(J, BookToString(Book));
      end;
   end;

procedure TLibraryBrowser.DeleteButtonClick(Sender: TObject);
var I, Offset: Longint;
begin
   Seek(Lib, 0);
   Offset := 0;
   I := 0;
   while(I<>BookList.Items.Count) do
   If BookList.Selected[I] then
   begin
      BookList.Items.Delete(I); {remove selected items from list}
      inc(Offset); {Don't write them out, but instead adjust}
      end          {where subsequent records will go}
   else if Offset > 0 then
   begin
      Inc(I);
      Seek(Lib, I);          {Get Record I}
      Read(Lib, Book);
      Seek(Lib, I-Offset);   {Adjust position}
      Write(Lib, Book);      {Write over old data}
      end
   else Inc(I);
   If Offset>0 then
   begin
      Seek(Lib, FileSize(Lib)-Offset);
      truncate(Lib)           {New size is old size less deleted.}
      end;
   DeleteButton.Enabled := false;
   EditButton.Enabled := False;
   end;


procedure TLibraryBrowser.ExitButtonClick(Sender: TObject);
begin
   Close;
   end;

end.
