//------------------------------------------------------------------
// Syntax.cpp - Definition of the Syntax and SyntaxList classes.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The Syntax class pairs syntactic patterns (REs) with
//          tokens (ints)
//
// Architect: AKJ
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#include <stdlib.h>
#include <parser\syntax.h>

SyntaxList::SyntaxList ( ): List ()
  {
    pFirst = pLast = pCurrent = 0;
  }
         
SyntaxList::~SyntaxList ( )
  {
    for (Syntax *eSyntax = Reset ();
         eSyntax;
         eSyntax = GetNext ()
        )
         delete eSyntax;            
  }

Syntax *SyntaxList::Seek (gpString &sName)
  {
    int lFound = 0;

    Reset ();
    while (!lFound && pCurrent)
      {
        if ( (*(pCurrent->reSyntax)) == sName)
            lFound = 1;
        else
            GetNext ();
      }
   
    return pCurrent;
  }

Syntax *SyntaxList::Seek (char *cName)
  {
    gpString sName (cName);
    return (Seek (sName));
  }

Syntax *SyntaxList::Reset ( ) 
  {
    return (pFirst = pCurrent = (Syntax *)List::Reset () );
  }

Syntax *SyntaxList::GetNext ( ) 
  {
    return (pCurrent = (Syntax *)List::GetNext () );
  }

Syntax *SyntaxList::AddItem (Syntax *eNew) 
  {
    pLast = pCurrent = (Syntax *)List::AddItem (eNew);
        
    if (!pFirst)
        pFirst = pLast;
        
    return (pCurrent);  
  }

Syntax *SyntaxList::Peek ( ) 
  {
    return pCurrent;
  } 

//------------------------------------------------------------------
// Syntax object starts here:

Syntax::Syntax ()
  {
    reSyntax = 0;
    nToken = 0;
  }

Syntax::Syntax (gpRegExp *reExpress, int nNewToken)
  {
    reSyntax = reExpress;
    nToken = nNewToken;
  }

Syntax::Syntax (char *cExpress, int nNewToken)
  {
    reSyntax = new gpRegExp(cExpress);
    nToken = nNewToken;
  }   
