//------------------------------------------------------------------
// ListBase.h - Declaration of the List base class.
//
// Copyright 1993, 1994 Prodis Incorporated.
//
// Architect: AKJ
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#ifndef __LISTBASE__
#define __LISTBASE__
class ListItem
  {
    public :
   
	    ListItem   *poNextObject;		//Next item in list

      ListItem   *poPrevObject;		//Previous item in list

	    void       *poObject;			//Any GPObject you put in a list
    
	    ListItem (void *elem);
      
      ~ListItem ();

	    void SetNext (ListItem *oItem);

      void SetPrevious (ListItem *oItem);

      ListItem *NextNode ( ) {return poNextObject;}

      ListItem *PrevNode ( ) {return poPrevObject;}
  };
  

class List
  {
    public :
      
	    ListItem *lFirst;
	    ListItem *lLast;
	    ListItem *lCurrent;			   //current item
      long nListSize;
      long ListSize ( ) {return nListSize;}
	    List ( );                        		  

      ~List ( );
      
      void *Reset ( );                 //Sets current position to top
                  
	    void *GetNext ( );               //increments the current position
                        
      void *GetPrevious ( );

	    void *AddItem (void *oGPObject); //adds an item

      void *Peek ( );                                            

      long GetListSize ( );

      ListItem *First ( ) {return lFirst;}

      ListItem *Last ( ) {return lLast;}

      void *DeleteCurrent ( );

      void *Insert (void *oNew);

      void *InsertAfter (void *oNew);

      void Clear ( );
  };

#endif



