//------------------------------------------------------------------
// gpRegExp.h - Declaration of the gpRegExp class.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The General Purpose Regular Expression class handles
//          pattern matching duties.
//
// Architect: TDE
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#ifndef GPREGEXP_H
#define GPREGEXP_H

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <gpstring\gpString.h>
#include <gpstring\gpslist.h>

typedef enum { Literal, MultiChar0, MultiChar1, Wild, MultiWild0, 
               MultiWild1, Range, MultiRange0, MultiRange1, 
               Optional} ExpType_t;

class gpRegExp;

class RegExpList : public List
  {
    public :

      gpRegExp *pCurrent;

      gpRegExp *pFirst;

      gpRegExp *pLast;

      RegExpList ( );

      ~RegExpList ( );

      gpRegExp *Reset ( );

      gpRegExp *GetNext ( );

      gpRegExp *AddItem (gpRegExp *pNew);

      gpRegExp *Peek ( );

      gpRegExp *Seek (gpString &sName);
      
      gpRegExp *Seek (char *sName);
      
      void Clear ( );
      
      gpRegExp &operator[] (int nSequence);
      
      gpRegExp *Seek (int nSequence);
  };          

class gpRegExp : public gpString
  {
    protected :

      gpRegExp *NextAtom;

      int fTopLevel;
      
      ExpType_t ExpType;
      
      int firstOnly;

      int lastOnly;
      
      int match_remainder (gpString &sExpress);

      int DecrementingMatch(int nMin, int nPos, gpString &sExpress);

      gpString sLastMatch;

      int nDoICount;

      RegExpList lrChildren;
        
      gpString &LastMatch () {return sLastMatch;}

      void ParseAtoms ( );

    public :

      // Constructors:
      gpRegExp (const char *cStr, int top = 1);
      gpRegExp (char cChar, int top = 1);
      gpRegExp (int toplevel = 1);
      gpRegExp (const gpString &sStr, int top = 1);

      // Destructor:
      ~gpRegExp ( );

      // Rebuild this RE on a new string.
	    gpRegExp &operator= (gpString &oString);
	    gpRegExp &operator= (char *cString);

      // Check for an RE match.
	    int operator== (gpString &oString);

      // Create a list of found parameters (&)      
      void DumpParameters (StringList &lsParms);
  };

#endif
