// test associative arrays

#include <iostream.h>

#include "assoc.hpp"

static int f2(int x) { return 2 * x; }
static int f3(int x) { return 3 * x; }
static int f4(int x) { return 4 * x; }

void main(void)
    {
    const char *p;

    // test ASSOCIATION
    ASSOCIATION<int> test(2);

    cout << "Testing direct ASSOCIATION with <int>\n";
    if (!test)
        cout << "Could not create array\n";
    else
        {
        test.insert("voodoo",22);
        test.insert("wanda",23);
        test.insert("xray",24);
        test.insert("yodel",25);
        test.insert("zorro",26);
        test.remove("voodoo");
        cout << "Size of array is " << test.size() << "\n";
        if (test.find("zonk") != 0)
            cout << "ERROR: test[zonk] shouldn't exist " << "\n";
        cout << "test[zorro] is " << *test.find("zorro") << "\n";
        cout << "Keys\t\tData\n";
        if ((p = test.first()) != 0)
            {
            do
                {
                cout << p << "\t\t" << *test.find(p) << "\n";
                } while ((p = test.next()) != 0);
            }
        }


    // test ASSOCIATION
    ASSOCIATION<float *> test2(4);

    cout << "\nTesting indirect ASSOCIATION with <float *>\n";
    if (!test2)
        cout << "Could not create array\n";
    else
        {
        float a,b,c,d,e;

        a = 1.0;
        b = 2.0;
        c = 3.0;
        d = 4.0;
        e = 5.0;
        test2.insert("alpha",&a);
        test2.insert("epsilon",&e);
        test2.insert("beta",&b);
        test2.remove("epsilon");
        test2.insert("gamma",&c);
        test2.insert("delta",&d);
        test2.insert("epsilon",&e);
        test2.remove("epsilon");
        cout << "Size of array is " << test2.size() << "\n";
        if (test2.find("zonk") != 0)
            cout << "ERROR: test2[zonk] shouldn't exist " << "\n";
        cout << "test2[gamma] is " << **test2.find("gamma") << "\n";
        cout << "Keys\t\tData\n";
        if ((p = test2.first()) != 0)
            {
            do
                {
                cout << p << "\t\t" << **test2.find(p) << "\n";
                } while ((p = test2.next()) != 0);
            }
        }

    // test ASSOCIATION with function pointers
    ASSOCIATION<int (*)(int)> multiplier(4);

    cout << "\nTesting ASSOCIATION with function pointers\n";
    if (!multiplier)
        cout << "Could not create array\n";
    else
        {
        multiplier.insert("two times",f2);
        multiplier.insert("three times",f3);
        multiplier.insert("four times",f4);
        cout << "Three times Five is " << (**multiplier.find("three times"))(5) << "\n\n";
        }

    // test copy constructor
    ASSOCIATION<int> copy(test);
    if (copy.find("zorro") == 0)
        cout << "Copy constructor fails\n";

    // test assigment
    ASSOCIATION<int> assign;
    assign = test;
    if (assign.find("zorro") == 0)
        cout << "Object assignment fails\n";

    // test static initialization
    static const char *keys[] = { "A","B","C" };
    static char *data[] = { "one","two","three" };
    ASSOCIATION<char *> static_list(keys,data,sizeof(keys)/sizeof(keys[0]));
    if (*static_list.find("A") != data[0])
        cout << "Static initialization fails\n";

    // test ASSOC_STORED
    ASSOC_STORED<int> stored(26);
    char letter[] = "A";
    for (int i = 1 ; i <= 26 ; i++, letter[0]++)
        stored.insert(letter,i);
    stored.remove("C");
    if (stored.size() != 25 || *stored.find("W") != 23)
        cout << "Stored association fails (insert/remove)\n";
    if ((p = stored.first()) != 0)
        {
        cout << "Stored keys\n";
        do
            {
            cout << p << " ";
            } while ((p = stored.next()) != 0);
        cout << '\n';
        }
    else
        cout << "Stored association fails (iterating)\n";
    ASSOC_STORED<int> stored_copy(stored);
    ASSOC_STORED<int> stored_assigned;
    stored_assigned = stored;
    if (stored.first()==stored_copy.first() ||
        stored.first()==stored_assigned.first() ||
        stored_copy.first()==stored_assigned.first())
        cout << "Stored association fails (copy constructor)\n";
    if (*stored.find("G")!=7 || *stored_copy.find("G")!=7 || *stored_assigned.find("G")!=7)
        cout << "Stored association fails (assignment\n";

    // test [] and () operator semantics
    cout << "\nTesting operator semantics\n";
    cout << "The existence of static_list(\"A\") is " << static_list("A") << "\n";
    cout << "The existence of static_list(\"Z\") is " << static_list("Z") << "\n";
    cout << "The rvalue of static_list[\"A\"] is \"" << static_list["A"] << "\"\n";
    cout << "The rvalue of static_list[\"Z\"] is \"" << static_list["Z"] << "\"\n";
    cout << "NOW the existence of static_list(\"Z\") is " << static_list("Z") << "\n";
    static_list["G"] = "seven";
    cout << "static_list[\"G\"] was used as an lvalue and is now \"" << static_list["G"] << "\"\n";
    }
