//------------------------------------------------------------------
// ListBase.cpp - Definition of the List base class.
//
// Copyright 1993, 1994 Prodis Incorporated.
//
// Architect: AKJ
// Developer: AKJ
//
// Description:
//   This provides a base class for GrowthPath List Objects. It defines
//   those features which exist in all Growth-Path Lists.
//
// Modification History:
//------------------------------------------------------------------

#include <listbase\listbase.h>

ListItem::ListItem (void *elem)
  {
	  poNextObject = 0;
	  poPrevObject = 0;
    poObject = elem;
  }

ListItem::~ListItem ( )
  {
  }
    
void ListItem::SetNext (ListItem *oItem) 
  {
    poNextObject = oItem;
  }

void ListItem::SetPrevious (ListItem *oItem ) 
  {
    poPrevObject = oItem;
  }

List::List ( )
  {
	  lCurrent = 0;
	  lFirst = 0;
	  lLast = 0;
    nListSize = 0;
  }

//-----------------------------------------------------------------------
//
//  List Class Destructor
//
//  Logic :
//    Go through the list.  Delete each node, after saving its reference
//    to the next node.
//
//-----------------------------------------------------------------------
List::~List ( )
  {
    ListItem *currentItem;
    ListItem *nextItem;
    
    Reset ();
    for (currentItem = lCurrent; currentItem; currentItem = nextItem)
      {
        nextItem = currentItem->poNextObject;
        delete currentItem;
      }  
  }  
  
void *List::Reset ( )
  {
    void *tReturn = 0;

    lCurrent = lFirst;
    if (lCurrent)
        tReturn = lCurrent->poObject;

    return tReturn;
  }
    
void *List::GetNext( )
  {
    void *rVal = 0;
    
    if (lCurrent)
		    lCurrent = lCurrent->poNextObject;
    else 
        Reset ();
        
    if (lCurrent)
        rVal = lCurrent->poObject;

	  return (rVal);
  }

void *List::GetPrevious ( )
  {
    void *rVal = 0;

    if (lCurrent)
        lCurrent = lCurrent->poPrevObject;
    else
        lCurrent = Last ();

    if (lCurrent)
        rVal = lCurrent->poObject;

    return rVal;
  }

void *List::AddItem (void *oNew)
  {
	  ListItem *oNewItem  = new ListItem(oNew);
    
	  nListSize++;
        
	  if (lFirst)
	    {                 
        lLast->SetNext (oNewItem);
        oNewItem->SetPrevious (lLast);
        lLast = oNewItem;
	    }  									                
	  else
        lFirst = lLast = oNewItem;
        
    lCurrent = oNewItem;       
	  return (oNewItem->poObject);
  }

void  *List::Peek ( )                  
  {
    void *rVal = 0;
    
    if (lCurrent)
      rVal = lCurrent->poObject;

    return rVal;
  } 

long List::GetListSize ( )
  {
    return nListSize;
  }

void *List::DeleteCurrent ( )
  {
    ListItem *lOld;
    if (lCurrent)
      {
        nListSize--;
        lOld = lCurrent;
        
        if (lCurrent == lFirst)
          {
            if (lFirst = lCurrent->NextNode () )
                lCurrent->NextNode ()->SetPrevious (0);
            lCurrent = lFirst;
          }  
        else if (lCurrent == lLast)
          {
            if (lLast = lCurrent->PrevNode () )
                lCurrent->PrevNode ()->SetNext (0);
            lCurrent = lLast;
          }
        else
          {
            lCurrent->NextNode ()->SetPrevious (lCurrent->PrevNode () );
            lCurrent->PrevNode ()->SetNext (lCurrent->NextNode () );
            lCurrent = lCurrent->NextNode ();
          }
        delete lOld;          
      }
    return lCurrent->poObject;          
  }

void *List::Insert (void *oNew)
  {
	  ListItem *oNewItem = new ListItem (oNew);
    nListSize++;

    if (lCurrent == lFirst)
      {
        oNewItem->SetNext (lFirst);
        lFirst->SetPrevious (oNewItem);
        lFirst = lCurrent = oNewItem;
        if (nListSize == 1)
            lLast = lCurrent;
      }
    else
      {
        oNewItem->SetNext (lCurrent);
        oNewItem->SetPrevious (lCurrent->PrevNode () );
        lCurrent->PrevNode ()->SetNext (oNewItem);
        lCurrent->SetPrevious (oNewItem);
        lCurrent = oNewItem;
      }
          
    return (lCurrent->poObject);
  }

void *List::InsertAfter (void *oNew)
  {
	  ListItem *oNewItem = new ListItem (oNew);
    nListSize++;

    if (lCurrent == lLast)
      {
        oNewItem->SetPrevious (lLast);
        lLast->SetNext (oNewItem);
        lLast = lCurrent = oNewItem;
        if (nListSize == 1)
            lFirst = lCurrent;
      }
    else
      {
        oNewItem->SetPrevious (lCurrent);
        oNewItem->SetNext (lCurrent->NextNode () );
        lCurrent->NextNode ()->SetPrevious (oNewItem);
        lCurrent->SetNext (oNewItem);
        lCurrent = oNewItem;
      }
          
    return (lCurrent->poObject);
  }   

void List::Clear ( )
  {
    ListItem *currentItem;
    ListItem *nextItem;
    
    Reset ();
    for (currentItem = lCurrent; currentItem; currentItem = nextItem)
      {
        nextItem = currentItem->poNextObject;
        delete currentItem;
      }  
	  lCurrent = 0;
	  lFirst = 0;
	  lLast = 0;
    nListSize = 0;
  }  
