//------------------------------------------------------------------
// gpString.cpp - Definition of gpString class.
//
// Copyright 1994 Prodis Incorporated.
//
// Architect: TDE
// Developer: AKJ
// 
// Modification History:
//    12/04/94 AKJ: Minor repairs to ::Strip(), and added "All"
//
//------------------------------------------------------------------

#include <gpstring\gpstring.h>

//------------------------------------------------------------------
// Constructors:

gpString::gpString (const char *cNewText)
  {
    for (nSize = strlen(cNewText) + 1; (nSize % 16); nSize++);
    cText = new char [nSize];
    strcpy (cText, cNewText);
  }

gpString::gpString (size_t nNewSize, char cFill)
  {
    nSize = nNewSize;
    cText = new char[Size()];
    for (size_t i = 0; i < (Size()-1); i++)
        cText[i] = cFill;
    cText[Size()-1] = 0;
  }
  
gpString::gpString (char cChar)
  {
    nSize = 16;
    cText = new char [Size()];
    cText[0] = cChar;
    cText[1] = '\0';
  }
    
gpString::gpString ()
  {
    nSize = 16;
    cText = new char[Size()];
    strcpy (cText, "");
  }

gpString::gpString (gpString &s)
  {
    nSize = s.Size();
    cText = new char[Size()];
    strcpy (cText, s);
  }

//------------------------------------------------------------------
// Destructor:

gpString::~gpString ( )
  {
    if (cText)
        delete cText;
  }

//------------------------------------------------------------------
// Size-related functions:
void gpString::Resize (size_t nNew)
  {
    if (nNew > Length())
      {
        if (nNew >= Size() )
          {
            for (nSize = nNew+1; (nSize % 16); nSize++);
            char *cTemp = new char[Size()];
            strcpy (cTemp, cText);
            delete cText;
            cText = cTemp;
          }
        for (int i = Length(); i < nNew; i++) cText[i] = ' ';
      }
        
    cText [nNew] = 0;
  }         

//------------------------------------------------------------------
// Case Conversion - returns a copy.

// Convert the text to all Lowercase letters.
gpString gpString::ToLower ( )
  {
    gpString sTemp(*this);
    
    for (size_t i = 0; i <= Length(); i++)
      {
        if ( isupper (cText[i])  )
            sTemp[i] += 32; 
      }
      
    return sTemp;  
  }

// Convert the text to all Uppercase letters.
gpString gpString::ToUpper ( )
  {
    gpString sTemp(*this);
    
    for (size_t i = 0; i <= Length(); i++)
      {
        if ( islower (cText[i])  )
            sTemp[i] -= 32; 
      }

    return sTemp;  
  }

//------------------------------------------------------------------
// Assignment Operators:

gpString::operator char *( )
  {
    return cText;
  }

gpString &gpString::operator= (gpString &oString)
  {

    if (oString.Length() >= Size() )
      {
        delete cText;
                    
        //get new size
        for (nSize = oString.Length () + 1; (nSize % 16); nSize++);
        
        cText = new char[Size()];
      }

    strcpy (cText, oString);
    
    return *this;
  }
        
gpString &gpString::operator+= (gpString &oString)
  {
    nSize += oString.nSize;              
    char *cTemp = new char[nSize];       
    strcpy (cTemp, cText);               
    strcat (cTemp, oString);

    delete cText;                        
    cText = cTemp;                       

    return *this;                        
  }  
       
gpString gpString::operator+ (gpString &oString)
         
  // Append the parameter's content to mine and return the result
  {
    gpString sTemp (oString.Size() + nSize);
    
    strcpy (sTemp, cText);
    strcat (sTemp, oString);

    return sTemp;        
  }

//------------------------------------------------------------------
// Relational operators:

int gpString::operator== (gpString &oString)

// Compare, for equality, the Text-Object with that of the
// String passed in the parameter list.

  {
    if (Length () )
        return !strcmp (*this, oString);
    else
        return (0);    
  }

int gpString::operator!= (gpString &oString)

// Compare, for equality, the Text-Object with that of the
// String passed in the parameter list.

  {
    if (Length () )
        return strcmp (*this, oString);
    else
        return (0);    
  }

int gpString::operator< (gpString &oString)

// Compare the Text-Object with that of the String passed
// in the parameter list to see if the former is greater
// than the latter (follows it in alphanumeric order).
  
  {
    return (stricmp (*this, oString) < 0);
  }

int gpString::operator> (gpString &oString)

// Compare the Text-Object with that of the String passed
// in the parameter list to see if the former is lesser
// than the latter (precedes it in alphanumeric order).

  {
    return (strcmp (*this, oString) > 0);
  }

int gpString::operator<= (gpString &oString)

// Compare the Text-Object with that of the String passed
// in the parameter list to see if the former is greater
// than the latter (follows it in alphanumeric order).
  
  {
    return (strcmp (*this, oString) <= 0);
  }

int gpString::operator>= (gpString &oString)

// Compare the Text-Object with that of the String passed
// in the parameter list to see if the former is lesser
// than the latter (precedes it in alphanumeric order).

  {
    return (strcmp (*this, oString) >= 0);
  }

//------------------------------------------------------------------
// Search Functions:

size_t gpString::FindSubstring (gpString &sTarget
                , Direction dDirect, size_t nPos)
  {
    long nPlace = nPos;
    int lFound = 0; 
    
    if (dDirect == Forward)
      {
        while (((nPlace + sTarget.Length()) <= Length()) && !lFound)
          {
            if (!strncmp (sTarget, cText+nPlace, sTarget.Length()))
                lFound = 1;
            else
                nPlace++;
          }
      }
      
    if (dDirect == Backward)
      {
        if ((nPlace + sTarget.Length()) > Length())
            nPlace = Length() - sTarget.Length();
            
        while ( (nPlace >= 0) && !lFound)
          {
            if (!strncmp (sTarget, cText+nPlace, sTarget.Length()))
                lFound = 1;
            else
                nPlace--;
          }
      }
      
    if (!lFound)
        return NPOS;
        
    size_t nReturn = nPlace;
        
    return nReturn;        
  }

size_t gpString::FindChar (Inclusive iIsOf, gpString &sTarget
            , Direction dDirect, size_t nPos)
  {
    long nPlace = nPos;
    int lFound = 0;
    int lMatch ;
    char *cBuffer = new char[sTarget.Length() + 1];
    strcpy (cBuffer, sTarget);

    if (nPlace > Length())
        return (NPOS);
        
    if (dDirect == Forward)
      {    
        while ((nPlace < Length () ) && !lFound)
          {
            lMatch = CharIsOfString(*(cText+nPlace), cBuffer);
            
            lFound = (iIsOf == Of) ? lMatch : !lMatch;
                
            if (!lFound)
                nPlace++;    
          }
      }
      
    else if (dDirect == Backward) 
      {    
        while ((nPlace >= 0) && !lFound)
          {
            lMatch = CharIsOfString(*(cText+nPlace), cBuffer);

            lFound = (iIsOf == Of) ? lMatch : !lMatch;
            
            if (!lFound)
                nPlace--;    
          }
      }
      
    if (!lFound)
        return NPOS;
        
    size_t nReturn = nPlace;
        
    return nReturn;        
  }

int gpString::CharIsOfString(char cChar, char *cBuffer)
  {
    int lFound = 0;
    
    for (int i = 0; (i < strlen (cBuffer) ) && !lFound; i++)
        if (toupper (cChar) == toupper (cBuffer[i]) )
                lFound = 1;
       
    return lFound;  
  }

//------------------------------------------------------------------
// Edit Routines:

gpString &gpString::Insert (gpString &sNew, size_t nPos)
  {
    size_t i, j;
    
    size_t nMinSize = Length () + sNew.Length () + 1;
    char *cTemp = new char[nMinSize];
    
    if (nPos)
        strncpy (cTemp, cText, nPos);
        
    cTemp[nPos] = '\0';
            
    strcat (cTemp, sNew);
    for ( i = nPos + sNew.Length(), j = nPos; 
          (i < nMinSize) && (j < Length()); 
          i++, j++
        )
          cTemp[i] = cText[j];
          
    cTemp[nMinSize - 1] = '\0';    
        
//Ensure that this gpString is big enough
    if (Size () < nMinSize)
      {
        delete cText;
        for (; (nMinSize % 16); nMinSize++);
        cText = new char[nMinSize];
      }
      
    strcpy (cText, cTemp);
     
    delete cTemp;
        
    return *this;  
  }
  
gpString &gpString::Remove (size_t nPos, size_t nS)
  {
    if (nPos > Length())
        return (*this);
        
    size_t nPtr = nPos + nS;
    if (nPtr < Length () )
      {
        while (nPtr < Length () )
          {
            cText[nPos] = cText [nPtr];
            nPos++;
            nPtr++;
          }
        cText [nPos] = '\0';  
      }
    else
        cText[nPos] = 0;  
        
    return *this;          
  }

gpString &gpString::Replace(size_t nPos, size_t nSize, gpString &sNew)
  {
    Remove (nPos, nSize);
    Insert (sNew, nPos);
    return *this;
  }
    
gpString &gpString::Strip (StripType s, gpString &sTarget)
  {
    size_t nPlace;
    
    if (s != Trailing)
      {
        if ( (nPlace = FindChar(NotOf, sTarget) ) != NPOS)
            for (size_t i = nPlace; i <= Length (); i++)   
                cText[i - nPlace] = cText[i];
        else
            *cText = 0;
      }
      
    if (s != Leading)
      {
        if ((nPlace = FindChar(NotOf, sTarget, Backward, Length()-1)) 
            != NPOS)
            cText[nPlace + 1] = '\0';
        else
            cText[0] = '\0';
      }  

    if (s == All)
      {
        while ( (nPlace = FindChar(Of, sTarget)) != NPOS)
            Remove(nPlace, 1);
      }
      
    return *this;
  }

