// BasicMac.h - define tokens for the BASIC-Macro language.

// We need only include the FLOW.H file; it includes everything 
// else we need.
#include <parser\flow.h>

// Function prototypes:
int EvaluateExpression (gpString &sExpress);
gpFlowControl *BuildMacroEngine();
gpParser *BuildExpEngine( );

// These functions are prototyped, but not actually coded.
// These are just for demonstration purposes, and would need
// to be written in a productions system.

int GetMacroLine (gpString &sLine);
int RewindMacroSource (int nLine);
void ErrorHandler();
void SetVariableToValue (gpString &p1, gpString &p2);
void DoMenuItem (gpString &p1, gpString &p2, gpString &p3);
void MessageBox (gpString &p1, gpString &p2, gpString &p3);
void CallFunctionWithParms (gpString &p1, gpString &p2);
int CheckEquals (gpString &p1, gpString &p2);
int CheckGreater (gpString &p1, gpString &p2);
int CheckLessThan (gpString &p1, gpString &p2);

// Define our Tokens:
// We base each token on TK_USERDEF to avoid conflicts with
// predefined tokens.

#define TK_DOMENUITEM     (TK_USERDEF + 1)
#define TK_ASSIGN         (TK_USERDEF + 2)
#define TK_MBOX           (TK_USERDEF + 3)
#define TK_CALL           (TK_USERDEF + 4)
