/* This program is designed to modify file attributes, for all files and
     directories in an entire directory tree, to normal (No read-only, hidden,
     system or archive attributes.

   The specific purpose is to normalify directories, as nothing seems to be
   able to easily do that (inncluding DOS's ATTRIB.  Sure it works when you
   specifically specify the directory name, but it doesn't affect directories
   when you specify wildcards.
*/


#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>

void process_dir(char *p);
void display_attributes(char *file);

void syntax(void)
{
  printf("\n\
   NORMIFY clears all attributes from files and directories.\n\
It is identical to ATTRIB *.* -R -H -S -A /S except directories are also\n\
affected.\n\n\
  Syntax: NORMIFY [DIRECTORY PATH | /? ]\n\n\
    DIRECTORY PATH specifies the path to start processing at.\n\
        Sub-directories are also scanned. (Not an option)\n\
    /? brings up this help screen.\n\n\
  Written on August 11, 1995.  Released into the public domain.\n");
}

int main (int argc, char *argv[])
{
  int rv=1;
  char scan_dir[MAXPATH]="\0";

  printf("\nNormalize file/directory attributes. V0.0 Written by Brian Buchanan.\n");

  if (argc==2)
  {
    if (!strcmp(argv[1],"/?"))
      syntax();
    else
      strcpy(scan_dir, argv[1]);
  }
  else
    syntax();

  if (*scan_dir)
  {
    rv=0;
    strupr(scan_dir);
    printf("\nProcessing %s\n", scan_dir);
    process_dir(scan_dir);
  }

  return(rv);
}

void process_dir(char *p)
{
  struct ffblk ffblk;
  int done;

  char par_dir[MAXPATH], sp[MAXPATH], down[MAXPATH];

  strcpy(par_dir,p);

  if ( (strlen(p)>0) && (p[strlen(p)]!='\\') && (p[strlen(p)]!=':') )
    strcat(par_dir,"\\");

  strcpy(sp,par_dir);
  strcat(sp,"*.*");

  done = findfirst(sp,&ffblk,FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH);
  while (!done)
  {
    if (strcmp(ffblk.ff_name,".")&&strcmp(ffblk.ff_name,"..") )
    {
      strcpy(down,par_dir);
      strcat(down,ffblk.ff_name);


      printf(" ");
      // Display the current attributes.
      display_attributes(down);

      // Clear all attributes.
      if (_dos_setfileattr(down, 0) != 0)
        printf("==");
      else
        printf("  ");

      // display the (hopefully) modified attributes.
      display_attributes(down);

      // Print out the current file's info.
      printf(" %s\n", down);

      if (ffblk.ff_attrib&FA_DIREC)
        process_dir(down);

    }

    done = findnext(&ffblk);
  }
}


void display_attributes(char *file)
{

  char attribute_mask[7];
  unsigned attribute_value;

  strcpy(attribute_mask,"------");

  if (_dos_getfileattr(file,&attribute_value) != 0)
    strcpy(attribute_mask,"??????");
  else
  {
    if (attribute_value & _A_ARCH)
      attribute_mask[0]='A';
    if (attribute_value & _A_RDONLY)
      attribute_mask[1]='R';
    if (attribute_value & _A_HIDDEN)
      attribute_mask[2]='H';
    if (attribute_value & _A_SYSTEM)
      attribute_mask[3]='S';
    if (attribute_value & _A_VOLID)
      attribute_mask[4]='V';
    if (attribute_value & _A_SUBDIR)
      attribute_mask[5]='D';
  }

  printf("[%s]",attribute_mask);
}
