*:*****************************************************************************
*:
*: Procedure file: D:\CODE\EH_DOC\NEW\EH_SNAP.PRG
*:
*:         System: Uncle AL's Expert Help tool for Snap 1.4
*:         Author: Alan Gibbons
*:      Copyright (c) 1993, Alan Gibbons
*:  Last modified: 05/17/95     21:01
*:
*:  Procs & Fncts: MAIN()
*:               : DISPREC()
*:               : CHECKDIR()
*:
*:          Calls: MAIN()             (function  in EH_SNAP.PRG)
*:
*:      Documented 05/17/95 at 21:11                SNAP!  version 5.02
*:*****************************************************************************
#include "inkey.ch"
#include "directry.ch"
** 09/17/93 v1.1 :added validate source & destination inputs
**               :Fixed error output file name for menu build
** 09/30/93 v1.2 :Changed message about xref & 64k. modified read
**               :formula for name, author, and copyright
**               :Added checking for datadict.sds
** 09/27/94 v1.3 :Added command line mvar for 87 flag eh_snap 87
**               :to deal with file names instead of function names
** 05/17/95 v1.4 :Added ability to self split <64k files
** 05/20/95 v1.5 :changed overlay to swpruncmd(blinker 3.1) to vacilitate
**               :linking in PS_ERROR instead of err501.
**               : also reduced memory requirements.
*!*****************************************************************************
*!
*!       Function: MAIN()
*!
*!      Called by: EH_SNAP.PRG                       
*!
*!          Calls: CHECKDIR()         (function  in EH_SNAP.PRG)
*!               : O_DIREXIST()       (function  in ?)
*!               : O_MD()             (function  in ?)
*!               : DISPREC()          (function  in EH_SNAP.PRG)
*!               : OVERLAY()          (function  in ?)
*!               : O_ERRLEVEL()       (function  in ?)
*!
*!           Uses: TMPFILE.DBF        
*!
*!   Memory Files: EH_SNAP.MEM
*!
*!*****************************************************************************
FUNCTION MAIN(mvar)
//screen mvars
LOCAL laPrgDir := {}                  //hold ACT list
LOCAL laDocDir := {}                  //hold DOC list
LOCAL latemp := {}
LOCAL lnHandle,lncount,lncurrent,lndocs := 0
//dbfmvars
LOCAL lctitle, lcAuthor, lcCopyright  //gleaned from snap
LOCAL lnfirstrec,lcAllcross           //place marker,all xref mvars
LOCAL lcFunct,lcline,laerror := {}
LOCAL nHandle1,nHandle2
LOCAL lc_act,n_count
LOCAL X,Y,Z
LOCAL crlf := CHR(13)+CHR(10)         //charage return and line feed

REQUEST PS_ERROR  // forces in ps error

MEMVAR pcSourceDir,pcDestinDir,pcMenuList,pcPrgName,;
   plMenuMake,pcMenuErr, getlist
PUBLIC pcSourceDir,pcDestinDir,pcMenuList,pcPrgName,;
   plMenuMake,pcMenuErr

SET SCOREBOARD OFF                    //get rid of that black box
SETCANCEL(.F.)                        //yell at CA for defaulting this to .t.
IF VALTYPE(mvar) <> "C"
   mvar := ""
ENDIF

IF !FILE("EH_SNAP.MEM")               // check for mem file
   pcPrgName   := SPACE(8)
   pcSourceDir := ""
   pcDestinDir := ""
   plMenuMake  := .T.
   SAVE TO EH_Snap.mem
ELSE
   RESTORE FROM EH_SNAP ADDITIVE     // if there read it
ENDIF

pcPrgName   := pcPrgName + SPACE(8-LEN(pcPrgName))  //pad for edit
pcSourceDir := pcSourceDir + SPACE(255)
pcDestinDir := pcDestinDir + SPACE(255)

SETCOLOR("W +/+b ,n /w ,w ,,b +/+w")            //draw screen
FOR X := 0 TO MAXROW()
   @ X,0 SAY REPLICATE("",(MAXCOL()/4)+(MAXCOL()%4))
NEXT

CENTER(0,80," Uncle Al's Lunch Time Products ")
CENTER(24,80," copyright 1993  all rights reserved Eh_Snap v 1.5")
BOXSHADOW(2,2,4,18)
BOXSHADOW(2,23,15,74)
BOXSHADOW(18,3,23,72)
BOXSHADOW(16,59,18,70)

@ 02,4 SAY " File "
@ 02,25 SAY " Status "
@ 04,28 SAY "Give it a Name:"
@ 05,29 SAY ".ACT file Dir:"
@ 06,27 SAY "Destination Dir:"
@ 07,27 SAY "Update the Menu file    Yes unless customized."
@ 08,25 SAY "One  -Snap the code with Snap.exe w/Datadict."
@ 09,25 SAY "Two  -Expert Help Compiler & Linker must be in"
@ 10,25 SAY "      the Path or this directory."
@ 11,25 SAY "Three-For Summer 87 command line: eh_snap 87"
@ 12,25 SAY "Notes:This splits up .ACT files larger than 64k."
@ 13,25 SAY "      Error files are created by Expert Help."
@ 14,25 say "      ESC will eventually ask to quit to DOS."

@ 18,05 SAY " Messages "

@ 04,43 GET pcPrgName   PICTURE "XXXXXXXX" VALID (IF(EMPTY(pcPrgName),;
   (MKEY("Must have a final <name>.NG name")==3000),.T.))
@ 05,43 GET pcSourceDir PICTURE "@S20" VALID checkdir(@pcSourceDir)
@ 06,43 GET pcDestinDir PICTURE "@S20" VALID checkdir(@pcDestinDir)
@ 07,48 GET plMenuMake  PICTURE "Y"
READ
IF LASTKEY() == K_ESC
   RETURN NIL
ENDIF
pcSourceDir := UPPER(ALLTRIM(pcSourceDir))      //trim and save
pcDestinDir := UPPER(ALLTRIM(pcDestinDir))
pcPrgName   := UPPER(ALLTRIM(pcPrgName))
SAVE TO eh_snap


IF !EMPTY(pcSourceDir) .AND. pcSourceDir == pcDestinDir .AND.;
      ALERT("That is not a good Idea ; to have source and destination ; the same");
      <> 2
   RETURN NIL
ENDIF

DO WHILE len(DIRECTORY(SUBSTR(pcDestinDir,1,LEN(pcDestinDir)-1),"D")) == 0
   IF ALERT("Directory "+pcDestinDir+" does not exist.. Make One",{"Make it","Abort"}) == 1
      SWPRUNCMD("MD "+SUBSTR(pcDestinDir,1,LEN(pcDestinDir)-1))
   ELSE
      return NIL
   ENDIF
ENDDO

IF .NOT. FILE(pcDestinDir+"eh_snap.dbf")     //make a dbf if needed
   @ 19,05 SAY SPACE(60)
   @ 19,10 SAY "Creating eh_snap.dbf"
   CREATE tmpfile
   USE tmpfile
   APPEND BLANK
   REPLACE field_name WITH "LINE", field_type WITH "C", ;
      field_len WITH 80, field_dec WITH 1     //eh can not see more anyway
   USE
   CREATE (pcDestinDir+"EH_SNAP") FROM tmpfile
   @ 19,05 SAY SPACE(60)
   @ 19,10 SAY "File eh_snap.dbf Created ..."
   ERASE tmpfile.dbf
   COMMIT
ENDIF
USE (pcDestinDir+"eh_snap") EXCLUSIVE ALIAS SNAP
// check for source files

IF !FILE(pcSourceDir+"*.ACT") .AND. ALERT("No .ACT files at "+pcSourceDir) <> 2
   RETURN NIL
ENDIF

// build list of files
laPrgDir := DIRECTORY(pcSourceDir+"*.ACT")
FOR X:= 1 TO LEN(laPrgDir)
   IF laPrgDir[X][2] > 64000
      @ 03,05 SAY SPACE(12)
      @ 03,05 SAY laPrgDir[X][1]
      @ 19,05 SAY "Splitting large.ACT files to                "
      IF LASTKEY() == K_ESC
         QUIT
      ENDIF
      //  split it
      nhandle1 := FOPEN(pcSourceDir+laPrgDir[x][1]) //read it
      lc_act := SUBSTR(laPrgDir[x][1],1,AT(".ACT",laPrgDir[x][1])-1)
      lc_act := ALLTRIM(SUBSTR(lc_act,1,7))
      
      @ 17,60 SAY SPACE(9)
      n_count = 65       // A
      FOR y := 1 TO INT(laPrgDir[X][2]/60000)+1 //how many we need for 60k
         DO WHILE FILE(pcSourceDir+lc_act+CHR(n_count)+".ACT") //check file name
            IF ++n_count > 90    //Z
               ALERT("Unable to split file "+laPrgDir[x][1]) //ran out of names
               FCLOSE(nHandle1)
               return ""
            ENDIF
         ENDDO
         nHandle2 := Fcreate(pcSourceDir+lc_act+CHR(n_count++)+".ACT")
         @ 20,05 SAY pcSourceDir+lc_act+CHR(n_count)+SPACE(10)
         FOR z := 1 TO 60
            @ 17,60 SAY z picture "9,999,999"
            Fwrite(nHandle2,FREADSTR(nHandle1,1000)) //this does not eat memory
         NEXT
         FCLOSE(nHandle2)
      NEXT
      
      FCLOSE(nHandle1)
      FERASE(pcSourceDir+laPrgDir[x][1])
   ENDIF
NEXT

laPrgDir := DIRECTORY(pcSourceDir+"*.ACT")
asort(laPrgDir,,, { |x,y| x[1] < y[1] })

lcAllCross := ""
@ 19,05 SAY "Reading .ACT files                   "
@ 20,05 SAY "Files Found       Current       file "
@ 17,60 say space(9)

lncount := LEN(laPrgDir)
lncurrent := 0
IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
   RETURN NIL
ENDIF

ZAP
FOR X := 1 TO LEN(laPrgDir)            // do ACT files
   lncurrent++
   
   APPEND BLANK
   lnfirstrec := RECNO()
   REPLACE Line WITH "!short:"
   APPEND FROM (pcSourceDir+laPrgDir[X][1]) SDF
   
   @ 03,05 SAY SPACE(12)
   @ 03,05 SAY laPrgDir[X][1]
   @ 20,17 SAY STR(lncount,5)
   @ 20,31 SAY STR(lncurrent,5)
   IF X == 1
      GOTO 6
      lctitle := ALLTRIM(SUBSTR(snap->line,Rat(":",snap->line)+1,50))
      SKIP
      lcAuthor := ALLTRIM(SUBSTR(snap->line,Rat(":",snap->line)+1,50))
      SKIP
      // at 26
      lcCopyright := ALLTRIM(SUBSTR(snap->line,AT(":",snap->line)+1,50))
   ENDIF
   
   lcFunct := ""
   lcline := ""
   IF "87"$mvar
      lcline := laPrgDir[x][1]
   ELSE
      GOTO lnfirstrec
      DO WHILE !EOF()
         IF ("Function:"$snap->line)
            lcline := ALLTRIM(SUBSTR(snap->line,26,19))
            EXIT
         ENDIF
         SKIP
      ENDDO
   ENDIF
   GOTO lnfirstrec
   REPLACE snap->line WITH ALLTRIM(snap->line)+lcline
   DO WHILE !EOF()
      IF ("Called by:"$snap->line)
         DO WHILE !("************"$snap->line) .AND. !EOF()
            IF SUBSTR(snap->line,25,1) == ":" .AND. .NOT.;
                  ALLTRIM(SUBSTR(snap->line,26,19))$lcfunct .AND. .NOT.;
                  ALLTRIM(SUBSTR(snap->line,26,19))$lcline  //already in list
               lcfunct    := lcfunct    +" XREF.EHO:"+ ALLTRIM(SUBSTR(snap->line,26,19))
               lcAllCross := lcAllCross +" "+ ALLTRIM(SUBSTR(snap->line,26,19))
            ENDIF
            SKIP
         ENDDO
      ENDIF
      snap->(dbskip())
   ENDDO
   
   APPEND BLANK
   IF FILE(pcSourceDir+"XREF.DOC")
      REPLACE Line WITH "!SeeAlso:"+lcfunct
   ENDIF
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      RETURN NIL
   ENDIF
NEXT

@ 03,05 SAY SPACE(12)
@ 03,05 SAY "ACT.EHS"
@ 19,05 SAY "Building Eh ACT.EHS compile file       "
@ 20,05 SAY SPACE(60)
COPY TO (pcDestinDir+"ACT.EHS") SDF FOR disprec()
*******************************[ menu file ]
@ 03,05 SAY SPACE(12)
@ 19,05 SAY SPACE(60)
@ 03,05 SAY pcprgname+".EHS"
@ 19,05 SAY "Building Eh "+pcprgname+".EHS Menu file"

IF !FILE(pcDestinDir+pcprgname+".EHS") .OR.  plMenuMake
   // make menu
   
   IF (lnHandle := FCREATE(pcDestinDir+pcprgname+".EHS")) == 1
      ALERT("ERROR creating "+pcDestinDir+pcprgname+".EHS Menu file err:"+STR(FERROR(),3))
      RETURN NIL
   ENDIF
   FWRITE(lnHandle,"!Name:"+lcTitle+CrLf)
   FWRITE(lnHandle,"!Credits:"+lcAuthor+CrLf)
   FWRITE(lnHandle,lcCopyright+CrLf)
   FWRITE(lnHandle,"!Menu:Source "+CrLf)
   FWRITE(lnHandle,SPACE(6)+"Action Drawings ACT.EHO"+CrLf)
ENDIF
@ 20,05 SAY "Name:"+lcTitle
@ 21,05 SAY "Credits:"+lcAuthor
@ 22,05 SAY lcCopyright

IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
   FCLOSE(lnHandle)
   RETURN NIL
ENDIF

******************************[ datadict ]
ZAP
lncurrent := 0
IF FILE(pcSourceDir+"DATADICT.DOC")
   lncurrent++
   @ 03,05 SAY SPACE(12)
   @ 03,05 SAY "DATADICT.DOC"
   @ 19,05 SAY SPACE(60)
   @ 19,05 SAY "Building Eh DataDict.EHS Compile file"
   
   lnfirstrec := RECNO()
   APPEND FROM (pcSourceDir+"DATADICT.DOC") SDF
   GOTO lnfirstrec
   lcFunct := ""
   
   DO WHILE !EOF()
      IF "Structure for database :"$snap->line
         lcfunct := snap->line
         SKIP - 1
         REPLACE snap->line WITH "!short:"+ ALLTRIM(SUBSTR(lcfunct,25,80))
         SKIP
         lcFunct := ""
      ENDIF
      snap->(dbskip())
   ENDDO
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      FCLOSE(lnHandle)
      RETURN NIL
   ENDIF
   
   @ 17,60 SAY SPACE(9)
   COPY TO (pcDestinDir+"DATADICT.EHS") SDF  FOR disprec()
   
   IF plMenuMake
      FWRITE(lnHandle,"!Menu:DataDict "+CrLf)
      FWRITE(lnHandle,SPACE(6)+"Data Dict DATADICT.EHO"+CrLf)
   ENDIF
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      FCLOSE(lnHandle)
      RETURN NIL
   ENDIF
ENDIF

*******************************[ update menu file ]

******************************[ xref ]
ZAP
lncurrent := 0
IF FILE(pcSourceDir+"XREF.DOC")
   lncurrent++
   @ 03,05 SAY SPACE(12)
   @ 19,05 SAY SPACE(60)
   @ 03,05 SAY "XREF.DOC"
   @ 19,05 SAY "Building Eh XREF.EHS Compile file"
   
   lnfirstrec := RECNO()
   APPEND FROM (pcSourceDir+"XREF.DOC") SDF
   GOTO lnfirstrec + 10
   REPLACE Line WITH "!short:"+snap->line
   GOTO lnfirstrec + 27
   
   lcFunct := ""
   
   DO WHILE !("-------------"$snap->line) .AND. !EOF()
      IF AT(" ",snap->line) <> 1
         REPLACE snap->line WITH "!short:"+ ALLTRIM(snap->line)
         lcFunct := ""
      ELSE
         IF !EMPTY(snap->line) .AND. !(lcfunct$snap->line)
            lcFunct := lcFunct + " ACT.EHO:"+ALLTRIM(SUBSTR(snap->line,1,;
               MIN(19,AT(".",snap->line)-1))+"()")
         ELSE
            IF LEN(ALLTRIM(lcfunct)) <> 0
               REPLACE snap->line WITH "!Seealso:"+lcFunct
            ENDIF
         ENDIF
      ENDIF
      snap->(dbskip())
   ENDDO
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      FCLOSE(lnHandle)
      RETURN NIL
   ENDIF
   
   @ 17,60 SAY SPACE(9)
   COPY TO (pcDestinDir+"XREF.EHS") SDF  FOR disprec()
   
   IF plMenuMake
      FWRITE(lnHandle,"!Menu:Cross Ref "+CrLf)
      FWRITE(lnHandle,SPACE(6)+"Cross Ref XREF.EHO"+CrLf)
   ENDIF
ENDIF

*******************************[ update menu file ]

IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
   RETURN NIL
ENDIF

*****************************[ SDF ]
ZAP
IF FILE(pcSourceDir+"DATADICT.SDF")
   lncurrent := 1
   lncurrent := 1
   
   APPEND BLANK
   lnfirstrec := RECNO()
   REPLACE Line WITH "!short:DATADICT.SDF"
   APPEND FROM (pcSourceDir+"DATADICT.SDF") SDF
   
   @ 03,05 SAY SPACE(12)
   @ 03,05 SAY "SDF.EHS"
   @ 19,05 SAY SPACE(60)
   @ 19,05 SAY "Building Eh SDF compile file          "
   
   lcFunct := ""
   lcLine  := ""
   GOTO lnfirstrec
   DO WHILE !EOF()
      
      IF ALLTRIM(snap->line)$lcAllCross .AND. .NOT. ALLTRIM(snap->line)$lcfunct
         lcFunct := lcFunct + ALLTRIM(snap->line)+" "
         
      ENDIF
      snap->(dbskip())
   ENDDO
   
   APPEND BLANK
   REPLACE Line WITH "!SeeAlso:"+lcfunct
   
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      FCLOSE(lnHandle)
      RETURN NIL
   ENDIF
   
   @ 17,60 SAY SPACE(9)
   COPY TO (pcDestinDir+"SDF.EHS") SDF  FOR disprec()
   
   IF plMenuMake
      FWRITE(lnHandle,"!Menu:SDF Files "+CrLf)
      FWRITE(lnHandle,SPACE(6)+"SDF SDF.EHO"+CrLf)
   ENDIF
ENDIF
**************************[ Doc ]
laDocDir := DIRECTORY(pcSourceDir+"*.DOC")
lncount := LEN(laDocDir)
lncurrent := 0
lndocs  := 0

FOR X := 1 TO LEN(laDocDir)
   lncurrent++
   IF laDocDir[X][1] == "DATADICT.DOC" .OR. laDocDir[X][1] == "XREF.DOC"
      LOOP
   ENDIF
   lnDocs++
   APPEND BLANK
   lnfirstrec := RECNO()
   REPLACE Line WITH "!short:"+laDocDir[X][1]
   APPEND FROM (pcSourceDir+laDocDir[X][1]) SDF
   
   @ 03,05 SAY SPACE(12)
   @ 03,05 SAY laDocDir[X][1]
   @ 19,05 SAY "Building Eh DOC compile file          "
   @ 20,05 SAY SPACE(60)
   @ 20,17 SAY STR(lncount,5)
   @ 20,31 SAY STR(lncurrent,5)
   
   lcFunct := ""
   lcLine  := ""
   GOTO lnfirstrec
   DO WHILE !EOF()
      
      IF ALLTRIM(snap->line)$lcAllCross .AND. .NOT. ALLTRIM(snap->line)$lcfunct
         lcFunct := lcFunct + ALLTRIM(snap->line)+" "
      ENDIF
      snap->(dbskip())
   ENDDO
   
   APPEND BLANK
   REPLACE Line WITH "!SeeAlso:"+lcfunct
   
   IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
      FCLOSE(lnHandle)
      RETURN NIL
   ENDIF
NEXT

IF lnDocs > 0         //found more than datadict & xref.doc
   @ 03,05 SAY SPACE(12)
   @ 03,05 SAY "DOC.EHS"
   @ 17,60 SAY SPACE(9)
   COPY TO (pcDestinDir+"DOC.EHS") SDF  FOR disprec()
   IF plMenuMake
      FWRITE(lnHandle,"!Menu:DOC Files "+CrLf)
      FWRITE(lnHandle,SPACE(6)+"Other DOC's DOC.EHO"+CrLf)
   ENDIF
ENDIF

*********************************************************************
IF plMenuMake
   IF !FCLOSE(lnHandle)
      ALERT("Error closing "+pcprgname+".EHS Menu file, err: "+STR(FERROR(),3))
      RETURN NIL
   ENDIF
ENDIF
IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop",{"Yes","No"}) == 1
   RETURN NIL
ENDIF
ZAP

IF !SWPRUNCMD("EHC "+pcDestinDir+"ACT.EHS"+ ;
   " -E"+pcDestinDir+"ACTcomp.err  -NP" )
   AADD(laerror,"ACT.EHS")
ENDIF

IF FILE(pcSourceDir+"XREF.DOC")
   IF !SWPRUNCMD("EHC "+pcDestinDir+"XREF.EHS"+ ;
      " -E"+pcDestinDir+"DOCcomp.err  -NP" )
      AADD(laerror,"XREF.EHS")
   ENDIF
ENDIF
IF FILE(pcSourceDir+"DATADICT.SDF")
   IF !SWPRUNCMD("EHC "+pcDestinDir+"SDF.EHS"+ ;
      " -E"+pcDestinDir+"SDFcomp.err  -NP" )
      AADD(laerror,"SDF.EHS")
   ENDIF
ENDIF

IF FILE(pcSourceDir+"DATADICT.DOC")
   IF !SWPRUNCMD("EHC "+pcDestinDir+"DATADICT.EHS"+ ;
      " -E"+pcDestinDir+"SDFcomp.err  -NP" )
      AADD(laerror,"DATADICT.EHS")
   ENDIF
ENDIF

IF lndocs > 0
   IF !SWPRUNCMD("EHC "+pcDestinDir+"DOC.EHS"+ ;
      " -E"+pcDestinDir+"SDFcomp.err  -NP" )
      AADD(laerror,"DOC.EHS")
   ENDIF
ENDIF

IF NEXTKEY() == K_ESC .AND. ALERT("Do you really want to Stop? Your almost done",{"Yes","No"}) == 1
   RETURN NIL
ENDIF

IF !SWPRUNCMD("EHML "+pcDestinDir+pcprgname+".EHS -I"+pcDestinDir+;
   " -O"+pcDestinDir+" -E"+pcDestinDir+pcprgname+".err -NP" )
   AADD(laerror,pcprgname+".EHS")
ENDIF

cls
IF LEN(laerror) == 0
   @ 11,25 SAY "       NORMAL EXIT"
   @ 13,25 SAY "Uncle Al's Lunch Time Products"
   @ 15,25 SAY "      426 4th Street"
   @ 16,25 SAY "    Northfield IL 60093"
   @ 18,24 SAY "*" COLOR "*W/+B"
   @ 18,25 SAY "Wait while I take my shoes off"
   COMMIT
   @ 18,24 SAY " "
   @ 23,1  SAY " "
ELSE
   @ 02,25 SAY "** Something returned an DOS error ** "
   FOR X := 1 TO LEN(laerror)
      ? laerror[x]
   NEXT
   @ 18,24 SAY "*" COLOR "*W/+B"
   @ 18,25 SAY " Closing files, Check the error files"
   COMMIT
   @ 18,24 SAY " "
   @ 23,1  SAY " "
ENDIF

RETURN NIL

*!*****************************************************************************
*!
*!       Function: DISPREC()
*!
*!      Called by: MAIN()             (function  in EH_SNAP.PRG)
*!
*!*****************************************************************************
FUNCTION disprec()
@ 17,60 SAY RECNO() picture "9,999,999"
RETURN .T.
*!*****************************************************************************
*!
*!       Function: CHECKDIR()
*!
*!      Called by: MAIN()             (function  in EH_SNAP.PRG)
*!
*!*****************************************************************************
FUNCTION checkDir(lcDir)
LOCAL ans := .T.
DO CASE
CASE EMPTY(lcDir) .OR. RIGHT(ALLTRIM(lcDir),1) == "\"
   
CASE RIGHT(ALLTRIM(lcDir),1) == "/"
   lcDir := SUBSTR(lcDir,1,LEN(ALLTRIM(lcDIR))-2) +"\"+SPACE(255)
   
OTHERWISE
   lcDir := ALLTRIM(lcDir) +"\"+SPACE(255)
ENDCASE

RETURN ans
*: EOF: EH_SNAP.PRG
