 /* FS2.C
 * whereis functions, remove dir functions
 * MSC8 (VC++ 1.5)
 * FS 2.9
 * 270195
 * Copyright (C) M. van Breemen, 1992-1995, All rights reserved.
 */

#include "FS.H"

/* Prototypes */
void working( int mode );
int edit(char *title, char *string, int length , char *legal_illegal, int legalmode);
void show_pages(FILE *stream, long *pages, unsigned int last_page_nr, int max_linewidth );
void show_pages_status_line(int tabwidth, int wrap,
			    unsigned int page_nr, unsigned int last_page_nr,
			    char *horizontal_position);
int copy( char *oldname, char *newname );
int whereis(char *searchstring, int *current_page, int *filenumber );
void outtextm( char *string );
void alert( void );
void show_error( char *message );
void show_message( char *message );
void wait_sec( int milliseconds );
void clear_left_button_queue( void );
void clear_right_button_queue( void );
int read_left_button_queue( int *row, int *col );
int read_right_button_queue( int *row, int *col );
void init_mouse( void );
void hide_mouse( void );
void show_mouse( void );
int mouse_button_pressed( void );
unsigned int n_kbhit( void );
int getkey(void);
void changecursor(int insmode);
void setcursor(unsigned int shape);
int editstring(int row, int col, char *s, char *legal_illegal, int legalmode, int maxlength);
char __near *saveScrn(void);
char __near *restScrn(char __near *saveArea);
int valid_filename( char *newname);
void shadebox( short r1, short c1, short r2, short c2 );
void shadechar( int row, int col );
int find_in_file( char *filename , char *string, int ignore_case, int use_soundex);
int extract_directory( char *searchstring );
char *set_working_drive_and_dir( char *full_filename );
int find_name(char *fname, int *current_page, int *filenumber);
void construct_search_path( char *linebuf );
char *getpath( int drive, char *buffer, int maxlen );
char __near *show_string(char *string, int bg_color, int text_color);
void paint_box(char *string, int vis_width, int vis_height);
void copy_date_time_attrib( char *source, char *target );
char *soundex(char *instr, char *outstr);
int show_context(char *buffer, long buffersize, long offset, int length);
int contains_nonprintable( char *string);
char *fgetl(char *string, int maxlength, FILE *stream);
int show_file(char *filename, int max_linewidth);
int old_show_file(char *filename);
int TabExpand (char *to, char *from, int ntabsp, unsigned int max_length);
int getdiskfree( int lastdrive, long *freebytes );
unsigned int getshift(void);

/* global variables */

extern int number_of_files;    /* number of files found */

extern int order_by;           /* NAME, DATE or SIZE */
extern int order_type;         /* ASCENDING or DESCENDING */

extern short int screen_bg_color;
extern short int file_color;
extern short int hidden_file_color;
extern short int directory_color;
extern short int hidden_directory_color;
extern short int volume_label_color;
extern short int cursor_bg_color;
extern short int info_bg_color;
extern short int info_text_color;
extern short int error_text_color;
extern short int error_bg_color;

typedef struct find_t_small {
				char name [13];
				char attrib;
				unsigned long datetime_or_size;
			    } FIND_T_SMALL;
			  
extern FIND_T_SMALL *find;      /* pointer to the file info structures */
extern int mouse_present;       /* boolean is there a mouse ? */
extern int mouse_row;   /* mouse position, NOT screen rows and columns */
extern int mouse_col;
extern int max_files;           /* maximal number of accessible files per directory or root, defaults to 456 */
extern int dos_error;           /* set by error handler */
extern int dos_retries;         /* set by error handler */
extern int dos_error_auto_fail; /* read by error handler */


/*---------------------------------------------------------------------------*/
/*   FF Routines taken from FFF 3.4.5, a public domain program to search files
 *      Author: Don A. Williams                                                                                  *
 *              CompuServ -                                                                                              *
 *              Genie     - DON-WILL                                                                             
 *      Customized !!
*/


#define U_ESC    1
#define U_SELECT 2
#define U_GOTO   3
#define U_ERROR  4

#define FIND_FIRST(Name,Block,Attrib) _dos_findfirst(Name, Attrib, Block);
#define FIND_NEXT(Block) _dos_findnext(Block);
#define DIR_ENTRY find_t        /* Name of the directory entry structure        */
#define D_ATTRIB attrib         /* Attribute field in directory entry           */
#define D_NAME name             /* File name field in directory entry           */


typedef struct QueEntry {
			  struct QueEntry *Next;
			  char  *Body;
			} QUE_ENTRY;

typedef struct QueDef {
			QUE_ENTRY *Head, *Current;
			int        Count;
		      } QUE_DEF;

/* Function prototypes    */

int             fff( char *fpattern, char *sstring, int ignore_case, int use_soundex);
void            InitQueue (QUE_DEF *Q);
QUE_ENTRY       *Enque (QUE_DEF *Q, void *Body);
int             WalkTree (QUE_DEF * Q, char *sstring , int ignore_case, int use_soundex);
int             SearchQ (char *Str);
int             Match (char *Str, char *Pat);
static int      I_Match (char *Str, char *Pat);
static int      S_Match (char *S, char *P, int Anchor);
void            DeleteQueue( QUE_DEF PatQue );

void            clean_dir(char *path);
void            do_dir(char *path);

/*----------------------------------------------------------------------*/

extern QUE_DEF  PatQue;
extern char             T_Path[_MAX_PATH];                    /* Temporary directory path to search   */
extern char             V_Path[_MAX_PATH];                    /* Selected file */

void DeleteQueue( QUE_DEF PatQue )
{
    QUE_ENTRY *t, *u;
    for (t = PatQue.Head; t != NULL;)
    {
	u = t->Next;
	free(t->Body);
	free(t);
	t = u;
    }
}

int fff(char *fpattern, char *sstring, int ignore_case, int use_soundex)
{
	char            *p, *p2;
	char            scratchfpattern[_MAX_PATH];
	char            Path[_MAX_PATH];                              /* Current directory path to search             */
	char            Devices[16] = "";
	int             Result;
	int             i;

	strcpy (scratchfpattern,fpattern);
	InitQueue(&PatQue);
	strcpy(Path, "C:\\");
	Devices[0] = (char) (_getdrive() - 1 + 'A');
	Devices[1] = '\0';

/*      Interpret fpattern tokens */
	p = strtok( scratchfpattern, " " );     /* Find first token     */
	while( p != NULL )
	{

			if ((p2 = strchr(p, ':')) != NULL)  /* process devices */
			{
				*p2 = '\0';
				strcpy(Devices, p);
				p2++;                  /* skip NULL */
				p = p2;                /* remove device */
			}
			if ((p2 = strrchr(p, '\\')) != NULL)  /* process path */
			{
				*p2 = '\0';
				if (p[0]=='\\') strcpy(Path,"C:");
				else strcpy(Path,"C:\\");
				strcat(Path, p);
				if (Path[strlen(Path)-1]!='\\') strcat(Path,"\\");
				p2++;                         /* skip backslash */
				p = p2;                       /* remove path */
			}
			if (strlen(p))
			{
				  if (strlen(p)>12)
				  {
				     DeleteQueue( PatQue );
				     return FAILURE;  /* illegal filename length, abort */
				  }
				  if (!Enque(&PatQue, strupr(p)))
				  {
				    DeleteQueue( PatQue );
				    _settextposition( 8, 3 );
				    outtextm( "Memory exhausted, search aborted");
				    alert();
				    wait_sec(1000);
				    return FAILURE;
				  }
			}
			p = strtok( NULL, " " );        /* Find next token             */
	}

/* This does the work by walking the directory structure for each specified     */
/* disk                                                                                                                                         */

	p = Devices;
	while (*p != '\0') {
		strcpy(T_Path, Path);
		T_Path[0] = *p++;         /* set drive */
		if (Result=WalkTree(&PatQue,sstring,ignore_case,use_soundex)) break;
		}
	if (!Result)
	{
		      _settextposition( 6, 3 );
		      outtextm("No more matches");
		      hide_mouse();
		      for (i=15;i<=63;i++) _outtext(" ");
		      show_mouse();
	}

	DeleteQueue( PatQue );
	return (Result);
}

/*----------------------------------------------------------------------*/
/* WalkTree is a recursive routine that walks the directory structure   */
/* specifed by the external T_Path.  It bypasses Volume IDs and builds  */
/* a linked list queue of directories that is processed after all of    */
/* the file entries have been processed.                                                                */

int WalkTree (QUE_DEF *Q, char *sstring, int ignore_case, int use_soundex)
{
    int         Status;
    char        Reply;
    QUE_DEF     Direc;
    QUE_ENTRY   *t, *u;
    char        *p;
    struct DIR_ENTRY  DirBlk;           /* Directory Entry structure                    */
    int         TotalFiles = 0;         /* Total files processed                        */
    int         TotalMatch = 0;         /* Count of all files matched                   */
    int operator_intervention=FALSE;
    register int i;
    int mouse_row, mouse_col;
    int ulc_row, ulc_col, dummy;        /* upper left corner row and column of window */

    _gettextwindow(&ulc_row,&ulc_col,&dummy,&dummy);    /* mouse coordinates are absolute! */
    InitQueue(&Direc);
    strcat(T_Path, "*.*");
    
    dos_error=0;
    dos_retries=0;
    dos_error_auto_fail=TRUE;
    Status = FIND_FIRST(T_Path, &DirBlk, 0xFF);
    if (dos_error) operator_intervention=U_ERROR;
    dos_error=0;
    dos_retries=0;
    dos_error_auto_fail=FALSE;
    
    *(strrchr(T_Path, '\\') + 1) = '\0';
    _settextposition( 6, 3 );
    outtextm(T_Path);       /* show progress */
    hide_mouse();
    for (i=strlen(T_Path);i<=63;i++) _outtext(" ");
    show_mouse();

    while (!Status && !operator_intervention)
    {  /*1*/
	 if (n_kbhit() || mouse_button_pressed())  /* operator ESCapes */
	 {  /*2*/
	     if (n_kbhit()) Reply = (char) getkey();
	     else
	     {
		 if (mouse_present)
		 if (read_left_button_queue(&mouse_row,&mouse_col) && ((mouse_row-ulc_row+1)==8))
		 {
		     if ((mouse_col-ulc_col+1)>=54 && (mouse_col-ulc_col+1)<=66) Reply=0x1B;
		     else Reply='\0';
		 }
	     }

	     if (Reply == 0x1B)    /* confirm */
	     {
		 _settextposition( 8, 3 );
		 outtextm("Type ESC to stop search, other key to continue");
		 _settextposition( 1, 1 );
		 Reply = (char) getkey();
		 _settextposition( 8, 3 );
		 outtextm("                                              ");
		 if (Reply==0x1B) operator_intervention=U_ESC;
	     }
	 } /*2*/

	 if (!operator_intervention)
	 {
	     if ((DirBlk.D_ATTRIB & _A_VOLID) != 0)  /* Bypass Volume Label */
	     {
		 Status = FIND_NEXT(&DirBlk);
		 continue;
	     }
	 }

	 if (!operator_intervention)
	 {  /*3*/
	     if ((DirBlk.D_ATTRIB & _A_SUBDIR) != 0) /* Process subdirectory */
	     {
		 if (DirBlk.D_NAME[0] != '.')
		 {
		     if (!Enque(&Direc, DirBlk.D_NAME))
		     {
			 _settextposition( 8, 3 );
			 outtextm( "Memory exhausted, search aborted");
			 alert();
			 wait_sec(1000);
			 operator_intervention=FAILURE;
		     }
		 }
	     }
	     else
	     { /*C*/                            /* Process file entry */
		 ++TotalFiles;
		 if ( SearchQ(DirBlk.D_NAME) )
		 {  /*B*/
		     strcpy(V_Path, T_Path);
		     strcat(V_Path, DirBlk.D_NAME);
		     _settextposition( 6, 3 );
		     outtextm(V_Path); /* show filename match */
		     hide_mouse();
		     for (i=strlen(V_Path);i<=63;i++) _outtext(" ");
		     show_mouse();

		     if (strlen(sstring) ? find_in_file(V_Path,sstring, ignore_case, use_soundex) : TRUE)
		     { /*A*/
			 ++TotalMatch;
			 _settextposition( 8, 3);
			 outtextm("Next, Select, Goto  ");
			 do
			 {
			     while (!n_kbhit() && !mouse_button_pressed()) /* wait */ ;
			     if (n_kbhit()) Reply = (char) getkey();
			     else
			     {
				 Reply='\0';
				 if (mouse_present)
				 if (read_left_button_queue(&mouse_row,&mouse_col) && ((mouse_row-ulc_row+1)==8))
				 {
				     if ((mouse_col-ulc_col+1)>=3 && (mouse_col-ulc_col+1)<=6)
					 Reply='N';
				     if ((mouse_col-ulc_col+1)>=9 && (mouse_col-ulc_col+1)<=14)
					 Reply='S';
				     if ((mouse_col-ulc_col+1)>=17 && (mouse_col-ulc_col+1)<=20)
					 Reply='G';
				     if ((mouse_col-ulc_col+1)>=54 && (mouse_col-ulc_col+1)<=66)
					 Reply=0x1B;
				 }
			     }
			     switch (Reply)
			     {
				 case 0x1B: _settextposition( 8, 3);
					    outtextm("                    ");
					    operator_intervention=U_ESC;
					    break;
				 case 'S':
				 case 's': operator_intervention=U_SELECT;
					   break;
				 case 'G':
				 case 'g': operator_intervention=U_GOTO;
					   break;
				 default: break;
			     }
			 } while (Reply!='N' && Reply !='n' && !operator_intervention);
			 _settextposition( 8, 3);
			 outtextm("                    ");

		     } /*A*/
		 } /*B*/
	     } /*C*/


	 } /*3*/
	 Status = FIND_NEXT(&DirBlk);
    } /*1*/


    /* Process any entries in the linked list of subdirectories */
    if (TRUE)       /* was !operator_intervention */
    {
	p = strrchr(T_Path, '\\') + 1;  /* remove last filename */
	for (t = Direc.Head; t != NULL;) /* was && !operator_intervention;) */
	{
		*p = '\0';
		strcat(T_Path, t->Body);
		strcat(T_Path, "\\");
		if (!operator_intervention)   /* do not expand */
		     operator_intervention=WalkTree(Q,sstring,ignore_case, use_soundex);
		u = t->Next;
		free(t->Body);
		free(t);
		t = u;
	}
    }

    return (operator_intervention);
}

/*----------------------------------------------------------------------*/
/* SearchQ takes a file name as input and matches it against all of the */
/* patterns in the linked list of patterns built from command line              */
/* arguments.  The pattern list is an external.                                                 */

int SearchQ (char *Str)
{
	extern QUE_DEF  PatQue;
	QUE_ENTRY      *t;
	int             Result;

	for (t = PatQue.Head; t != NULL; t = t->Next) {
		Result = Match(Str, t->Body);
		if (Result != 0) return(Result);
		}
	return (0);
}




/****************************************************************************
 *  InitQueue initializes a queue for use by the other queue functions.
 ***************************************************************************/

void InitQueue (QUE_DEF *Q)
{
	Q->Head = Q->Current = NULL;
	Q->Count = 0;
}

/****************************************************************************
 *  Enque  creates a queue entry linked to the other entries in FIFO order
 *  and puts the string passed into the queue entry.  It returns a pointer
 *  to the entry created [NULL if there is not enough memory for the entry.
 ***************************************************************************/

QUE_ENTRY *Enque (QUE_DEF *Q, void *Body)
{
	QUE_ENTRY *p;
	if ((p = malloc(sizeof(QUE_ENTRY))) == NULL ) return(NULL);
	p->Next = NULL;
	if ((p->Body = malloc(strlen(Body) + 1)) == NULL) return(NULL);
	strcpy(p->Body, Body);
	if (Q->Head == NULL) Q->Head = p;
	else Q->Current->Next = p;
	Q->Current = p;
	++Q->Count;
	return(p);
}



int Match (char *Str, char *Pat)
{
	char S_Name[_MAX_PATH], S_Ext[4];
	char P_Name[_MAX_PATH], P_Ext[4];
	char *p1;
	strupr(Pat);
	if ( (p1 = strrchr(Str, '.')) != NULL ) {
		*p1 = '\0';
		strcpy(S_Name, Str);
		strcpy(S_Ext, p1+1);
		*p1 = '.';
		}
	else {
		strcpy(S_Name, Str);
		S_Ext[0] = '\0';
		}

	if ( (p1 = strchr(Pat, '.')) != NULL ) {
		*p1 = '\0';
		strcpy(P_Name, Pat);
		strcpy(P_Ext, p1+1);
		*p1 = '.';
		}
	else {
		strcpy(P_Name, Pat);
		strcpy(P_Ext, "*");
		}

	if ( !I_Match(S_Name, P_Name) ) return(0);
	if ( (P_Ext[0] == '\0') && (S_Ext[0] != '\0') ) return(0);
	if ( !I_Match(S_Ext, P_Ext) ) return(0);
	return(1);
}


static int I_Match (char *Str, char *Pat)
{
	char *p, *p1, *p2, Hold;
	int t;
	if ( (p1 = strchr(Pat, '*')) == NULL)
		return( S_Match(Str, Pat, 1) );
	if (Pat[0] != '*') {
		*p1 = '\0';
		t = S_Match(Str, Pat, 0);
		*p1 = '*';
		if (!t) return(0);
		}
	if (Pat[strlen(Pat)-1] != '*') {
		p2 = strrchr(Pat, '*') + 1;
		if (strlen(Str) < strlen(p2)) return(0);
		if ( !S_Match(&Str[strlen(Str) - strlen(p2)], p2, 1) )
			return(0);
		}

	p = Str;
	while ( (p2 = strchr(++p1, '*')) != NULL ) {
		*p2 = '\0';
		Hold = p1[0];
		while ( (p = strchr(p, Hold)) != NULL ) {
			if ( S_Match(p, p1, 0) ) break;
			++p;
			}
		if (p == NULL) return(0);
		p += strlen(p1);
		*p2 = '*';
		p1 = p2;
		}
	return(1);
}


static int S_Match (char *S, char *P, int Anchor)
{
	while ( (*P != '\0') && (*S != '\0') ) {
		if ( (*S == *P) || (*P == '?') ) {
			S++;
			P++;
			}
		else return(0);
		}
	if (*P != '\0') return(0);
	if ( Anchor && (*S != '\0') ) return(0);
	return(1);
}

/***************************************************************************
 Handles 'where is' screen
 searchstring is the mask without device and path !
 fpattern defaults to device + path + mask
*/
int whereis(char *searchstring, int *current_page, int *filenumber)
{
    static char fpattern[_MAX_PATH]={'\0'};
    static char org_sstring[50]={'\0'};
    char sstring[50]={'\0'};

    char b[(9*69)+10]={               /* Buffer for string */
	    "ͻ\n"
	    "                   WHERE IS FILE CONTAINING WHAT                  \n"
	    "͹\n"
	    " Filename pattern:                                                \n"
	    "    Search string:                                                \n"
	    "                                                                  \n"
	    "͹\n"
	    "                                                    ESC to cancel \n"
	    "ͼ\n"

		      };

    char __near *savedscreen;
    int result,result2;
    int i;
    char *slash;
    int ignore_case;
    int use_soundex;

    construct_search_path(fpattern);

    if (!strlen(fpattern)) strcpy(fpattern,searchstring);
    if (strlen(fpattern)>46) strcpy(fpattern,searchstring);
    savedscreen=saveScrn();


    _settextcolor( (short) info_text_color );
    _setbkcolor( (long) info_bg_color );

    paint_box( b, 68, 9);

    _settextposition( 4, 21 );
    outtextm(fpattern);
    _settextposition( 5, 21 );
    outtextm(org_sstring);
    do
    {

	_settextposition( 8, 3 );
	outtextm("Enter a filename pattern, hit Return");
	if (!(result=editstring(4, 21, fpattern, "+=[];|,<>/\"", ILLEGAL, 46))) break;
	if (!strlen(fpattern)) strcpy(fpattern,"*.*");

	_settextposition( 6, 3 );
	outtextm("Append /I to the string to ignore case, /S to use soundex");
	_settextposition( 8, 3 );
	outtextm("Enter string, empty to skip IN search, hit Return");
	if (!(result=editstring(5, 21, org_sstring, "", ILLEGAL, 46))) break;
	_settextposition( 8, 3 );
	hide_mouse();
	for (i=3;i<=52;i++) _outtext(" ");
	_settextposition( 6, 3 );
	for (i=3;i<=62;i++) _outtext(" ");
	show_mouse();
	strcpy(sstring,org_sstring);

	/* default ignore_case = FALSE */
	ignore_case=FALSE;
	if (slash=strstr(sstring,"/I"))
	{
	    if (slash[2]=='\0')   /* sstring ENDS with /I option, otherwise part of sstring */
	    {
	       ignore_case=TRUE;
	       *(slash)='\0';
	    }
	}
	if (slash=strstr(sstring,"/i"))
	{
	    if (slash[2]=='\0')   /* sstring ENDS with /I option, otherwise part of sstring */
	    {
	       ignore_case=TRUE;
	       *(slash)='\0';
	    }
	}

	/* default use_soundex = FALSE */
	use_soundex=FALSE;
	if (slash=strstr(sstring,"/S"))
	{
	    if (slash[2]=='\0')   /* sstring ENDS with /S option, otherwise part of sstring */
	    {
	       use_soundex=TRUE;
	       *(slash)='\0';
	    }
	}
	if (slash=strstr(sstring,"/s"))
	{
	    if (slash[2]=='\0')   /* sstring ENDS with /S option, otherwise part of sstring */
	    {
	       use_soundex=TRUE;
	       *(slash)='\0';
	    }
	}

	switch (result=fff(fpattern,sstring,ignore_case,use_soundex))     /* result in V_Path */
	{
	      case U_ESC: _settextposition( 6, 3 );
			  outtextm("Last search canceled");
			  hide_mouse();
			  for (i=20;i<=63;i++) _outtext(" ");
			  show_mouse();
			  break;
	      case U_ERROR: _settextposition( 6, 3 );
			    outtextm("A disk error occurred");
			    hide_mouse();
			    for (i=20;i<=63;i++) _outtext(" ");
			    show_mouse();
			    break;
	      case U_SELECT:
	      case U_GOTO: slash=set_working_drive_and_dir(V_Path); /* make drive & dir default */
								    /* and find filename */
			   if (!slash)
			   {
			     result=FAILURE;
			     break;
			   }

			   /* first try original searchstring */
			   if (!Match(slash,searchstring))
			   {
			     _settextposition( 8, 3 );
			     outtextm( "Mask changed to *.*" );
			     wait_sec(1000);
			     strcpy(searchstring,"*.*");       /* this should match */
			     extract_directory(searchstring);
			     result2=find_name(slash, current_page, filenumber);
			   } else
			     {
			       extract_directory(searchstring);
			       result2=find_name(slash, current_page, filenumber);
			     }
			   if (result2==FAILURE)          /* find array might be full */
			   {
			       _settextcolor( (short) info_text_color );
			       _setbkcolor( (long) info_bg_color );
			       _settextposition( 8, 3 );
			       outtextm( "Mask changed to " );
			       outtextm( slash );
			       wait_sec(1000);
			       strcpy(searchstring,slash);  /* this should work always */
			       extract_directory(searchstring);
			       result2=find_name(slash, current_page, filenumber);
			   }
			   if (result2==FAILURE) result=FAILURE;
			   break;
	      default: break;
	}
    } while (result!=U_SELECT && result!=U_GOTO && result!=FAILURE);

    _settextwindow( 3, 1, 23, 80 );
    _setbkcolor( (long) screen_bg_color );
    savedscreen=restScrn(savedscreen);
    return result;
}

/***************************************************************************
 Find a string IN a file
*/
int find_in_file( char *filename , char *string, int ignore_case, int use_soundex)
{
    char *buff;                 /* Pointer to data buffer */
    int fn;                     /* file handle */
    long fl;                    /* file length */
    unsigned int count=0x7fff;  /* buffer size */
    int  found;                 /* True if string found */
    long rsize;                 /* Amount of data read into buffer */
    register long offset;       /* Position where string code found */
    char progress_char[]={ "/-\\|"};
    static int progress_nr=0;
    char progress_str[]={ "/\0" };
    int Reply;
    char scratch[50];
    char snd1[50];
    char snd2[50];

    if (ignore_case) strupr(string);

    if (use_soundex)
    {
	 if (soundex(string,snd2)) strupr(snd2);
	 else
	 {
	     strcpy(snd2,"");
	     use_soundex=FALSE;
	 }
    }

    if( (fn = open( filename, O_BINARY | O_RDONLY )) == - 1 )
    {
      show_error("Cannot open file");
      return FALSE;
    }
    /* Get size of file */
    fl = filelength(fn);
    if( fl <  (long) count )
	count = (unsigned int) fl;

    /* Dynamically allocate a large file buffer. If there's not enough
     * memory for it, find the largest amount available
     */
    if( (buff = (char *)malloc( (size_t)count )) == NULL )
    {
	count = _memmax();
	if( (buff = (char *)malloc( (size_t)count )) == NULL )
	{
		 show_error("Cannot allocate memory for FIF");
		 close(fn);
		 return FALSE;
	}
    }

    found = FALSE;
    while ( !eof(fn) && !found)
    {
      if( (rsize = (long) read( fn, buff, count )) == FAILURE )
      {
		 show_error("Read error");
		 close(fn);
		 free(buff);
		 return FALSE;
      }

      if (ignore_case)
      {
	  for (offset=0L; offset < rsize; offset++)
	      if (isalpha((int) buff[offset]))
		 buff[offset]=(char) toupper((int) buff[offset]);
      }

      for (offset=0L; offset <= rsize-strlen(string); offset++)
      {
	 if (!(offset%5120L))   /* do checks after 5kb */
	 { /*B*/
	   if (fl > 5120L)      /* wheel */
	   {
	       if (progress_nr==3) progress_nr=0;
	       else progress_nr++;
	       progress_str[0]=progress_char[progress_nr];
	       _settextposition( 8, 3);
	       outtextm( progress_str );
	   }

	   if (n_kbhit())
	   {  /*A*/
	     Reply=getkey();
	     if (Reply==0x1B)
	     {
		 _settextposition( 8, 3);
		 outtextm("Canceled, skipping this file");
		 wait_sec(500);
		 _settextposition( 8, 3);
		 outtextm("                            ");

		 close(fn);
		 free(buff);
		 return FALSE;
	     }
	   }  /*A*/
	 } /*B*/

       if (use_soundex)
       {
	  strncpy(scratch,&buff[offset],strlen(string));
	  scratch[strlen(string)]='\0';

	  /* strings should be both alphanum ? */
	  if (contains_nonprintable(string) ||
	      (!contains_nonprintable(scratch) && !contains_nonprintable(string)))
	  {
	      if (soundex(scratch,snd1))
	      {
		strupr(snd1);                           /* Ignore case */
		if (!strcmp(snd1,snd2))                 /* here is the check */
		{
		  found = TRUE;
		  if (show_context(buff,rsize,offset,strlen(string))) break;
		  else found = FALSE;
		}
	      }
	  }
       }
       else
       {
	 if (!strncmp(&buff[offset], string, strlen(string) ))   /* here is the check */
	 {
	   found = TRUE;
	   if (show_context(buff,rsize,offset,strlen(string))) break; /* escape from FOR loop */
	   else found = FALSE;
	 }
       }
      }

      if (!found && !eof(fn))    /* reposition back strlen(string)-1 to recover from split search string */
      {
	if (lseek (fn, 1L - ((long) (strlen(string))), SEEK_CUR)==FAILURE)
	{
		 show_error("Seek error");
		 close(fn);
		 free(buff);
		 return FALSE;
	}
      }
    }

    if (fl > 2048L) /* erase wheel */
    {
	_settextposition( 8, 3);
	outtextm( " " );
    }

    free(buff);
    close(fn);

    if (!found) return FALSE;   /* String not found */
    else return TRUE;     /* String found */
}

/*
**  Remove all files and subdirectories
**  Slow but small code
**  from a public domain demo by Bob Stout
*/

/*
**  Clean all files from a directory
*/

void clean_dir(char *path)
{
      char rmpath[_MAX_PATH], *rmfile;
      char scratch[_MAX_PATH];
      struct find_t fbuf;
      int key;
      
      strcpy(rmpath, path);
      if ('\\' != (rmpath[strlen(rmpath) - 1]))
	    strcat(rmpath, "\\");
      rmfile = &rmpath[strlen(rmpath)];
      strcpy(rmfile, "*.*");
      if (!_dos_findfirst(rmpath, _A_ARCH | _A_HIDDEN | _A_NORMAL | _A_RDONLY | _A_SYSTEM, &fbuf)) do
      {
	    /* user aborts operation */
	    if (n_kbhit()) 
	    {        
		key=getkey();
		if ((key & 0x00FF)==ESC) 
		{    
		    show_message( "Aborted by user" );
		    return;
		} 
	    }   
      
	    strcpy(rmfile, fbuf.name);
	    if (remove(rmpath))
	    {
		 strcpy(scratch,"Cannot delete file");
		 strcat(scratch,rmpath);
		 show_error(scratch);
	    }
      } while (!_dos_findnext(&fbuf));
}

/*
**  Process directories
 * PLEASE PLEASE don't call with do_dir("..")
 * it works fine (I know for sure): cleans up parent directory,
 * which could be your complete harddisk
*/

void do_dir(char *path)
{
      char search[_MAX_PATH], new[_MAX_PATH];
      char scratch[_MAX_PATH];
      struct find_t ff;
      int key;
      
      strcpy(search, path);
      if ('\\' != (search[strlen(search) - 1]))
	    strcat(search, "\\");
      strcat(search, "*.*");
      if (!_dos_findfirst(search, 0xffff, &ff)) do
      {           
	    /* user aborts operation */
	    if (n_kbhit()) 
	    {        
		key=getkey();
		if ((key & 0x00FF)==ESC) 
		{    
		    show_message( "Aborted by user" );
		    return;
		} 
	    }   

	    if (ff.attrib & _A_SUBDIR && '.' != *ff.name)
	    {
		  strcat(strcat(strcpy(new, path), "\\"), ff.name);
		  do_dir(new);
	    }
      } while (!_dos_findnext(&ff));
      clean_dir(path);
      if (rmdir(path))
      {
	 strcpy(scratch,"Cannot delete directory ");
	 strcat(scratch,path);
	 show_error(scratch);
      }
}


/*
 * stripped version of FLOPTEST from William Zentmayer 06-JAN-92
 * parameters:
 * int drive = floppy drive letter to test A=0,B=1
 * returns 0 if ready 
 */

int floptest(int drv);
void int13(union REGS *, union REGS *, struct SREGS *);

int floptest(int drv)
{
   union REGS InRegs, OutRegs;
   struct SREGS SegRegs;
   char sector_data[512];
   char far *buffer=sector_data;

   InRegs.h.al=0x01;                             // number of sectors
   InRegs.h.ch=0x00;                             // cylinder       
   InRegs.h.cl=0x01;                             // sector              
   InRegs.h.dh=0x00;                             // head                 
   InRegs.h.dl=drv;                              // drive number 0=A,1=B,...
   SegRegs.es =FP_SEG(buffer);                   // segment of buffer
   InRegs.x.bx=FP_OFF(buffer);                   // offset of buffer

   InRegs.h.ah=0x02;                             // read sector
   int13(&InRegs,&OutRegs,&SegRegs);             // int 13h func 02h

   return OutRegs.h.ah;
}

void int13(union REGS *InRegs, union REGS *OutRegs, struct SREGS *SegRegs)
{
   register int i;
   int holdreg=InRegs-> h.ah;

   for(i=0;i<3;i++)
       {
       InRegs-> h.ah=0x00;                       // reset controller
       int86(0x13,InRegs,OutRegs);               // int 13h func 00h
       if(OutRegs-> h.ah)                        // reset failed     
	   break;                                // exit loop - error

       InRegs-> h.ah=holdreg;                    // called int 13h function
       int86x(0x13,InRegs,OutRegs,SegRegs);      // interrupt 13h
       if(OutRegs-> h.ah)                        // function failed
	   continue;                             // retry
       }
}

/**********************************************************************
 * Copies one file to another (both specified by path). Dynamically
 * allocates memory for the file buffer. Prompts before overwriting
 * existing file. Returns 0 if successful, otherwise -1.
 */
int copy( char *source, char *target )
{
    char __near *buf;
    char __huge *hbuf;
    int hsource, htarget, ch;
    long fsize;
    unsigned int count;
    unsigned int blocks;
    unsigned int last_count_size;
    unsigned int first_count_size;
    unsigned int iTel_r;
    unsigned int iTel_w;
    char full_source[_MAX_PATH];
    char full_target[_MAX_PATH];
    char __near *savedscreen;
    int sourcedrive;
    int targetdrive;
    long free_on_target;
    
    strupr(source);
    strupr(target);
    
    if (_fullpath( full_source, source, _MAX_PATH ) &&
	_fullpath( full_target, target, _MAX_PATH ))
    {
       if (!strcmp(full_source,full_target))   /* cyclic copy */
       {
	  show_error("Cannot copy a file to itself");
	  return (-1);
       }
    }
    
    /* determine drives to calculate free space */  
    sourcedrive=_getdrive();
    if (target[1]==':') targetdrive=(int) (target[0]-'A') + 1;
    else targetdrive=sourcedrive;
    if (getdiskfree(targetdrive,&free_on_target)==FAILURE) return (-1);
      
    /* Open source file and create target, overwriting if necessary. */
    dos_error_auto_fail=TRUE;
    if( (hsource = _open( source, O_BINARY | O_RDONLY )) == - 1 )
	return (-1);

    htarget = _open( target, O_BINARY | O_WRONLY | O_CREAT | O_EXCL,
			    S_IREAD | S_IWRITE );
    if( errno == EEXIST )
    {
	savedscreen=show_string( "Target exists. Overwrite ?", info_bg_color,info_text_color );
	_settextposition( 1, 1 );        /* prevent scroll-up from dos error */
	ch = getkey();
	restScrn(savedscreen);
	if (ch=='y' || ch=='Y')
	    htarget = _open( target, O_BINARY | O_WRONLY | O_CREAT | O_TRUNC,
				    S_IREAD | S_IWRITE );
    }

    if( htarget == -1 )
    {
	close( hsource );
	return (-1);
    }
    dos_error_auto_fail=FALSE;

    fsize=filelength( hsource );
    
    /* check free diskspace */
    if (fsize > free_on_target)
    {
	show_error("Not enough disk space");
	close( hsource );
	close( htarget );
	/* cleanup empty target file header */
	unlink(target);
	return (-1);
    } 
     
    /* first try to allocate memory with _halloc */
    count=0x8000;                        /* should be power of 2 */
    blocks=(unsigned int) (fsize/((long) count));
    if (fsize%((long) count)) blocks++; /* blocks needed */
    while (blocks && !(hbuf=_halloc((long) blocks, (size_t) count))) blocks--;   /* blocks available */
    if (blocks)
    {
	/* Read-write until there's nothing left. */
	while( !eof( hsource ) )
	{
	    /* Read and write input. */
	    first_count_size=0x8000;    /* save normal size of read */ 
	    for (iTel_r=0;iTel_r<blocks;iTel_r++)
	    {
		if( (last_count_size = (unsigned int) read( hsource, ((char __huge *) hbuf+(((long)iTel_r)*((long)count))), count )) == -1 )
		{
		    _hfree(hbuf);
		    close( hsource );
		    close( htarget );
		    return (-1);
		}
		if (eof(hsource))
		{
		     iTel_r++;     /* this is a tricky one ! */
		     break;
		}
	    }
	    for (iTel_w=0;iTel_w<iTel_r;iTel_w++)
	    {
		if (eof(hsource) && iTel_w==(iTel_r-1)) count=last_count_size; /* use size of last read */
		if( (count = (unsigned int) write( htarget, ((char __huge *) hbuf+(((long)iTel_w)*((long)first_count_size))), count )) == - 1 )
		{
		    _hfree(hbuf);
		    close( hsource );
		    close( htarget );
		    return (-1);
		}
	    }
	}
	/* Close files and release memory. */
	close( hsource );
	close( htarget );
	_hfree( hbuf );
    }
    else    /* _halloc failed, try near heap copy */
    {
       /* NEAR HEAP
	* Dynamically allocate a large file buffer. If there's not enough
	* memory for it, find the largest amount available on the near heap
	* and allocate that. This can't fail, no matter what the memory model.
	*/
	count=0xFF00;
	if( (unsigned int) fsize < count )
	count = (unsigned int) fsize;

	buf = (char __near *)_nmalloc( (size_t) count );
	if ( !buf ) /*  NULL if failed */
	{
	    count = _memmax();
	    buf = (char __near *)_nmalloc( (size_t) count );
	    if ( !buf ) /*  NULL if failed */
	    {
		show_error("Cannot allocate near heap memory for copy");
		close( hsource );
		close( htarget );
		return (-1);
	    }
	}

	/* Read-write until there's nothing left. */
	while( !eof( hsource ) )
	{
	    /* Read and write input. */
	    if( (count = (unsigned) read( hsource, buf, count )) == -1 )
	    {
		_nfree(buf);
		close( hsource );
		close( htarget );
		return (-1);
	    }
	    if( (count = (unsigned) write( htarget, buf, count )) == - 1 )
	    {
		_nfree(buf);
		close( hsource );
		close( htarget );
		return (-1);
	    }
	}
	/* Close files and release memory. */
	close( hsource );
	close( htarget );
	_nfree( buf );
    } /* end near heap */

    /* make date, time and attributes equal */
    copy_date_time_attrib( source, target );

    return 0;
}








/**********************************************************************
 * Copies the date ,time and attributes of one file to another
 */
void copy_date_time_attrib( char *source, char *target )
{
    unsigned fdate, ftime, fattr;
    int hsource;
    int htarget;

    if( _dos_open( source, _O_RDONLY, &hsource ) )
    {
	show_error( "Source open error" );
	return;
    }

    /* Get time, date, and attribute of file. */
    _dos_getftime( hsource, &fdate, &ftime );
    _dos_close( hsource );
    _dos_getfileattr( source, &fattr );

    if( _dos_open( target, _O_RDONLY, &htarget ) )
    {
	show_error( "Target open error" );
	return;
    }

    /* Set time, date, and attribute of file. */
    _dos_setftime( htarget, fdate, ftime );
    _dos_close( htarget );

    /* always set archive bit on new file */
    fattr |= _A_ARCH;
    _dos_setfileattr( target, fattr );

}




char *soundex(char *instr, char *outstr)
{                   /* ABCDEFGHIJKLMNOPQRSTUVWXYZ */
	char *table = "01230120022455012623010202";
	register int count = 0;

	while(!isalpha(instr[0]) && instr[0])
		++instr;

	if(!instr[0])     /* Hey!  Where'd the string go? */
		return(NULL);

	if(toupper(instr[0]) == 'P' && toupper(instr[1]) == 'H')
	{
		instr[0] = 'F';
		instr[1] = 'A';
	}

	/* I really don't trust this line in the original soundex code
	*outstr++ = toupper(*instr++);
	*/

	/* gebruik maximaal 5 medeklinkers */
	while(*instr && count < 5)
	{
		if(isalpha(*instr) && *instr != *(instr-1))
		{
			*outstr = table[toupper(instr[0]) - 'A'];
			if(*outstr != '0')
			{
				++outstr;
				++count;
			}
		}
		++instr;
	}

	*outstr = '\0';
	return(outstr);
}




int show_context(char *buffer, long buffersize, long offset, int length)
{
    char head[35];
    char scratch[50];
    char tail[35];
    char Reply;
    register size_t i;
    int surrounding;
    int mouse_row, mouse_col;
    int ulc_row, ulc_col, dummy;        /* upper left corner row and column of window */

    _gettextwindow(&ulc_row,&ulc_col,&dummy,&dummy);    /* mouse coordinates are absolute! */

    strncpy(scratch,buffer+offset,length);
    scratch[length]='\0';

    surrounding=(64-length)/2;

    _setbkcolor( (long) info_bg_color );
    _settextcolor( (short) hidden_directory_color );
    _settextposition( 2, 3 );

    /* show leading characters */
    if (offset>surrounding)
    {
	strncpy(head,buffer+offset-surrounding,surrounding);
	head[surrounding]='\0';
    }
    else
    {
	strncpy(head,buffer,(size_t) offset);
	head[offset]='\0';
    }
    for (i=0;i<(size_t) strlen(head);i++)
    if (!isprint(head[i])) head[i]='\xFA';
    outtextm(head);

    /* show found string */
    for (i=0;i<(size_t) length;i++)
	if (!isprint(scratch[i])) scratch[i]='\xFA';
    _settextcolor( (short) info_text_color );
    outtextm(scratch);

    _settextcolor( (short) hidden_directory_color );
    /* show trailing characters */
    if ((buffersize-(offset+length))>surrounding)
    {
	strncpy(tail,buffer+offset+length,surrounding);
	tail[surrounding]='\0';
    }
    else
    {
	strncpy(tail,buffer+offset+length,(size_t) (buffersize-(offset+length)));
	tail[(buffersize-(offset+length))]='\0';
    }
    for (i=0;i<(size_t) strlen(tail);i++)
	if (!isprint(tail[i])) tail[i]='\xFA';
    outtextm(tail);

    _settextcolor( (short) info_text_color );
    /* blank out line */
    hide_mouse();
    for (i=strlen(scratch)+strlen(head)+strlen(tail);i<=63;i++) _outtext(" ");
    show_mouse();
    _settextposition( 8, 3);
    outtextm("Any key for next occurance");

    do
    {
	while (!n_kbhit() && !mouse_button_pressed()) /* wait */ ;
	if (n_kbhit()) Reply = (char) getkey();
	else
	{
	    Reply='\0';
	    if (mouse_present)
	    if (read_left_button_queue(&mouse_row,&mouse_col) && ((mouse_row-ulc_row+1)==8))
	    {
		if ((mouse_col-ulc_col+1)>=3 && (mouse_col-ulc_col+1)<=28)
		   Reply='A';     /* any key would do */
		if ((mouse_col-ulc_col+1)>=54 && (mouse_col-ulc_col+1)<=66)
		   Reply=0x1B;
	    }
	}
    } while (!Reply);

    _settextposition( 8, 3);
    outtextm("                          ");

    _settextposition( 2, 3 );
    outtextm("                  WHERE IS FILE CONTAINING WHAT                 \n");

    if (Reply==0x1B)    return TRUE;
    else return FALSE;

}


int contains_nonprintable( char *string)
{
    register size_t tel;

    for (tel=0;tel<strlen(string);tel++)
	if (!isalnum(string[tel])) return TRUE;
    return FALSE;
}


/**************************************************************************
 old_style display file contents page by page on screen
 activated by shift-s
*/
int old_show_file(char *filename)
{
    FILE *stream;
    int key;
    int line;
    char buf[82];
    int current_linewidth;
    int old_linewidth=0;
	
    dos_error_auto_fail=TRUE;
    if ((stream=fopen(filename,"rt")) == NULL )
    {
	show_error("Cannot show this file");
	return FAILURE;
    }
    dos_error_auto_fail=FALSE;
    _settextcolor( (short) file_color );
    _setbkcolor( (long) screen_bg_color );
    _clearscreen( _GWINDOW );
    _settextposition( 1, 1 );
    line=0;
    _wrapon( _GWRAPOFF );
		    
    /* read 80 chars (and add null terminator) */
    while (fgets( buf, 81, stream ))
    {
	line++; 
	
	/* a newline is not always present, so always strip newline character */        
	if (buf[strlen(buf)-1]=='\n')  buf[strlen(buf)-1]='\0';

	_outtext(buf);
	
	/* and add new line ourself */ 
	current_linewidth=strlen(buf);
	if (current_linewidth || (!current_linewidth && old_linewidth!=80)) _outtext("\n");
	/* save this linewidth */
	old_linewidth=current_linewidth;
	
	if (line==20)
	{
	   line=0;
	   _settextcolor( (short) info_text_color );
	   _outtext("*** Press Esc to cancel, any other key to continue ***");
	   _settextcolor( (short) file_color );
	   if ((key=getkey())==ESC) break;
	   _outtext("\n");
	}
    }
    if (key!=ESC)
    {
	_settextcolor( (short) info_text_color );
	_outtext("\n*** Press any key to continue ***");
	getkey();
    }
    fclose(stream);
    _settextcolor( (short) file_color );
    return SUCCESS;
}


/* 
 * fgets replacement which terminates the read on CR, CRLF or LF
 * the cr, lf and crlf are part of the string, NULL is added
 */
char *fgetl(char *string, int maxlength, FILE *stream)
{        
    register int tel;             
    int result;
    int carriage_return=FALSE;        
    
    string[0]='\0';				/* if the first attempt fails... */
    for (tel=0;tel<maxlength-1;tel++)
    {
        result= (char) fgetc(stream);
        if (result==EOF) break;                 /* eof or error */
        if (result=='\r') carriage_return=TRUE; /* remember cr */
        string[tel]=(char) result;              /* store the character */
        if (result=='\n') break;                /* terminate on lf or crlf */    
        if (result!='\r' && carriage_return)
        {       
            ungetc(result,stream);              /* push back the character */
            tel--;
            break;                              /* terminate on cr */
        }    
    } 
    if (tel==(maxlength-1) || result==EOF) string[tel]='\0';	/* add NULL terminator */
    else string[++tel]='\0';
    
    if (result==EOF && !tel) return NULL; /* trying to read past EOF */
    else return (string); 
} 

         
/**************************************************************************
 scan the file and fill the pages array, then let show_pages() display
 the file contents page by page on screen
*/
int show_file(char *filename, int max_linewidth)
{
    FILE *stream;
    char *buf;
    long *pages;
    unsigned int page_nr;
    long *temp_new_pages;
    unsigned int max_pages=PAGES_PER_MEMBLOCK;
    char *still_reading;
    register int line;
    int Reply;

    buf = (char *) malloc(sizeof(char) * max_linewidth + 2);
    if (!buf)
    {
        show_error("Cannot allocate memory for line buffer");
    	return FAILURE;
    }	 
    pages = (long *) malloc(sizeof(long)*max_pages*LINES_PER_PAGE);
    if (!pages)
    {
        show_error("Cannot allocate memory for page buffer");
        return FAILURE;
    }    
    		 
    dos_error_auto_fail=TRUE;
    if ((stream=fopen(filename,"rb")) == NULL )
    {
	show_error("Cannot open this file");
	free(pages);
	free(buf);
	return FAILURE;
    }
    
    dos_error_auto_fail=FALSE;
    
    page_nr=0;
    working(TRUE);
    do
    {
	if (n_kbhit()) Reply = (char) getkey();
	if (Reply==0X1B)
	{
	    show_error("Partly read");
	    break;
	}
	
	pages[page_nr++] = ftell(stream);
	
	for (line=0;line<LINES_PER_PAGE;line++) 
	    /* read "max_linewidth" chars (and add null terminator) */
	    if (!(still_reading=fgetl( buf, max_linewidth+1, stream ))) break;
		                  
	if (page_nr==(max_pages-1)) 
	{     
	    max_pages+=PAGES_PER_MEMBLOCK;
	    temp_new_pages = (long *) realloc(pages,sizeof(long)*max_pages*LINES_PER_PAGE);
	    if (!temp_new_pages)
	    {
		show_error("Cannot allocate enough memory for page buffer");
		fclose(stream);
		free(pages);
		free(buf);
		working(FALSE);
		return FAILURE;
	    } else pages = temp_new_pages;
	}
    } while (still_reading);
    working(FALSE); 
    
    /* start showing the pages array */ 
    show_pages(stream,pages,page_nr,max_linewidth); 
    free(pages);
    free(buf);
    fclose(stream);
       
    return SUCCESS;
}    
 
 
void show_pages(FILE *stream,long *pages,unsigned int last_page_nr, int max_linewidth)
{
    int key=0;
    unsigned int page_nr=1;
    register int line;
    char *buf;
    char *expanded;
    char *still_reading;
    int mouse_clicks;
    int linewidth;
    int page_linewidth;
    int show_from_column=0; /* start showing the left-most page */
    char window_position[3];
    int row,col;            /* dummy */
    unsigned int shift;
        
    int start_search=FALSE;
    char *found=(char *) NULL;
    char search_string[50]={"\0"};
    register int search_line;
    
    static int tabwidth=0;
    static int wrap=FALSE;
    int tab_expand_overflow=FALSE;
    
    buf = (char *) malloc(sizeof(char) * max_linewidth + 2);
    if (!buf)
    {
        show_error("Cannot allocate memory for line buffer");
    	return;
    }	 
    expanded = (char *) malloc(sizeof(char) * max_linewidth + 2);
    if (!expanded)
    {
        show_error("Cannot allocate memory for line buffer");
        free(buf);
    	return;
    }	 
    
    if (wrap) _wrapon( _GWRAPON );
    else _wrapon( _GWRAPOFF );
	
    _settextcolor( (short) file_color );
    _setbkcolor( (long) screen_bg_color );
	
    
    do
    {
	if (start_search) /* scan the pages and lines for the string */
	{                 
	    /* position file pointer */
	    if (fseek(stream,pages[page_nr-1],SEEK_SET))
	    {
		show_error("Seek error");
		free(buf);
		free(expanded);
		return;
	    }
	    
	    for ( ;page_nr<=last_page_nr;page_nr++) 
	    {
		/* check for user canceling the search */
		if (n_kbhit())
		{  
		    key=getkey();
		    if (key==0x1B) break;
		}
	    
		/* update page number */
		show_pages_status_line(tabwidth,wrap,page_nr,last_page_nr,"");
				       
		for (search_line=0;search_line<LINES_PER_PAGE;search_line++)
		{    
		    /* read "max_linewidth" chars (and add null terminator) */
		    if (!(still_reading=fgetl( buf, max_linewidth+1, stream ))) break;
		    strlwr(buf);
		    if (found=strstr(buf,search_string)) break;
		} 
		if (found || !still_reading) break;
	    } 
	    if (!found) show_message("Not found");   
	    start_search=FALSE;
	    /* the page_nr is now correctly set, continue with normal mode */
	}
	  
	/* show a page */                    
	/* clear window */
	_clearscreen( _GWINDOW );
	_settextposition( 1, 1 );
      
	/* position file pointer */
	if (fseek(stream,pages[page_nr-1],SEEK_SET))
	{
	    show_error("Seek error"); 
	    free(buf);
	    free(expanded);
	    return;
	}
	/* show one page */ 
	page_linewidth=0;
	for (line=0;line<LINES_PER_PAGE;line++)
	{           
	    /* read "max_linewidth" chars (and add null terminator) */
	    if (!(still_reading=fgetl( buf, max_linewidth+1, stream ))) break;
	    
	    /* strip newline character */        
	    if (buf[strlen(buf)-1]=='\n')  buf[strlen(buf)-1]='\0';
	    /* strip carriage return character */        
	    if (buf[strlen(buf)-1]=='\r')  buf[strlen(buf)-1]='\0';
		    
	    /* process old find action */
	    /* the found pointer points to the correct string only */
	    /* when tabwidth=0, but search_line is still correct */
	    if (found && line==search_line)
	    {
		/* reset found */
		found=(char *) NULL;
		_settextcolor( (short) info_text_color );
	    }
	    
	    /* force to left-most block if in wrap mode */
	    if (wrap) show_from_column=0;
	    
	    if (!tabwidth)
	    {    
		linewidth=strlen(buf);
		if (linewidth>show_from_column) _outtext(buf+show_from_column);
	    } 
	    else
	    {
		if (TabExpand (expanded, buf, tabwidth, (unsigned int) max_linewidth)==FAILURE)
		    tab_expand_overflow=TRUE;
		linewidth=strlen(expanded);
		if (linewidth>show_from_column) _outtext(expanded+show_from_column);
	    }
	    /* skip new line if the line is spanning the screen in wrap mode */ 
	    if (((linewidth+80) % 80) || !wrap || (wrap && !linewidth)) _outtext("\n");
	    
	    /* reset the color after flagging a found line */
	    /* this is overhead on all pages but one but who cares */
	    if (line==search_line) _settextcolor( (short) file_color );
	    
	    /* update page_linewidth */
	    if (linewidth>page_linewidth) page_linewidth=linewidth;
	}
	  
	/* determine starting column and set the <,<>,> symbol */
	strcpy(window_position,"");
	if (!wrap)
	{
	    if (show_from_column) strcat(window_position,"<");
	    if (page_linewidth>(show_from_column+80)) strcat(window_position,">");
	}
	if (tab_expand_overflow)
	{
	    strcat(window_position,"*"); 
	    tab_expand_overflow=FALSE;   /* reset status */
	}    
	  
	/* show status line */
	show_pages_status_line(tabwidth,wrap,page_nr,last_page_nr,window_position);
		  
	/* wait for user intervention */
	while (!n_kbhit() && !mouse_button_pressed());
	      
	if (mouse_present) /* act upon mouse event */
	{      
	    mouse_clicks = read_left_button_queue(&row,&col);
	    if (mouse_clicks) key=K_PGDN;
	    mouse_clicks = read_right_button_queue(&row,&col);
	    if (mouse_clicks) key=K_PGUP; 
	    while (mouse_button_pressed()); /* button still down, do nothing */
	}
	
	if (n_kbhit()) /* act upon key event */          
	{
	    if ((key=getkey())==ESC) break;
	    if (key<256) key = tolower(key);
	    if (key=='q') break;
	}
	  
	/* handle both key and mouse event */  
	switch (key)
	{
	    case 'f': if (edit("Find unbroken string, down, case ignored:",search_string,48,"",ILLEGAL))
			 if (strlen(search_string))
			 {
			     start_search=TRUE;
			     strlwr(search_string);
			 }
		      _settextcolor( (short) file_color );
		      break;
	    case 'w': wrap ^=1;
		      if (wrap) _wrapon( _GWRAPON );
		      else _wrapon( _GWRAPOFF );
		      break;
	    case '0': tabwidth=0;
		      break;
	    case '1': tabwidth=1;
		      break;
	    case '2': tabwidth=2;
		      break;
	    case '3': tabwidth=3;
		      break;
	    case '4': tabwidth=4;
		      break;
	    case '5': tabwidth=5;
		      break;
	    case '6': tabwidth=6;
		      break;
	    case '7': tabwidth=7;
		      break;
	    case '8': tabwidth=8;
		      break;
	    case '9': tabwidth=9;
		      break; 
	    case '<':          
	    case K_CLE: shift=getshift();
			if ((shift & 1) || (shift & 2))  show_from_column=0; /* left or right shift is down */
	                else if (show_from_column>=80) show_from_column -= 80;
			break;
	    case '>':            
	    case K_CRI: shift=getshift();
			if ((shift & 1) || (shift & 2)) /* left or right shift is down */
	                {
	                    while ((page_linewidth-80)>show_from_column) show_from_column += 80;
	                }
	                else if (page_linewidth>(show_from_column+80)) show_from_column += 80;
			break;                
	    case K_INS: strcpy(buf,"");
			if (edit("Jump to page number",buf,10,"1234567890",LEGAL))
			{
			     page_nr=atoi(buf);
			     if (page_nr<1) page_nr=1;
			     if (page_nr>last_page_nr) page_nr=last_page_nr;
			}
			_settextcolor( (short) file_color );
			break;
	    case 'u':            
	    case K_CUP:            
	    case K_PGUP: if (page_nr>1) page_nr--;
			 break;
	    case 't':            
	    case K_HOME: page_nr=1;
			 break;
	    case 'b':            
	    case K_END: page_nr=last_page_nr;
			break; 
	    /* processed by default, but exclude them for future allocation */                  
	    case 'd':   
	    case K_CDN: 
	    case K_PGDN:            
	    default: if (page_nr<last_page_nr) page_nr++;
			 break;
	}
	 
    } while (TRUE);
    free(buf);
    free(expanded);
} /* end show_pages */

		   
void show_pages_status_line(int tabwidth, int wrap,
			    unsigned int page_nr, unsigned int last_page_nr,
			    char *horizontal_position)
{ 
    char buf[80];
    
    _settextposition( 21, 1 );
    _settextcolor( (short) info_text_color );
    sprintf(buf," ESC to cancel, Insert to jump, F to find.  Tab %d  Wrap %-3s  %-2s  Page: %u/%u",tabwidth,(wrap) ? "on" : "off",horizontal_position,page_nr,last_page_nr);
    _outtext(buf);
    _settextcolor( (short) file_color );
} 


/* TabExpand - expand tabs to spaces
 * Original Author:     George Spofford 
 * Added overflow check
 */
int TabExpand (char *to, char *from, int ntabsp, unsigned int max_length)
{
  char *t;
  char *f;
  int   nsp; /* # of spaces to add upon '\t' */

  for (t = to, f = from; *f; ++f)
    if (*f == '\t') 
    {
        /* nsp = # of sp. 'til next tab-stop */
        nsp = ntabsp - (((int) (t-to)) % ntabsp);
        if (((unsigned int) (t-to)+nsp) < max_length)
        {
	    memset (t, ' ', nsp); /* create whitespace */
	    t += nsp;
        }
        else /* overflow on filling whitespace */ 
        {   
           t[max_length]='\0';
           return FAILURE;   
        }
    }
    else
    {
        if ((unsigned int)(t-to) < max_length) *t++ = *f; /* copy char */
        else  /* overflow on copying chars */ 
        {   
            t[max_length]='\0';
            return FAILURE;   
        }
    }
    
  *t = '\0'; /* terminate target string */    
  
  return SUCCESS;
}
