#ifndef _KVALSET_
#define _KVALSET_
/*******************************************************************************
* FILE NAME: kvalset.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     KValueSet          - Creates and manages a value set control             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of KASEWORKS                                 *
*   (C) Copyright KASEWORKS, Inc 1993                                          *
*   All Rights Reserved                                                        *
*                                                                              *
*******************************************************************************/
#ifndef _ICONTROL_
  #include <icontrol.hpp>
#endif
#ifndef _IBITFLAG_
  #include <ibitflag.hpp>
#endif
#ifndef _ICOLOR_
  #include <icolor.hpp>
#endif

// Forward declarations for other classes:
class IPoint;
class ISize;
class IString;
class IRectangle;
class IColor;
class IWindowHandle;
class IResourceId;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class _Export KValueSet : public IControl  
{
  typedef IControl Inherited;
  typedef unsigned long Index;

  public:
    class Style;                                 // forward declaration

/*------------------------- Constructors ---------------------------------------
| You can construct instances of this class in the following ways:             |
|   -- By using the primary constructor.  This constructor takes seven         |
|      arguments, six of which are required:                                   |
|      - A unique ID for the control.                                          |
|      - A parent window.                                                      |
|      - An owner window.                                                      |
|      - A rectangle that defines the size and placement of the control        |
|        window.                                                               |
|      - An IPair object that defines the number of rows and columns 
|        displayed in the window.
|      - The style of the control.                                             |
|   -- From a dialog window.  This constructor requires two arguments:         |
|      - A unique ID for the control.                                          |
|      - A parent window.                                                      |
|   -- From a window handle.  This constructor requires one argument: the      |
|      window handle of the control.                                           |
------------------------------------------------------------------------------*/
    KValueSet ( unsigned long        windowId,
                IWindow*             parent,
                IWindow*             owner,
                const IRectangle&    initial,
                const IPair&         dimension,
                const Style&         style = defaultStyle() );
    KValueSet ( unsigned long        windowId,
                IWindow*             parent );
    KValueSet ( const IWindowHandle& handle );

    virtual ~KValueSet ( );

/*---------------------------------- Style -------------------------------------
| The following functions provide a means to set and query progress indicator  |
| styles:                                                                      |
|                                                                              |
|   Style - Nested class that provides static members that define the set of   |
|           valid value set styles.  These styles can be used in               |
|           conjunction with the styles defined by the nested classes          |
|           IWindow::Style and IControl::Style.  For example, you could        |
|           define an instance of the KValueSet::Style class and initialize    |
|           it like:                                                           |
|              KValueSet::Style style(KValueSet::vertical | IWindow::visible); |
|                                                                              |
|           An object of this type is provided when the value set              |
|           is created.  A customizable default is used if no styles are       |
|           specified.                                                         |
|                                                                              |
|           The declaration of the KValueSet::Style nested class is            |
|           generated by the INESTEDBITFLAGCLASSDEF2 macro.                    |
|                                                                              |
| The following functions provide a means of getting and setting the default   |
| style for this class:                                                        |
|   defaultStyle    - Returns the current default style.  This is the same as  |
|                     classDefaultStyle unless setDefaultStyle has been        |
|                     called.                                                  |
|   setDefaultStyle - Sets the default style for all subsequent progress       |
|                     indicators.                                              |
------------------------------------------------------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, KValueSet, IWindow, IControl);
static const Style
      classDefaultStyle,
      bitmapItems,
      iconItems,
      textItems,
      rgbItems,
      colorIndexItems,
      controlBorder,
      itemBorder,
      rightToLeft,
      scaleGraphics,
      ownerDraw;
    
    static Style defaultStyle ( );
    static void  setDefaultStyle ( const Style& style );

    typedef enum { text, icon, bitmap, rgb, colorIndex } ItemType;
    ItemType defaultItemType() { return typDefault; }

    KValueSet& setItem ( const IPair &item, const IResourceId&    resId );
    KValueSet& setItem ( const IPair &item, const IBitmapHandle&  handle );
    KValueSet& setItem ( const IPair &item, const IPointerHandle& handle );
    KValueSet& setItem ( const IPair &item, const IColor&         color );
    KValueSet& setItem ( const IPair &item, IColor::Color         index );
    KValueSet& setItem ( const IPair &item, const char*           string );

    KValueSet& setItemBmp ( const IPair &item, const unsigned long bmpId );
    KValueSet& setItemIco ( const IPair &item, const unsigned long icoId );

    KValueSet& setItemType ( const IPair &item, ItemType itemType );

    static IPair indexToItem(Index index);
    static Index itemToIndex(const IPair &item);

    IPair selectedItem();
    Index selectedIndex();

    KValueSet& selectItem(const IPair &item);
    KValueSet& selectIndex(Index index);

  private:
    unsigned short usRowCount;
    unsigned short usColumnCount;
    ItemType typDefault;
    KValueSet ( const KValueSet & );
    KValueSet operator = ( const KValueSet & );
    static Style currentDefaultStyle;
};    // KValueSet

INESTEDBITFLAGCLASSFUNCS(Style, KValueSet);

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _KVALSET_ */
