#ifndef _KENTRYFD_
#define _KENTRYFD_

#ifndef _IENTRYFD_
  #include <ientryfd.hpp>
#endif

class KValidator;

class _Export KEntryField : public IEntryField
{
   typedef IEntryField Inherited;
   public:
      KEntryField(unsigned long id,
                  IWindow *wndParent,
                  IWindow *wndOwner,
                  const IRectangle &initial,
                  const IResourceId &resText,
                  const IEntryField::Style style);
      KEntryField(unsigned long id,
                  IWindow *wndParent,
                  IWindow *wndOwner,
                  const IRectangle &initial,
                  const IEntryField::Style style);
      Boolean validate(unsigned long pos=-1);
      KValidator* validator() const;
      KEntryField& setValidator(KValidator *val);

      virtual ITextControl& setText(const IResourceId& text);
      virtual ITextControl& setText(const char* text);

      virtual IString text() const;

   private:
      KValidator* _validator;
};

#endif
