#define INCL_PM
#include <os2.h>
#include <kcmbhdr.hpp>
#include <ievent.hpp>
#include <ictlevt.hpp>

Boolean KComboHandler::dispatchHandlerEvent(IEvent& event)
{
   Boolean filtered = false;
   if (event.eventId() == WM_CONTROL)
   {                                   // Control event
      IControlEvent ctlEvent(event);
      unsigned long ulMsg = ctlEvent.parameter1().number2();
      switch(ulMsg)
      {
         case CBN_MEMERROR:
            filtered = memError(ctlEvent);
            break;

         case CBN_EFSCROLL:
            filtered = efScroll(ctlEvent);
            break;

         case CBN_LBSCROLL:
            filtered = lbScroll(ctlEvent);
            break;

         default: 
            filtered = false;
            break;
      }
      if (filtered)
         event.setResult(ctlEvent.result());      
   }
   return filtered;
}
