// Calendar Control Test

#include <windows.h>
#include "calendar.h"
#include "caltest.h"

extern "C" {
  long far pascal _export WndProc(HWND, UINT, WORD, LONG);
  int pascal WinMain(HINSTANCE, HINSTANCE, LPSTR, int);
}

static char *DAY_NAME[7] =
{
  "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
};

long far pascal _export WndProc(HWND hwnd, UINT message, WORD wParam,
  LONG lParam)
{
  switch (message)
  {
    case WM_CREATE:
      return 0;
    case WM_COMMAND:
      switch (wParam)
      {
        case ENABLE:
        {
          static BOOL enabled = TRUE;
          enabled = !enabled;
          EnableWindow(GetDlgItem(hwnd, CALENDAR2), enabled);
          return 0;
        }
        case CALENDAR1:
        {
          if (HIWORD(lParam) == CAL_CHANGE)
          {
            char s[35];
            DWORD d = SendDlgItemMessage(hwnd, CALENDAR1, CAL_GETDATE, 0, 0L);
            wsprintf(s, "%s, %s %d, %d",
              (char far *) DAY_NAME[day_of_week(d)],
              (char far *) MONTH_NAME[GETMONTH(d)],
              GETDAY(d), GETYEAR(d));
            SetDlgItemText(hwnd, TEXT1, s);
          }
          return 0;
        }
        case CALENDAR2:
        {
          if (HIWORD(lParam) == CAL_KILLFOCUS)
          {
            char s[35];
            DWORD d = SendDlgItemMessage(hwnd, CALENDAR2, CAL_GETDATE, 0, 0L);
            wsprintf(s, "%s, %s %d, %d",
              (char far *) DAY_NAME[day_of_week(d)],
              (char far *) MONTH_NAME[GETMONTH(d)],
              GETDAY(d), GETYEAR(d));
            SetDlgItemText(hwnd, TEXT2, s);
          }
          return 0;
        }
        case CALENDAR3:
        {
          return 0;
        }

        default:
          break;
      }
      break;
    case WM_CLOSE:
      DestroyWindow(hwnd);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0);
      return 0;
  }
  return DefDlgProc (hwnd, message, wParam, lParam);
}

#pragma argsused
int pascal WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
  HWND hwnd;
  MSG msg;

  if (!hPrevInstance)
  {
    WNDCLASS wndclass;
    wndclass.style = 0;
    wndclass.lpfnWndProc = (WNDPROC) WndProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = DLGWINDOWEXTRA;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName = NULL;
    wndclass.lpszClassName = "CALENDARTEST";
    RegisterClass (&wndclass);
  }

  hwnd = CreateDialog(hInstance, "CALENDARTEST", 0, NULL);

  SendDlgItemMessage(hwnd, CALENDAR1, CAL_SETDATE, 0, MAKEDATE(1, 15, 1994));
  SendDlgItemMessage(hwnd, CALENDAR1, CAL_FIRSTDATE, 0, MAKEDATE(1, 10, 1980));
  SendDlgItemMessage(hwnd, CALENDAR1, CAL_LASTDATE, 0, MAKEDATE(1, 10, 2000));
  SendDlgItemMessage(hwnd, CALENDAR2, CAL_SETDATE, 0, MAKEDATE(12, 7, 1941));
  SendDlgItemMessage(hwnd, CALENDAR3, CAL_SETDATE, 0, MAKEDATE(1, 15, 1994));

  SetFocus(GetDlgItem(hwnd, CALENDAR2));

  ShowWindow(hwnd, nCmdShow == SW_SHOWMAXIMIZED ? SW_SHOW : nCmdShow);
  UpdateWindow(hwnd);

  while (GetMessage(&msg, NULL, 0, 0))
    if (!IsDialogMessage (hwnd, &msg))
        DispatchMessage (&msg);

  return msg.wParam;
}

