#ifndef WCOMM_DEFINED
#define WCOMM_DEFINED
//**************************************************************************
// Class:   CommWindow                                                     *
//                                                                         *
// Purpose: Terminal emulation window.                                     *
//                                                                         *
//**************************************************************************

#include <iframe.hpp>
#include <icmdhdr.hpp>
#include <iedithdr.hpp>
#include <ientryfd.hpp>
#include <istattxt.hpp>
#include <icheckbx.hpp>
#include <iradiobt.hpp>
#include <iselhdr.hpp>
#include <ilistbox.hpp>
#include <ikeyhdr.hpp>
#include <istring.hpp>

class ACommFilter;
class CommEditHandler;
class CommMsgHandler;

class CommWindow : public IListBox,
		   public IKeyboardHandler
{
public:                               //Define the public Information
  CommWindow(unsigned long windowId, //Constructor for this class
	     IWindow *parent);
  Boolean         key(IKeyboardEvent &evt);
  void            lookForChallenge (IString &line);
  void            fontDialog();
  ACommFilter     *commFilter;
  void            timerTick(int count = -1);
  Boolean         cr2lf,
                  bs2del,
                  localecho;
private:                              //Define the private Information
  CommEditHandler     *editHandler;
  CommMsgHandler      *msgHandler;
};


class ACommFilter
{
public:
  virtual Boolean filter(IString &) = 0;
};


class ACommFilterStyle12 : public ACommFilter
{
public:
  Boolean filter(IString &);
};



class CommMsgHandler : public IHandler
{
public:
  CommMsgHandler(CommWindow *w) { commWindow = w; }
  Boolean dispatchHandlerEvent(IEvent &evt);
private:
  CommWindow    *commWindow;
};


class CommEditHandler : public IEditHandler
{
public:
  Boolean edit (IControlEvent &evt);
};


class AMatchSelectHandler;

class AMatchDialog : public IFrameWindow, public ICommandHandler
{
  public:                               //Define the public Information
    AMatchDialog(IWindow *parent,
		 IWindow *owner,
		 IWindow *commWin,
		 IString cName,
		 int     cIsRated,
		 int     cWildType,
		 int     isWhite,
		 int     isBlack,
		 IString cClock,
		 IString cOddsClock);        //Constructor for this class

    IEntryField    *clock,
                   *oddsClock,
                   *wildType;
    IRadioButton   *white,
                   *black,
                   *neutral;
    IStaticText    *opponent;
    ICheckBox      *rated,
                   *wild;
    IWindow        *commWind;   // save so we can set focus at end
    Boolean        initialRated,
                   initialWhite,
                   initialBlack;
    int            initialWildType;
    IString        initialClock,
                   initialOddsClock;

    AMatchSelectHandler *selectHdr;

  protected:
    Boolean command (ICommandEvent& cmdEvent);
};


class AMatchSelectHandler : public ISelectHandler
{
protected:
  virtual Boolean selected( IControlEvent &evt );
};

#endif

