/* mktime.c (emx+gcc) */

/* Regression test for mktime() */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main (int argc, char *argv[])
{
  char line[512];
  struct tm t;
  time_t x;

  if (argc == 2 && strcmp (argv[1], "-u") == 0)
    {
      putenv ("TZ=");
      tzset ();
    }
  else if (argc != 1)
    {
      puts ("Usage: mktime [<-u>]");
      return (1);
    }
  while (fgets (line, sizeof (line), stdin) != NULL)
    {
      if (sscanf (line, "%d/%d/%d %d:%d:%d",
                  &t.tm_year, &t.tm_mon, &t.tm_mday,
                  &t.tm_hour, &t.tm_min, &t.tm_sec) != 6)
        puts ("INVALID INPUT");
      else
        {
          t.tm_isdst = 0;
          --t.tm_mon; t.tm_year -= 1900;
          if ((x = mktime (&t)) == (time_t)-1)
            puts ("FAILURE");
          else
            printf ("%.2d/%.2d/%.2d %.2d:%.2d:%.2d %d %3d %lu\n",
                    t.tm_year + 1900, t.tm_mon + 1, t.tm_mday,
                    t.tm_hour, t.tm_min, t.tm_sec,
                    t.tm_wday, t.tm_yday, (unsigned long)x);
        }
    }
  return (0);
}
