/* memory.c (emx+gcc) */

#include <stdio.h>
#include <strings.h>

int main (void)
{
  char buf1[] = "this is a test string";
  char buf2[sizeof (buf1)];
  char *p;
  int i, n;

  n = strlen (buf1);
  if (n != sizeof (buf1) - 1)
    puts ("strlen error 1");

  if (strcmp ("a", "a") != 0)
    puts ("strcmp error 1");
  if (strcmp ("a", "b") >= 0)
    puts ("strcmp error 2");
  if (strcmp ("b", "a") <= 0)
    puts ("strcmp error 3");
  if (strcmp ("ab", "ac") >= 0)
    puts ("strcmp error 4");
  if (strcmp ("xc", "xb") <= 0)
    puts ("strcmp error 5");
  if (strcmp ("xx", "xxa") >= 0)
    puts ("strcmp error 6");
  if (strcmp ("xxa", "xx") <= 0)
    puts ("strcmp error 7");
  if (strcmp ("\xff", "\x01") <= 0)
    puts ("strcmp error 8");
  if (strcmp ("\xff", "\xfe") <= 0)
    puts ("strcmp error 9");
  if (strcmp ("\x01", "\xff") >= 0)
    puts ("strcmp error 10");
  if (strcmp ("\xfe", "\xff") >= 0)
    puts ("strcmp error 10");

  if (strncmp ("a", "ab", 1) != 0)
    puts ("strncmp error 1");
  if (strncmp ("a", "ab", 2) >= 0)
    puts ("strncmp error 1");
  if (strncmp ("ab", "a", 1) != 0)
    puts ("strncmp error 3");
  if (strncmp ("ab", "a", 2) <= 0)
    puts ("strncmp error 4");
  if (strncmp ("\xff", "\x01", 1) <= 0)
    puts ("strncmp error 5");
  if (strncmp ("\xff", "\xfe", 1) <= 0)
    puts ("strncmp error 6");
  if (strncmp ("\x01", "\xff", 1) >= 0)
    puts ("strncmp error 7");
  if (strncmp ("\xfe", "\xff", 1) >= 0)
    puts ("strncmp error 8");

  p = memchr (buf1, 'x', n);
  if (p != NULL)
    puts ("memchr error 1");
  p = memchr (buf1, ' ', 0);
  if (p != NULL)
    puts ("memchr error 2");
  p = memchr (buf1, 't', n);
  if (p != buf1)
    puts ("memchr error 3");
  p = memchr (buf1, 't', 0);
  if (p != NULL)
    puts ("memchr error 4");
  p = memchr (buf1, 'g', n);
  if (p != buf1+n-1)
    puts ("memchr error 5");
  p = memchr (buf1, 's', 3);
  if (p != NULL)
    puts ("memchr error 6");
  p = memchr (buf1, 's', 4);
  if (p != buf1+3)
    puts ("memchr error 7");

  if (strcpy (buf2, buf1) != buf2)
    puts ("strcpy error 1");

  if (memmove (buf1+0, buf1+1, n) != buf1+0)
    puts ("memmove error 1");
  if (memcmp (buf1, buf2+1, n) != 0)
    puts ("memcmp error 1");
  if (memmove (buf1+1, buf1+0, n) != buf1+1)
    puts ("memmove error 2");

  buf1[0] = buf2[0];
  if (memcmp (buf1, buf2, n+1) != 0)
    puts ("memcmp error 2");

  if (_memcount (buf1, 't', strlen (buf1)) != 4)
    puts ("_memcount error 1");

  if (memicmp (buf1, "ThIs", 4) != 0)
    puts ("memicmp error 1");
  if (memicmp (buf1, "ThIT", 4) >= 0)
    puts ("memicmp error 2");
  if (memicmp (buf1, "ThIr", 4) <= 0)
    puts ("memicmp error 3");

  if (strchr (buf1, 'X') != NULL)
    puts ("strchr error 1");
  if (strchr (buf1, 0) != buf1 + n)
    puts ("strchr error 2");
  if (strchr (buf1, 't') != buf1 + 0)
    puts ("strchr error 3");
  if (strchr (buf1, 'a') != buf1 + 8)
    puts ("strchr error 4");
  buf1[7] = 0;
  if (strchr (buf1, 'a') != NULL)
    puts ("strchr error 5");
  if (strchr (buf1 + 7, 0) != buf1 + 7)
    puts ("strchr error 6");

  buf1[7] = ' ';
  if (strrchr (buf1, 'X') != NULL)
    puts ("strrchr error 1");
  if (strrchr (buf1, 0) != buf1 + n)
    puts ("strrchr error 2");
  if (strrchr (buf1, 'g') != buf1 + n - 1)
    puts ("strrchr error 3");
  if (strrchr (buf1, 'a') != buf1 + 8)
    puts ("strrchr error 4");
  buf1[7] = 0;
  if (strrchr (buf1, 'a') != NULL)
    puts ("strrchr error 5");
  buf1[7] = ' ';
  if (strrchr (buf1, 't') != buf1 + 16)
    puts ("strrchr error 6");
  buf1[0] = 'X';
  if (strrchr (buf1, 'X') != buf1)
    puts ("strrchr error 7");
  if (strrchr (buf1+1, 'X') != NULL)
    puts ("strrchr error 8");

  buf1[0] = 't';
  if (strstr (buf1, "") != buf1)
    puts ("strstr error 1");
  if (strstr (buf1, "x") != NULL)
    puts ("strstr error 2");
  if (strstr (buf1, buf1) != buf1)
    puts ("strstr error 3");
  if (strstr (buf1, "t") != buf1)
    puts ("strstr error 4");
  if (strstr (buf1, "te") != buf1+10)
    puts ("strstr error 5");
  if (strstr (buf1, "ti") != NULL)
    puts ("strstr error 6");
  if (strstr (buf1, "g") != buf1+n-1)
    puts ("strstr error 7");

  strset (buf2, '*');
  _memswap (buf2, buf1, n+1);
  if (strcmp (buf2, "this is a test string") != 0)
    puts ("_memswap error 1");
  _memswap (buf2, buf1, n+1);

  memset (buf1, '*', n);
  if (strcmp (buf1, buf2) != 0)
    puts ("memset/strset error 1");

  if (memcmp ("a", "b", 1) >= 0)
    puts ("memcmp error 3");
  if (memcmp ("b", "a", 1) <= 0)
    puts ("memcmp error 4");
  if (memcmp ("\xff", "\x01", 1) <= 0)
    puts ("memcmp error 5");
  if (memcmp ("\xff", "\xfe", 1) <= 0)
    puts ("memcmp error 6");
  if (memcmp ("\x01", "\xff", 1) >= 0)
    puts ("memcmp error 7");
  if (memcmp ("\xfe", "\xff", 1) >= 0)
    puts ("memcmp error 8");

  if (ffs (0) != 0)
    puts ("ffs error 1");
  if (ffs (-1) != 1)
    puts ("ffs error 2");
  for (i = 0; i < 32; ++i)
    if (ffs (1 << i) != i + 1)
      printf ("ffs error 3, i=%d\n", i);
  if (ffs (6) != 2)
    puts ("ffs error 4");

  if (_memdif ("a", "b", 0) != _MEMDIF_EQ)
    puts ("_memdif error 1\n");
  if (_memdif ("ab", "xx", 2) != 0)
    puts ("_memdif error 2\n");
  if (_memdif ("ab", "ac", 2) != 1)
    puts ("_memdif error 3\n");
  if (_memdif ("ab", "ab", 2) != _MEMDIF_EQ)
    puts ("_memdif error 4\n");

  puts ("done");
  return (0);
}
