/* longlong.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>

#define GCC_2_2
#define PRINTF

static double pii = 3141592653589793238.0;
static double volatile d;
static unsigned long long volatile ull;

int main (void);
static long long input (const char *s);
static void print_ll (long long x);
#if !defined (PRINTF)
static void decimal_ll (long long x);
#endif


static long long input (const char *s)
{
  char buf[256];

  printf ("%s", s);
  fflush (stdout);
  if (fgets (buf, sizeof (buf), stdin) == NULL)
    exit (0);
  return (_atoll (buf));
}

#if !defined (PRINTF)

static void decimal_ll (long long x)
{
  long long d;
  int i, j, z, n;

  z = 0;
  for (i = 18; i >= 0; --i)
    {
      d = 1;
      for (j = 0; j < i; ++j)
        d *= 10;
      n = 0;
      while (d <= x)
        {
          ++n;
          x -= d;
        }
      if (z || n != 0 || i == 0)
        {
          z = 1;
          printf ("%d", n);
        }
    }
}

#endif


static void print_ll (long long x)
{
  unsigned long hi, lo;

#if defined (PRINTF)
  printf ("%Ld %Lu", x, x);
#else
  if (x >= 0)
    decimal_ll (x);
  else
    {
      printf ("-");
      decimal_ll (-x);
    }
#endif
  printf (" (0x");
  hi = (unsigned long)(x >> 32);
  lo = (unsigned long)x;
  if (hi != 0)
    printf ("%lx%.8lx", hi, lo);
  else
    printf ("%lx", lo);
  printf (")\n");
}



int main (void)
{
  long long x, y;

#if defined (GCC_2_2)
  print_ll ((long long)pii);
  ull = (unsigned long long)pii;
  print_ll ((long long)ull);
  pii *= 3.0;
  print_ll ((long long)pii);
  ull = (unsigned long long)pii;
  print_ll ((long long)ull);
#endif
  for (;;)
    {
      x = input ("x: ");
      y = input ("y: ");
      printf ("x=   "); print_ll (x);
      printf ("y=   "); print_ll (y);
      printf ("x+y= "); print_ll (x + y);
      printf ("x-y= "); print_ll (x - y);
      printf ("x*y= "); print_ll (x * y);
      printf ("x/y= "); print_ll (x / y);
      printf ("x%%y= "); print_ll (x % y);
      printf ("-x=  "); print_ll (-x);
      printf ("x|y= "); print_ll (x | y);
      printf ("x&y= "); print_ll (x & y);
      printf ("x^y= "); print_ll (x ^ y);
#if defined (GCC_2_2)
      printf ("x<<y="); print_ll (x << y);
      printf ("x>>y="); print_ll (x >> y);
#endif
      printf ("~x=  "); print_ll (~x);
      printf ("x<y= %d\n", x < y);
#if defined (GCC_2_2)
      printf ("x=   %g (signed)\n", (double)x);
      ull = (unsigned long long)x;
      printf ("x=   %g (unsigned)\n", (double)ull);
      d = (double)x;
      printf ("x(s)="); print_ll ((long long)d);
      ull = (unsigned long long)x;
      d = (double)ull;
      ull = (unsigned long long)d;
      printf ("x(u)="); print_ll ((long long)ull);
#endif
    }
  return (0);
}
