/* alarm.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

static void usage (void)
{
  fputs ("Usage: alarm [-sw]\n", stderr);
  exit (1);
}


static void handler (int sig)
{
  printf ("Signal %d received. Process stopped.\n", sig);
  exit (1);
}


int main (int argc, char *argv[])
{
  int c, wait_flag, sleep_flag;

  wait_flag = 0; sleep_flag = 0;
  if (argc == 2 && strcmp (argv[1], "-w") == 0)
    wait_flag = 1;
  else if (argc == 2 && strcmp (argv[1], "-s") == 0)
    sleep_flag = 1;
  else if (argc != 1)
    usage ();
  signal (SIGALRM, handler);
  alarm (4);
  if (sleep_flag)
    printf ("sleep(10): %d\n", sleep (10));
  else if (wait_flag)
    for (;;)
      ;
  else
    for (;;)
      {
        c = _read_kbd (0, 0, 0);
        if (c == 0)
          _read_kbd (0, 1, 0);
        else if (c == 0x1b)
          break;
        else if (c >= '0' && c <= '9')
          printf ("alarm=%d\n", alarm (c - '0'));
      }
  return (0);
}
