VERSION 2.00
Begin Form frmWinInfo 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   0  'None
   Caption         =   "Window Spy"
   ClientHeight    =   3495
   ClientLeft      =   1755
   ClientTop       =   2565
   ClientWidth     =   5415
   Height          =   3900
   Left            =   1695
   LinkTopic       =   "Form1"
   ScaleHeight     =   3495
   ScaleWidth      =   5415
   Top             =   2220
   Width           =   5535
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   0
      Left            =   2280
      TabIndex        =   3
      Top             =   840
      Width           =   2895
   End
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   5
      Left            =   2280
      TabIndex        =   13
      Top             =   2640
      Width           =   2895
   End
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   4
      Left            =   2280
      TabIndex        =   11
      Top             =   2280
      Width           =   2895
   End
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   3
      Left            =   2280
      TabIndex        =   9
      Top             =   1920
      Width           =   2895
   End
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   2
      Left            =   2280
      TabIndex        =   7
      Top             =   1560
      Width           =   2895
   End
   Begin TextBox txtWinInfo 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   285
      Index           =   1
      Left            =   2280
      TabIndex        =   5
      Top             =   1200
      Width           =   2895
   End
   Begin CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Default         =   -1  'True
      Height          =   375
      Left            =   240
      TabIndex        =   14
      Top             =   3000
      Width           =   4935
   End
   Begin Line Line1 
      X1              =   120
      X2              =   5280
      Y1              =   720
      Y2              =   720
   End
   Begin Label Label2 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Click mouse anywhere to close this window."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   5175
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Window Text:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   840
      Width           =   2055
   End
   Begin Label Label8 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Extended Style Flags:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   2640
      Width           =   2055
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Style Flags:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   2280
      Width           =   2055
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Parent Window:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1920
      Width           =   2055
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Window Handle:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   1560
      Width           =   2055
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Class Name:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1200
      Width           =   2055
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "Move mouse over the window you want information about."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   5175
   End
End
Option Explicit

'Keep track of the current window to eliminate unecessary updates
Dim currWindow As Integer

Sub cmdClose_Click ()
    Unload Me
End Sub

Sub cmdClose_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim i As Integer, xyPos As Long, hWnd As Integer
    Dim buff As String * 256

    'Get mouse position in screen pixels
    xyPos = GetMessagePos()

    'Get handle to window under mouse cursor
    hWnd = WindowFromPoint(xyPos)
    If hWnd <> currWindow Then
        'If window has changed, display new information
        i = GetWindowText(hWnd, buff, 256)
        txtWinInfo(0) = Left$(buff, i)
        i = GetClassName(hWnd, buff, 256)
        txtWinInfo(1) = Left$(buff, i)
        txtWinInfo(2) = "&H" & Right$("000" & Hex$(hWnd), 4)
        txtWinInfo(3) = "&H" & Right$("000" & Hex$(GetParent(hWnd)), 4)
        txtWinInfo(4) = "&H" & Right$("0000000" & Hex$(GetWindowLong(hWnd, GWL_STYLE)), 8)
        txtWinInfo(5) = "&H" & Right$("0000000" & Hex$(GetWindowLong(hWnd, GWL_EXSTYLE)), 8)
        currWindow = hWnd
    End If
End Sub

Sub cmdClose_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Unload Me
End Sub

Sub Form_Load ()
    Dim i As Integer, j As Long

    currWindow = 0

    'Center form on screen
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2

    'Prevent user from editing text boxes
    For i = 0 To 5
        j = SendMessage(txtWinInfo(i).hWnd, EM_SETREADONLY, True, 0&)
    Next i

    'To correctly handle pressing of the close button, we'll have all
    'mouse messages sent to the close button. The button's MouseMove
    'event will update the display of window information, and when a
    'MouseUp event occurs, we unload this form
    j = SetCapture(cmdClose.hWnd)

    'This is needed because the main form has set an hourglass cursor
    Screen.MousePointer = 0

End Sub

Sub Form_Paint ()
    Dim i As Integer

    'Since some programmers may not have the 3D panel
    'control, we'll just draw our own 3D shading
    
    Scalemode = 3   'Pixel mode will make this easier

    'Give our border a 3D look
    ForeColor = RGB(92, 92, 92)
    Line (0, 0)-(ScaleWidth - 2, ScaleHeight - 2), , B
    ForeColor = RGB(255, 255, 255)
    Line (1, ScaleHeight - 3)-(1, 1), , B
    Line -(ScaleWidth - 3, 1), , B
    ForeColor = RGB(0, 0, 0)
    Line (0, ScaleHeight - 1)-(ScaleWidth - 1, ScaleHeight - 1), , B
    Line -(ScaleWidth - 1, 0), , B

    'And make each text box look "sunken"
    For i = 0 To 5
        CurrentX = txtWinInfo(i).Left - 1
        CurrentY = txtWinInfo(i).Top + txtWinInfo(i).Height
        Line -Step(0, -(txtWinInfo(i).Height + 1)), RGB(92, 92, 92)
        Line -Step(txtWinInfo(i).Width + 1, 0), RGB(92, 92, 92)
        Line -Step(0, txtWinInfo(i).Height + 1), RGB(255, 255, 255)
        Line -Step(-(txtWinInfo(i).Width + 1), 0), RGB(255, 255, 255)
    Next i

End Sub

