#define INCL_DOS
#define INCL_BASE
#define INCL_DOSDEVIOCTL
#define INCL_DOSDEVICES
#define INCL_DOS
#define INCL_BASE
#define INCL_DOSDEVIOCTL
#define INCL_DOSDEVICES

/*---------------------------------------*/
/* A small test program for Com port I/O */
/*---------------------------------------*/
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include "typedefs.h"
#include "bc_io.h"
HFILE hCom;

BOOL OpenComPort(PSZ pszPortName);
ULONG GetBaudRate(HFILE hComTmp);
ULONG SetBaudRate(ULONG ulBaudRate);
ULONG SetComBitsParStop(BYTE bNoDataBits,BYTE bParity,BYTE bStopBits);
ULONG SetRWTimeOut(USHORT usReadTimeout,USHORT usWriteTimeout);
ULONG GetDCBInfo(void);
ULONG SetDCBInfo(void);
void ParameterError(PSZ szIn);
void BadExit(void);
void SystemError(PSZ szIn);
ULONG WriteBuffer2Com(PVOID pvBuffer,ULONG ulNoBytes);
ULONG ReadComBuffer(PVOID pvBuffer,ULONG ulNoBytes);
char  szOut[200];
char  szIn [200];    

/*---------------------------------------*/
/* A small test program for Com port I/O */
/*---------------------------------------*/
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include "typedefs.h"
#include "bc_io.h"
HFILE hCom;

BOOL OpenComPort(PSZ pszPortName);
ULONG GetBaudRate(HFILE hComTmp);
ULONG SetBaudRate(ULONG ulBaudRate);
ULONG SetComBitsParStop(BYTE bNoDataBits,BYTE bParity,BYTE bStopBits);
ULONG SetRWTimeOut(USHORT usReadTimeout,USHORT usWriteTimeout);
ULONG GetDCBInfo(void);
ULONG SetDCBInfo(void);
void ParameterError(PSZ szIn);
void BadExit(void);
void SystemError(PSZ szIn);
ULONG WriteBuffer2Com(PVOID pvBuffer,ULONG ulNoBytes);
ULONG ReadComBuffer(PVOID pvBuffer,ULONG ulNoBytes);
char  szOut[200];
char  szIn [200];    

main()
{
    BYTE bNoDataBits = 8;
    BYTE bParity     = 'N';
    BYTE bStopBits   = 1;
    ULONG ulNoBytes;
    
    printf("Atempting open COM1\n");

    if(!OpenComPort("COM1"))
    {
        printf("NOWAY!\n");
        BadExit();
    }
    else
    {
        printf("YESWAY!\n");
    }

    printf("Atempting bitrate query\n");
    printf("BaudRate = %d\n",GetBaudRate(hCom));

    printf("Atempting set bitrate\n");    
    if(SetBaudRate(19200))
    {
        printf("NOWAY!\n");
        BadExit();
    }
    else
    {
        printf("YESWAY!\n");
    }

    printf("Atempting bitrate query\n");
    printf("BaudRate = %d\n",GetBaudRate(hCom));        

    printf("Atempting set of line ctrl\n");    
    if(SetComBitsParStop(bNoDataBits,bParity,bStopBits))
    {
        printf("NOWAY!\n");
        BadExit();
    }
    else
    {
        printf("YESWAY!\n");
    }            

    printf("Atempting set of RW Timeouts\n");
    if(SetRWTimeOut(200,150))
    {
        printf("NOWAY!\n");
        BadExit();
    }
    else
    {
        printf("YESWAY!\n");
    }


    strcpy(szOut,"AT\0x13");
    ulNoBytes = 3;
    
    /*-----------------------------*/
    /* Atempting Write to Com port */
    /*-----------------------------*/
    printf("Atempting Write to Com port\n");
    printf("Bytes written = %d\n",WriteBuffer2Com(szOut,ulNoBytes));
    
    /*------------------------------*/
    /* Atempting Read from Com port */
    /*------------------------------*/
    printf("Atempting Read from Com port\n");
    printf("Bytes read = %d\n",ReadComBuffer(szIn,ulNoBytes));
    printf("%s\n",szIn);
    

    DosClose(hCom);
    DosExit(EXIT_PROCESS, 0);        

}

BOOL OpenComPort(PSZ pszPortName)
{
    ULONG  ulAction;

    APIRET rc;

    rc=DosOpen(pszPortName,&hCom,&ulAction,0L,FILE_NORMAL,FILE_OPEN,
               OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,NULL);

    return !rc;    
}

ULONG GetBaudRate()
{
    ULONG  ulNoBytes = 0;
    ULONG  ulBaudRate = 0;

    APIRET rc;    

    rc = DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_GETBAUDRATE,
                     NULL,0,NULL,
                     &ulBaudRate,sizeof(ulBaudRate),&ulNoBytes);

    return rc?0:ulBaudRate;
}

ULONG SetBaudRate(ULONG ulBaudRate)
{
    ULONG  ulParamlen = 4;

    APIRET rc;

    rc = DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_SETBAUDRATE,
                     &ulBaudRate,sizeof(ulBaudRate),&ulParamlen,
                     NULL,0,NULL);
    return rc;
}

ULONG SetComBitsParStop(BYTE bNoDataBits,BYTE bParity,BYTE bStopBits)
{
    BYTE   abParameters[3];
    ULONG  ulParamlen = 3;    
    APIRET rc;

    if((bNoDataBits < 5) || (bNoDataBits > 8))
        ParameterError("Number of databits is out of range");

    /*----------*/
    /* DataBits */
    /*----------*/
    abParameters[0] = bNoDataBits;

    /*--------*/
    /* Parity */
    /*--------*/
    switch(bParity)
    {
        case 'N' :
        case 'n' :
        {
            abParameters[1] = 0x00;
            break;
        }

        case 'O' :
        case 'o' :
        {
            abParameters[1] = 0x01;
            break;
        }

        case 'E' :
        case 'e' :
        {
            abParameters[1] = 0x02;
            break;
        }

        case 'M' :
        case 'm' :
        {
            abParameters[1] = 0x03;
            break;
        }

        case 'S' :
        case 's' :
        {
            abParameters[1] = 0x04;
            break;
        }

        default :
            ParameterError("Invalid Parity");
    }
    
    /*-----------*/
    /* Stop Bits */
    /*-----------*/
    switch(bStopBits)
    {
        case 1 :
        {
            abParameters[2] = 0x00;
            break;
        }

        case 2 :
        {
            abParameters[2] = 0x02;
            break;
        }

        default :
            ParameterError("Only 1 or 2 stop bits supported");
    }

    rc = DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_SETLINECTRL,
                     &abParameters,sizeof(abParameters),&ulParamlen,
                     NULL,0,NULL);

    return rc;
}

ULONG SetRWTimeOut(USHORT usReadTimeout,USHORT usWriteTimeout)
{
    /*-----------------------*/
    /* Update DCB to current */
    /*-----------------------*/
    if(GetDCBInfo()) SystemError("GetDCBFailed");

    /*-----------------*/
    /* Set RW Timeouts */
    /*-----------------*/
    DCBInfo.usWriteTimeout = usWriteTimeout;
    DCBInfo.usReadTimeout  = usReadTimeout;

    
    /*-------------------*/
    /* Commit new values */
    /*-------------------*/
    if(SetDCBInfo()) SystemError("SetDCBFailed");
}

void GetRWTimeOut(PUSHORT usReadTimeout,PUSHORT usWriteTimeout)
{
    /*-----------------------*/
    /* Update DCB to current */
    /*-----------------------*/
    if(GetDCBInfo()) SystemError("GetDCBFailed");

    /*-----------------*/
    /* Set RW Timeouts */
    /*-----------------*/
    *usWriteTimeout = DCBInfo.usWriteTimeout;
    *usReadTimeout  = DCBInfo.usReadTimeout;
}

ULONG WriteBuffer2Com(PVOID pvBuffer,ULONG ulNoBytes)
{
    ULONG  ulNoWritten;    
    APIRET rc;
    
    rc = DosWrite(hCom,pvBuffer,ulNoBytes,&ulNoWritten);
    if(rc != 0) SystemError("WriteBuffer2Com failed");

    return ulNoWritten;
}

ULONG ReadComBuffer(PVOID pvBuffer,ULONG ulNoBytes)
{
    ULONG  ulNoRead;    
    APIRET rc;

    rc = DosRead(hCom,pvBuffer,ulNoBytes,&ulNoRead);

    if(rc != 0) SystemError("ReadComBuffer failed");

    return ulNoRead;
}

ULONG GetDCBInfo(void)
{
    ULONG  ulNoBytes = 0;

    APIRET rc;
    rc = DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_GETDCBINFO,
                     NULL,0,NULL,
                     &DCBInfo,sizeof(DCBInfo),&ulNoBytes);

    return rc;
}

ULONG SetDCBInfo(void)
{
    ULONG  ulNoBytes;

    APIRET rc;
    
    ulNoBytes = sizeof(DCBInfo);
    
    rc = DosDevIOCtl(hCom,IOCTL_ASYNC,ASYNC_SETDCBINFO,
                     &DCBInfo,sizeof(DCBInfo),&ulNoBytes,
                     NULL,0,NULL);

    return rc;
}


void ParameterError(PSZ szIn)
{
    printf("Parameter error, %s",szIn);
    BadExit();
}
            
void BadExit(void)
{
    DosClose(hCom);
    DosExit(EXIT_PROCESS, 1);
}

void SystemError(PSZ szIn)
{
    printf("System error, %s\n",szIn);
    BadExit();
}