*******************************************************************
*: COMMAND FILE TELNUM.PRG                                        *
*: LOUIS HEMMI (STARSHIP LATIMER AND TORTILLA FACTORY)            *
*: 06/89 - Using Summer '87 with Louphone System                  *
*: 07/93 - Translated to Clipper 5                                *
*: 08/93 - Revamp user interface & array setup                    *
*: 04/94 - New and Improved, clean up for release                 *
*: Eliminated TELNUM.DBF and replaced with array manipulation     *
*: USED TO GENERATE THE TELEPHONE NUMBER (OR PART THEREOF)        *
*: ASSOCIATED WITH AN INPUT CHARACTER STRING.                     *
*: E.G. INPUT 'JANGLE0' AND GET '526-4530'                        *
*: NOTE: THE LETTERS 'Q' AND 'Z' ARE NOT INCLUDED,                *
*:       AND THE NUMBERS '1' AND '0' ARE NOT SUPPORTED.           *
* Prototype Table                                                 *
* - function main                                                 *
* - FUNCTION telnum(InWord)                                       *
* - Function Interface                                            *
*******************************************************************
function main
  LOCAL GETLIST
  clear
  Interface()                                    // get the user's desired number to look up
return(nil)

/**=====================================================================*
 *=====================================================================**/
FUNCTION telnum(InWord)
  LOCAL GETLIST
  LOCAL mOUTPUT,I,FRAME
  LOCAL aNUMBER,aLETTER,aELEMENT
  LOCAL TELDATA[28,2]                            // 28 ELEMENTS/2-COLUMNS (2 DIMENSIONAL) ARRAY
  LOCAL mNUMBER,OLDCOLOR,mROW
  LOCAL FirstTime := .T.
  LOCAL mPART [7,1]
  LOCAL mPOSITION,mSEARCH
  LOCAL mRETURN [7,1]

  TELDATA[1,1] := "0"
  TELDATA[1,2] := "0"
  TELDATA[2,1] := "1"
  TELDATA[2,2] := "1"
  SETCOLOR("W+/B,GR+,B")
  * NOTE THERE IS NEITHER A "Q" NOR A "Z"
  FOR I := 3 TO 18                               // FILL THE "LETTER" COLUMN (A TO P)
    TELDATA[I,1] := CHR(65+(I-3))                // CHR(65) = "A"
  NEXT
  FOR I := 20 TO 27                              // "R" TO "Y" (I.E., NO "Z")
    TELDATA[I,1] := CHR(65+(I-3))                // CHR(82) = "R"
  NEXT
  TELDATA[19,1] := "Q"                           // LETTER "Q"
  TELDATA[28,1] := "Z"                           // LETTER "Z"

  aELEMENT := 3
  mNUMBER := 2

  DO WHILE aELEMENT <= 18                        // RANGE OF EMPTY 2ND COLUMNS
    TELDATA[aELEMENT,2]   := STR(mNUMBER,1)      // THREE LETTERS PER NUMBER
    TELDATA[aELEMENT+1,2] := STR(mNUMBER,1)
    TELDATA[aELEMENT+2,2] := STR(mNUMBER,1)
    aELEMENT := aELEMENT + 3
    mNUMBER  := mNUMBER + 1
  ENDDO

  aELEMENT := 20
  mNUMBER := 7

  DO WHILE aElement <= 27                        // RANGE OF EMPTY 2ND COLUMNS
    TELDATA[aELEMENT,2]   := STR(mNUMBER,1)      // THREE LETTERS PER NUMBER
    TELDATA[aELEMENT+1,2] := STR(mNUMBER,1)
    TELDATA[aELEMENT+2,2] := STR(mNUMBER,1)
    aELEMENT := aELEMENT + 3
    mNUMBER  := mNUMBER + 1
  ENDDO
  TELDATA[19,2] := "*"                           // letter "Q"
  TELDATA[28,2] := "*"                           // letter "Z"

  FirstTime := .f.
  FOR I := 1 TO 7                                // input character string of length 7
    mPART[I,1] = SUBSTR(InWord,I,1)
  NEXT
  mOUTPUT := SPACE(1)
  FOR I := 1 TO 7
    mSEARCH := mPART[I]
    mRETURN[I] := ASCAN(TELDATA,{|TELDATA|TELDATA[1]=mPART[I,1]})
    mOUTPUT := mOUTPUT+TELDATA[mRETURN[I],2]
  NEXT
  mOUTPUT := LTRIM(mOUTPUT)
  mOUTPUT := SUBSTR(mOUTPUT,1,3)+"-"+SUBSTR(mOUTPUT,4,4)
RETURN(mOutPut)
* end of function telnum() ******************************************
/**:====================================================================
*:==============================i======================================
*:====================================================================*/

Function Interface

  LOCAL InWord,OUTPUT,FRAME,I,GETLIST,OldColor,OutPhone,lBadWord
  InWord := SPACE(7)
  CLEAR
  frame := space(8)+chr(176)
  SETCOLOR("W+/B,GR+,B")
  @0,0,MaxRow(),MaxCol() BOX FRAME
  ***********************************
  Oldcolor := SETCOLOR()
  setcolor([w+/b,gr/b,b])
  @02,20 say "ͻ"
  @03,20 say "by Louis Hemmi"
  @04,10 say "͸"
  @05,10 say "Purpose Translate Character String"
  @06,10 say ";  to Telephone Number      "
  @07,10 say "Esc      Equivalent.              "
  @08,10 say " to                               "
  @09,10 say "Quit    Unsupported Characters    "
  @10,10 say "     Appear as '*'            "
  @11,10 say "                                   "
  @12,10 say "         Ex: CHINESE->244-6373     "
  @13,10 say ";"
  @14,13 say " Enter String:  [#######] "      && 14,31 get inword
  @15,13 say "                          "
  @16,13 say " Phone Number: [###-####] "      && 16,30 say outword
  @17,13 say ";"

  DO WHILE LastKey() # 27
    TONE(2000,5)
    @14,31 get InWord PICTURE "@!"
    READ

    lBadWord := .f.
    do case
    case ";" $ InWord
      lBadWord := .t.
    case "'" $ InWord
      lBadWord := .t.
    case "/" $ InWord
      lBadWord := .t.
    case "." $ InWord
      lBadWord := .t.
    case "," $ InWord
      lBadWord := .t.
    case "[" $ InWord
      lBadWord := .t.
    case "]" $ InWord
      lBadWord := .t.
    case "\" $ InWord
      lBadWord := .t.
    case " " $ InWord
      lBadWord := .t.
    case Empty(InWord)
      lBadWord := .t.
    endcase
    IF lBadWord
      tone(2000,2)
      @23,00 SAY PADC(" Please Enter a String, or <ESC> to quit ",MaxCol(),[ ])
      inkey(0)
      @23,00 say space(MaxCol())
      LOOP
    else
      @16,30 say Telnum(InWord)
    ENDIF

  ENDDO
RETURN (nil)
* END OF Function Interface *******************************
* END OF Function Interface *******************************

**
/*
letter number
------ ------
0      0
1      1
A      2
B      2
C      2
D      3
E      3
F      3
G      4
H      4
I      4
J      5
K      5
L      5
M      6
N      6
O      6
P      7
Q      *
R      7
S      7
T      8
U      8
V      8
W      9
X      9
Y      9
Z      *
*/

