//      This source was last touched on 04/18/90
//      and except for some comments it has not changed.
//      so parden the bad programming or flaws you might find,
//      I have learned _much_ since then.
//
//      Peter Birch
//      06/07/93
//      Microsoft C
//      Please do not remove my name from this source
//      or charge others for this program, Thank you!

#define ERR_BUF 1       /* be able to write errout to its own file */
#define SYSTEM  0       /* 1 for system, 0 for spawn() */

#include <dos.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>
#include <stdio.h>
#include <ctype.h>
#include <io.h>

#if ERR_BUF
    #include <fcntl.h>
    #include <sys\types.h>
    #include <sys\stat.h>
#endif

#if _MSC_VER < 800
    #define _MK_FP(seg,ofs)  ((void far *) \
            (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

#define INIT_MY_REGS    unsigned int    my_es, my_ds, my_di, my_si, my_bp,\
                                        my_sp, my_bx, my_dx, my_cx, my_ax,\
                                        my_ip, my_cs, my_flags


#define RESTORE_ALL_REGS r.es = my_es; r.ds = my_ds; r.di = my_di; r.si = my_si;\
                         r.bp = my_bp; r.sp = my_sp; r.bx = my_bx; r.dx = my_dx;\
                         r.cx = my_cx; r.ax = my_ax; r.ip = my_ip; r.cs = my_cs;\
                         r.flags = my_flags

#define SAVE_ALL_REGS    my_es = r.es; my_ds = r.ds; my_di = r.di; my_si = r.si;\
                         my_bp = r.bp; my_sp = r.sp; my_bx = r.bx; my_dx = r.dx;\
                         my_cx = r.cx; my_ax = r.ax; my_ip = r.ip; my_cs = r.cs;\
                         my_flags = r.flags

typedef struct
{
    unsigned es, ds, di, si, bp, sp,
                 bx, dx, cx, ax, ip, cs,
                 flags;
} INTERRUPT_REGS;


/* internal function prototypes */
void interrupt cdecl far int21_handler (INTERRUPT_REGS r);
int is_redirected (void);
void puttext (unsigned char);
void cdecl main (int argc, char *argv[]);

/* Space to save original int 21 vector owner, Pointer to a void function */
void (interrupt cdecl far *int21_vector)();
int redirect_stdout;  /* Remember whether my output is redirected to a file */
union REGS r;

int redirect_stderr = 0;

#if ERR_BUF
    /* 5K buffer for text being written to stderr */
    char err_buf[5120];
    char *err_file;
    int err_handle;
    char *err_buf_ptr = err_buf;
    int err_buf_overrun = 0;
#endif



int _cdecl main (int argc, char *argv[])
{

#if SYSTEM
    char command[ 128];          /* holds command to DOS */
#endif

    int loop = 1,
        i,
        error_return;

    while (argv[loop][0] == '-' || argv[loop][0] == '/')
    {
        switch (argv[ loop][ 1])
        {
            case 'E':
            case 'e':
                ++redirect_stderr;
                dup2(fileno(stdout), fileno(stderr));
                break;
#if ERR_BUF
            case 'F':
            case 'f':
                i = 2;
                while (argv[ loop][ i] == ' ')
                    ++i;
                err_file = &argv[ loop][ i];
                break;
#endif
        }
        ++loop;
    }

    if ((argc - loop) < 1)      /* not enough command line arguments */
    {
#if ERR_BUF
        char *err = "\n\rSyntax: tee [-E] [-Ffilename] command [param1 [param2 [...]]]\n\r-E to redirect stderr as well as stdout\n\r-Ffilename to also send stderr to filename";
#else
        char *err = "\n\rSyntax: tee [-E] command [param1 [param2 [...]]]\n\r-E to redirect stderr as well as stdout";
#endif
        while (*err)
        {
            puttext (*err++);
        }
        return;
    }

#if SYSTEM
    /* build command line for system */
    command[0] = '\0';
    for (; loop < argc; ++loop)
    {
        strcat (command, argv[ loop]);
        strcat (command, " ");
    }
#endif

    redirect_stdout = is_redirected();

    /* save old interrupt 21 vector */
    int21_vector = _dos_getvect (0x21);

    /* set int21 to call my interrupt function */
    _dos_setvect (0x21, int21_handler);

#if SYSTEM
    /* execute program passed on command line */
    error_return = system (command);
#else
    error_return = spawnvp (P_WAIT, argv[ loop], &argv[ loop]);
#endif

    /* restore int21 handler to original function */
    _dos_setvect (0x21, int21_vector);

    flushall();

#if ERR_BUF
    /* write err_buf to file specified */
    if (err_file && *err_file)
    {
        static char err_message[] = "\nToo many errors, output truncated!";
        err_handle = open (err_file, O_TRUNC | O_TEXT | O_WRONLY | O_CREAT,
                            S_IREAD | S_IWRITE);
        if (err_handle > 0)
        {
            write (err_handle, err_buf, strlen (err_buf));
            if (err_buf_overrun)
            {
                write (err_handle, err_message, sizeof (err_message));
            }
            close (err_handle);
        }
    }
#endif

    return (error_return);

} /* main() */

/* my int 21 handler */
void interrupt cdecl far int21_handler (INTERRUPT_REGS r)
{
    INIT_MY_REGS;

    SAVE_ALL_REGS;

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    *  if there is DOS redirection, first I do my thing, and then
    *  I restore all the registers and let DOS do its thing.
    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    switch (r.ax >> 8)               /* AH */
    {
        case 0x02: /* function 2 (display character in dl register) */
            puttext ((unsigned char)(r.dx & 0xff));  /* dl */
            /* let dos handle redirection */
            if (redirect_stdout)
            {
                RESTORE_ALL_REGS;
                _chain_intr (int21_vector);
            }
            break;

        case 0x06: /* function 6 (direct console i/o) */
            /* output requested? */
            if ((unsigned char)(r.dx & 0xff) != 0xff )  /* dl */
            {
                puttext ((unsigned char)(r.dx & 0xff)); /* dl */
                /* let dos handle redirection */
                if (redirect_stdout)
                {
                    RESTORE_ALL_REGS;
                    _chain_intr (int21_vector);
                }
            }
            else
            {
                _chain_intr (int21_vector);
            }
            break;

        case 0x09:   /* function 9 (print dollar-sign delimited string) */
        {
            char far *ptr = _MK_FP (r.ds, r.dx);
            while (*ptr != '$')
            {
                puttext (*ptr++);
            }
            /* let dos handle redirection */
            if (redirect_stdout)
            {
                RESTORE_ALL_REGS;
                _chain_intr (int21_vector);
            }
            break;
        }

        case 0x40: /* function 40 (write to file handle) */
        /* write to stdout or stderr? */
        if (r.bx == 1 || r.bx == 2)
        {
            char far *ptr = _MK_FP (r.ds, r.dx);
            while (r.cx-- > 0)
            {
                puttext (*ptr++);
            }
            r.cx = r.ax = my_cx;
            r.flags = 0;
#if ERR_BUF
            /* get stderr to my buffer */
            if (r.bx == 2 && err_file)
            {
                if (err_buf_ptr + r.cx < err_buf + sizeof (err_buf)-1)
                {
                    ptr = _MK_FP (r.ds, r.dx);
                    /* mixed model strncat() */
                    while (r.cx--)
                    {
                        *err_buf_ptr++ = *ptr++;
                    }
                    r.cx = my_cx;
                }
                else
                {
                    ++err_buf_overrun;
                }
            }
#endif
            /* let dos handle redirection */
            if (redirect_stdout &&
            (r.bx == 1 || (r.bx == 2 && redirect_stderr)))
            {
                RESTORE_ALL_REGS;
                _chain_intr (int21_vector);
            }
            }
            else
            {
                _chain_intr (int21_vector);
            }
            break;

        default: /* call original int21_vector */
            _chain_intr (int21_vector);
            break;
    }
}

/* ======================================================================== */
int is_redirected (void)        /* Is stdout redirected to a file */
{
    r.x.ax = 0x4400;
    r.x.bx = 0x0001;    /* 1 = stdout */
    int86 (0x21, &r, &r);
    return (!(r.x.dx & 0x0082));
}

/* ======================================================================== */
void puttext (unsigned char ch)        /* Write ch to the display */
{
    int col;
    if (ch == '\t')               /* Expand tabs to spaces */
    {
        r.h.ah = 0x03;      /* Get current cursor column */
        r.h.bh = 0x00;
        int86 (0x10, &r, &r);
        col = r.h.dl % 8;
        if (col == 0)
        {
            col = 8;
        }
        while (col-- > 0)
        {
            puttext (' ');
        }
    }
    else
    {
        r.h.ah = 0x0e;      /* Write char to display */
        r.h.al = ch;
        r.h.bh = 0x00;
        int86 (0x10, &r, &r);
    }
}

