ECHO OFF
CLS
rem     This BAT file provides an example use of LANLOG's report
rem     generation utility LLREPORT.COM.
rem
rem           Title: Concatenate Meter reports into single DOS file
rem     Description: Runs LLREPORT.COM to create report of meter files in
rem                  the current directory and add them to a file
rem                  containing other similar reports.

:START

ECHO    ͻ
ECHO             ADDING METER REPORTS TO C:\ALL.REP           
ECHO    ͹
ECHO                                                          
ECHO     This batch file reports on any meter files found in  
ECHO     the current directory and concatenates them to a     
ECHO     file in the root directory - C:\ALL.REP.             
ECHO                                                          
ECHO    ͼ

rem     check for a total file delete if neccessary.

if exist DONE.MSG goto TELDONE

:REPT

ECHO    This directory already done! > DONE.MSG

rem     Put the current directory into report file

ECHO . >> C:\ALL.REP
ECHO .  Meter file reports from the directory: >> C:\ALL.REP
ECHO . >> C:\ALL.REP
CD >> C:\ALL.REP
ECHO . >> C:\ALL.REP

rem     Run the LLREPORT.COM to produce report to C:\ALL.REP

ECHO .
ECHO .  Generating a report of all meter files to file:
ECHO .
ECHO .                  C:\ALL.REP
ECHO .
ECHO .  Please be patient.....

LLREPORT *.MET >> C:\ALL.REP

rem     Note: this command presumes a copy of LLREPORT is present
rem     in the current directory or that it can be found in your PATH

goto QUIT

:TELDONE

CLS

ECHO    ͻ
ECHO                           WARNING!                       
ECHO    ͹
ECHO                                                          
ECHO     This directory's meter files have already been       
ECHO     included in the C:\ALL.REP file.                     
ECHO                                                          
ECHO     If you wish to add them again or have created a new  
ECHO     C:\ALL.REP delete the file:                          
ECHO                                                          
ECHO                           DONE.MSG                       
ECHO                                                          
ECHO     in this directory.                                   
ECHO                                                          
ECHO    ͼ

goto QUIT

:ERROR

rem     user didn't provide a command line parameter for created data
rem     file name.

CLS

ECHO    ͻ
ECHO                         SYNTAX ERROR                     
ECHO    ͹
ECHO                                                          
ECHO     This BATCH file expects two parameters, the first is 
ECHO     a file name for the meter file report, the second a  
ECHO     file name for the LANLOG.TOT file report.            
ECHO                                                          
ECHO     The correct syntax:                                  
ECHO                                                          
ECHO                   REPTEG03 {name1} {name2}               
ECHO                                                          
ECHO     where {nameX} are any valid DOS path.                
ECHO                                                          
ECHO     Example:                                             
ECHO                                                          
ECHO               REPTEG03 ACCOUNTS.IND ACCOUNTS.ALL         
ECHO                                                          
ECHO    ͼ

rem     The End

:QUIT

ECHO ON
