{*********************************************************}
{*                  OPDEFINE.INC 1.10                    *}
{*      Assorted conditional compilation directives      *}
{*     Copyright (c) TurboPower Software 1988, 1989.     *}
{*                 All rights reserved.                  *}
{*********************************************************}

{This compiler directive controls whether the Float type in OPSTRING is
 defined as an Extended or a Real. It also controls the inclusion of certain
 methods that apply only to 8087 numeric types.}

  {$N-}

{This directive forces all units to contain an initialization block, even
 those that do not have any actual initialization code. Adding these blocks
 helps to work around a bug in Turbo Debugger 1.5.}

  {.$DEFINE InitAllUnits}

{This directive determines whether or not OPCRT is compiled in such a way as
 to coexist peacefully with the standard Turbo Pascal CRT unit.}

  {.$DEFINE UseCrt}

{This directive enables mouse support in several of the units, as well as in
 some of the demo programs}

  {.$DEFINE UseMouse}

{This directive enables scroll bar support in OPWINDOW and units that
 depend on it}

  {.$DEFINE UseScrollBars}

{This directive enables hot spot support in OPWINDOW and units that depend
 on it}

  {.$DEFINE UseHotSpots}

{This directive enables shadowing support in OPWINDOW}

  {$DEFINE UseShadows}

{This directive enables the AdjustWindow, ResizeWindow, MoveWindow, and other
 methods in OPWINDOW}

  {$DEFINE UseAdjustableWindows}

{If FourByteDates is defined, dates in OPDATE are stored as longints, giving a
range of 01/01/1600-12/31/3999. If it isn't defined, dates are stored as words,
giving a range of 01/01/1900-12/31/2078.}

  {$DEFINE FourByteDates}

{The following directive enables support for editing of dates in OPEDIT and
OPENTRY. It also enables certain options in OPDIR, OPEDIT, OPENTRY, and
OPFORM.}

  {$DEFINE UseDates}

{The following directive enables support for BCD reals in OPEDIT, OPENTRY and
OPFORM}

  {.$DEFINE UseBCD}

{The following directive enables support for pick list fields in OPENTRY}

  {$DEFINE PickListFields}

{Deactivate the following define if the caller of OPSORT needs to perform
 heap allocation or deallocation while the sort is in progress, that is,
 within the user-defined procedures of the sort. For large sorts with
 element size exceeding 4 bytes, FastDispose makes a significant difference
 in the speed of heap deallocation when the sort is finished.}

  {$DEFINE FastDispose}

{If the following directive is defined, OPTSR and OPSWAP try to
 thwart SideKick}

  {.$DEFINE ThwartSideKick}

{If the following directive is defined, streams support is enabled in all
 objects}

  {$DEFINE UseStreams}

{If the following directive is defined, XMS support is enabled in OPSWAP and
 OPEXEC. IMPORTANT: in that case you must also define the SupportXms constant
 in OPSWAP.ASM and OPEXEC.ASM and reassemble those files. Failure to do so will
 cause an error when recompiling the units.}

  {$DEFINE SupportXms}                        {!!.02}

{If the following directive is defined, OPDRAG support will be included in all
 units containing command windows.}

  {.$DEFINE UseDrag}

{The following define controls how various OPRO units react to the heap
 changes of TP6. There's no need for you to modify it.}

  {$IFDEF Ver60}
  {$DEFINE Heap6}
  {$ENDIF}

  {$IFDEF Ver70}
  {$DEFINE Heap6}
  {$ENDIF}
