/* CURSOR
 *
 * Copyright (C) 1993 Brian Mancuso
 * All rights resurved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permited provided that the following
 * conditions are met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributino in binary form must reproduce the above copyright
 *    notice, this list of conditions, and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSIBILITY OF SUCH DAMAGE.
 *
 */

/*	cursor.c: utility to set cursor type from command line */

#if !defined(__TURBOC__) && !defined(__BORLANDC__)
#error "This program was writen with Borland C/C++ system calls."
#error "Modifacation will be necessary to make CURSOR on this system."
#endif

#include <stdio.h>
#include <conio.h>			/* for cursor types */
#include <string.h>
#include <stdlib.h>			/* for exit()       */

/* Copyright string */
char Copyright[] = "CURSOR Version 1.00 Copyright (C) 1993 Brian Mancuso";

/* Program path as specified from argv[0] */
char* progname;

/* Silent mode de op  -s  */
int silent;

/* Temporary variable to store cursor type
	when evaluating command line args

	-b		solid block			_SOLIDCURSOR
	-u		line underscore     _NORMALCURSOR
	-n		no cursor			_NOCURSOR
*/
int cursortype;

void usage(void);				/* displays usage information */

/*MAIN*/
int main(int ac, char** av)
{
	int i = 1;
	int ai = 1;

	progname = av[0];
	strlwr(progname);

	if (ac < 2) {
		printf("%s\n",Copyright);
		printf("This utility sets the cursor type.\n");
		usage();
		/*NEVERREACHED*/
	}

	while (av[ai][0]) {
		if (av[ai][0] == '-') {
			while (av[ai][i]) {
				switch (av[ai][i]) {
				case 'b':
					cursortype = _SOLIDCURSOR;
					break;
				case 'u':
					cursortype = _NORMALCURSOR;
					break;
				case 'n':
					cursortype = _NOCURSOR;
					break;
				case 's':
					silent = 1;
					break;
				default:
					printf("%s\n",Copyright);
					printf("Unrecogized option \'%c\'\n",av[ai][i]);
					usage();
					/*NEVERREACHED*/
				}
				i++;
			}
			i = 1;
		}
		ai++;
	}

	if (!silent)
		printf("%s",Copyright);

	_setcursortype(cursortype);
	return 0;
}

void usage()
{
	printf("\nUsage:   %s [options]\n",progname);
	printf("\nOptions: -b      Set the cursor type to a solid block cursor");
	printf("\n         -u      Set the cursor type to an underscore cursor");
	printf("\n         -n      Disablet the cursor");
	printf("\n         -s      Do not display copyright information");
	printf("\n");

	exit(1);
}